/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import cottons.utils.Files;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.AbstractBoxRenderer;
import io.intino.konos.builder.codegeneration.BoxConfigurationRenderer;
import io.intino.konos.builder.codegeneration.BoxRenderer;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.ui.UIAccessorCreator;
import io.intino.konos.builder.codegeneration.datalake.NessJMXOperationsRenderer;
import io.intino.konos.builder.codegeneration.datalake.TanksConnectorsRenderer;
import io.intino.konos.builder.codegeneration.datalake.mounter.MounterRenderer;
import io.intino.konos.builder.codegeneration.datalake.process.ProcessCoordinatorRenderer;
import io.intino.konos.builder.codegeneration.datalake.process.ProcessRenderer;
import io.intino.konos.builder.codegeneration.exception.ExceptionRenderer;
import io.intino.konos.builder.codegeneration.main.MainRenderer;
import io.intino.konos.builder.codegeneration.schema.SchemaRenderer;
import io.intino.konos.builder.codegeneration.services.jms.JMSRequestRenderer;
import io.intino.konos.builder.codegeneration.services.jms.JMSServiceRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXOperationsServiceRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXServerRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RESTResourceRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RESTServiceRenderer;
import io.intino.konos.builder.codegeneration.services.slack.SlackRenderer;
import io.intino.konos.builder.codegeneration.services.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.services.ui.dialog.DialogRenderer;
import io.intino.konos.builder.codegeneration.services.ui.dialog.DialogsRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplayRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplaysRenderer;
import io.intino.konos.builder.codegeneration.services.ui.resource.ResourceRenderer;
import io.intino.konos.builder.codegeneration.task.TaskRenderer;
import io.intino.konos.builder.codegeneration.task.TaskerRenderer;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.plugin.project.LegioConfiguration;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FullRenderer {
    @Nullable
    private final Project project;
    @Nullable
    private final Module module;
    private final KonosGraph graph;
    private final File gen;
    private final File src;
    private File res;
    private final String packageName;
    private final String boxName;
    private final String parent;
    private final boolean hasModel;

    public FullRenderer(@Nullable Module module, KonosGraph graph, File src, File gen, File res, String packageName) {
        this.project = module == null ? null : module.getProject();
        this.module = module;
        this.graph = graph;
        this.gen = gen;
        this.src = src;
        this.res = res;
        this.packageName = packageName;
        this.parent = this.parent();
        this.hasModel = this.hasModel();
        this.boxName = StringHelper.snakeCaseToCamelCase((String)this.boxName());
    }

    public void execute() {
        Files.removeDir((File)this.gen);
        this.schemas();
        this.exceptions();
        this.rest();
        this.tasks();
        this.jmx();
        this.jms();
        this.bus();
        this.slack();
        this.ui();
        this.box();
        this.main();
    }

    private void schemas() {
        new SchemaRenderer(this.graph, this.gen, this.packageName).execute();
    }

    private void exceptions() {
        new ExceptionRenderer(this.graph, this.gen, this.packageName).execute();
    }

    private void rest() {
        new RESTResourceRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
        new RESTServiceRenderer(this.graph, this.gen, this.res, this.packageName, this.boxName).execute();
    }

    private void jmx() {
        new JMXOperationsServiceRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
        new JMXServerRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
    }

    private void jms() {
        new JMSRequestRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
        new JMSServiceRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
    }

    private void tasks() {
        new TaskRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
        new TaskerRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
    }

    private void bus() {
        if (this.graph.nessClientList().isEmpty()) {
            return;
        }
        new ProcessRenderer(this.graph, this.src, this.packageName, this.boxName).execute();
        new ProcessCoordinatorRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
        new MounterRenderer(this.graph, this.src, this.packageName, this.boxName).execute();
        new TanksConnectorsRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
        if (this.module != null && ((LegioConfiguration)TaraUtil.configurationOf((Module)this.module)).model() != null) {
            new NessJMXOperationsRenderer(this.gen, this.src, this.packageName, this.boxName).execute();
        }
    }

    private void slack() {
        new SlackRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
    }

    private void ui() {
        new DisplayRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.parent, this.boxName).execute();
        new DialogsRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
        new DisplaysRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
        new DialogRenderer(this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
        new ResourceRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
        new UIRenderer(this.graph, this.src, this.gen, this.packageName, this.boxName).execute();
        new UIAccessorCreator(this.module, this.graph, this.parent).execute();
    }

    private void box() {
        new AbstractBoxRenderer(this.graph, this.gen, this.packageName, this.module, this.parent, this.hasModel).execute();
        new BoxRenderer(this.src, this.packageName, this.module, this.hasModel).execute();
        new BoxConfigurationRenderer(this.graph, this.gen, this.packageName, this.module, this.parent, this.hasModel).execute();
    }

    private String boxName() {
        if (this.module != null) {
            Configuration configuration = TaraUtil.configurationOf((Module)this.module);
            if (configuration == null) {
                return "";
            }
            String dsl = configuration.outDSL();
            if (dsl == null || dsl.isEmpty()) {
                return this.module.getName();
            }
            return dsl;
        }
        return "System";
    }

    private String parent() {
        try {
            if (this.module == null) {
                return null;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.module.getProject());
            Configuration configuration = TaraUtil.configurationOf((Module)this.module);
            List languages = configuration.languages();
            if (languages.isEmpty() || ((Configuration.LanguageLibrary)languages.get(0)).generationPackage() == null) {
                return null;
            }
            String workingPackage = ((Configuration.LanguageLibrary)languages.get(0)).generationPackage().replace(".graph", "");
            if (workingPackage != null && facade.findClass(workingPackage + ".box." + Formatters.firstUpperCase(((Configuration.LanguageLibrary)languages.get(0)).name()) + "Box", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.module)) != null) {
                return workingPackage.toLowerCase() + ".box." + Formatters.firstUpperCase(((Configuration.LanguageLibrary)languages.get(0)).name());
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return null;
    }

    private boolean hasModel() {
        return this.module != null && TaraUtil.configurationOf((Module)this.module) != null && this.hasModel(TaraUtil.configurationOf((Module)this.module));
    }

    private boolean hasModel(Configuration configuration) {
        return !configuration.languages().isEmpty();
    }

    private void main() {
        new MainRenderer(this.src, this.packageName, this.module).execute();
    }
}

