/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.ui;

import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.confidential.ui.service.ConfidentialResource;
import io.intino.konos.model.graph.editor.ui.service.EditorResource;
import io.intino.konos.model.graph.root.ui.service.RootResource;
import io.intino.konos.model.graph.rules.ExceptionCodes;
import io.intino.konos.model.graph.ui.UIService;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractUIService
extends Layer
implements Terminal {
    protected String port;
    protected String title;
    protected String favicon;
    protected String googleApiKey;
    protected Authentication authentication;
    protected List<Resource> resourceList = new ArrayList<Resource>();
    protected Service _service;

    public AbstractUIService(Node node) {
        super(node);
    }

    public String port() {
        return this.port;
    }

    public String title() {
        return this.title;
    }

    public String favicon() {
        return this.favicon;
    }

    public String googleApiKey() {
        return this.googleApiKey;
    }

    public UIService port(String value) {
        this.port = value;
        return (UIService)this;
    }

    public UIService title(String value) {
        this.title = value;
        return (UIService)this;
    }

    public UIService favicon(String value) {
        this.favicon = value;
        return (UIService)this;
    }

    public UIService googleApiKey(String value) {
        this.googleApiKey = value;
        return (UIService)this;
    }

    public Authentication authentication() {
        return this.authentication;
    }

    public List<Resource> resourceList() {
        return Collections.unmodifiableList(this.resourceList);
    }

    public Resource resource(int index) {
        return this.resourceList.get(index);
    }

    public List<Resource> resourceList(Predicate<Resource> predicate) {
        return this.resourceList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Schema> schemaList() {
        return this._service.schemaList();
    }

    public Schema schemaList(int index) {
        return this._service.schemaList().get(index);
    }

    public List<Exception> exceptionList() {
        return this._service.exceptionList();
    }

    public Exception exceptionList(int index) {
        return this._service.exceptionList().get(index);
    }

    public UIService authentication(Authentication value) {
        this.authentication = value;
        return (UIService)this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.authentication != null) {
            components.add(this.authentication.core$());
        }
        new ArrayList<Resource>(this.resourceList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("port", new ArrayList<String>(Collections.singletonList(this.port)));
        map.put("title", new ArrayList<String>(Collections.singletonList(this.title)));
        map.put("favicon", new ArrayList<String>(Collections.singletonList(this.favicon)));
        map.put("googleApiKey", new ArrayList<String>(Collections.singletonList(this.googleApiKey)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("UI#Service$Authentication")) {
            this.authentication = (Authentication)node.as(Authentication.class);
        }
        if (node.is("UI#Service$Resource")) {
            this.resourceList.add((Resource)node.as(Resource.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("UI#Service$Authentication")) {
            this.authentication = null;
        }
        if (node.is("UI#Service$Resource")) {
            this.resourceList.remove(node.as(Resource.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("port")) {
            this.port = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("title")) {
            this.title = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("favicon")) {
            this.favicon = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("googleApiKey")) {
            this.googleApiKey = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("port")) {
            this.port = (String)values.get(0);
        } else if (name.equalsIgnoreCase("title")) {
            this.title = (String)values.get(0);
        } else if (name.equalsIgnoreCase("favicon")) {
            this.favicon = (String)values.get(0);
        } else if (name.equalsIgnoreCase("googleApiKey")) {
            this.googleApiKey = (String)values.get(0);
        }
    }

    protected void sync$(Layer layer) {
        super.sync$(layer);
        if (layer instanceof Service) {
            this._service = (Service)layer;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Resource
    extends Layer
    implements Terminal {
        protected String path;
        protected Component uses;

        public Resource(Node node) {
            super(node);
        }

        public String path() {
            return this.path;
        }

        public Component uses() {
            return this.uses;
        }

        public Resource path(String value) {
            this.path = value;
            return this;
        }

        public Resource uses(Component value) {
            this.uses = value;
            return this;
        }

        public RootResource asRoot() {
            Layer as = this.a$(RootResource.class);
            return as != null ? (RootResource)as : (RootResource)this.core$().addFacet(RootResource.class);
        }

        public boolean isRoot() {
            return this.core$().is(RootResource.class);
        }

        public ConfidentialResource asConfidential() {
            Layer as = this.a$(ConfidentialResource.class);
            return as != null ? (ConfidentialResource)as : (ConfidentialResource)this.core$().addFacet(ConfidentialResource.class);
        }

        public boolean isConfidential() {
            return this.core$().is(ConfidentialResource.class);
        }

        public EditorResource asEditor() {
            Layer as = this.a$(EditorResource.class);
            return as != null ? (EditorResource)as : (EditorResource)this.core$().addFacet(EditorResource.class);
        }

        public boolean isEditor() {
            return this.core$().is(EditorResource.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
            map.put("uses", this.uses != null ? new ArrayList<Component>(Collections.singletonList(this.uses)) : Collections.emptyList());
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("uses")) {
                this.uses = (Component)((Object)NodeLoader.load(values, Component.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)values.get(0);
            } else if (name.equalsIgnoreCase("uses")) {
                this.uses = values.get(0) != null ? (Component)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Component.class) : null;
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Authentication
    extends Layer
    implements Terminal {
        protected String by;

        public Authentication(Node node) {
            super(node);
        }

        public String by() {
            return this.by;
        }

        public Authentication by(String value) {
            this.by = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("by", new ArrayList<String>(Collections.singletonList(this.by)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("by")) {
                this.by = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("by")) {
                this.by = (String)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
        public void resource(Predicate<Resource> filter) {
            new ArrayList<Resource>(AbstractUIService.this.resourceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void schema(Predicate<Schema> filter) {
            new ArrayList<Schema>(AbstractUIService.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void exception(Predicate<Exception> filter) {
            new ArrayList<Exception>(AbstractUIService.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Authentication authentication(String by) {
            Authentication newElement = (Authentication)AbstractUIService.this.core$().graph().concept(Authentication.class).createNode(this.name, AbstractUIService.this.core$()).as(Authentication.class);
            newElement.core$().set((Layer)newElement, "by", Collections.singletonList(by));
            return newElement;
        }

        public Resource resource(String path, Component uses) {
            Resource newElement = (Resource)AbstractUIService.this.core$().graph().concept(Resource.class).createNode(this.name, AbstractUIService.this.core$()).as(Resource.class);
            newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
            newElement.core$().set((Layer)newElement, "uses", Collections.singletonList(uses));
            return newElement;
        }

        public Schema schema() {
            Schema newElement = (Schema)AbstractUIService.this.core$().graph().concept(Schema.class).createNode(this.name, AbstractUIService.this.core$()).as(Schema.class);
            return newElement;
        }

        public Exception exception(ExceptionCodes code) {
            Exception newElement = (Exception)AbstractUIService.this.core$().graph().concept(Exception.class).createNode(this.name, AbstractUIService.this.core$()).as(Exception.class);
            newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
            return newElement;
        }
    }
}

