/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.utils;

import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import io.intino.konos.builder.utils.KonosUtils;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.Language;
import io.intino.tara.StashBuilder;
import io.intino.tara.io.Stash;
import io.intino.tara.magritte.Graph;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import tara.dsl.Konos;

public class GraphLoader {
    private static final Logger LOG = Logger.getInstance((String)"CreateKonosBoxAction: ");
    private static final Key<Object> PROBLEMS_VIEW_SESSION_ID_KEY = Key.create((String)"ProblemsViewSessionKey");
    private static final Key<Object> PROBLEMS_VIEW_FILES_KEY = Key.create((String)"ProblemsViewFiles");

    public static KonosGraph loadGraph(Module module) {
        Map<File, Charset> files = KonosUtils.findKonosFiles(module).stream().map(PsiFile::getVirtualFile).collect(Collectors.toMap(vf -> new File(vf.getPath()), VirtualFile::getCharset));
        if (!files.isEmpty()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StashBuilder stashBuilder = new StashBuilder(files, (Language)new Konos(), module.getName(), new PrintStream(out));
            Stash stash = stashBuilder.build();
            GraphLoader.processMessages(module.getProject(), out);
            if (stash == null) {
                return null;
            }
            return GraphLoader.loadGraph(stash);
        }
        return GraphLoader.loadGraph(new Stash[0]);
    }

    private static KonosGraph loadGraph(Stash ... stashes) {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(GraphLoader.class.getClassLoader());
        Graph graph = new Graph().loadStashes(new String[]{"Konos"}).loadStashes(stashes);
        Thread.currentThread().setContextClassLoader(currentLoader);
        return graph == null ? null : (KonosGraph)graph.as(KonosGraph.class);
    }

    private static void processMessages(Project project, ByteArrayOutputStream stream) {
        try {
            String messages = stream.toString("UTF-8");
            CompilationMessageProcessor processor = new CompilationMessageProcessor(project);
            processor.process(messages);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private static class CompilationMessageProcessor {
        private final StringBuilder outputBuffer = new StringBuilder();
        private final List<CompilerMessage> compilerMessages = new ArrayList<CompilerMessage>();
        private final Project project;

        public CompilationMessageProcessor(Project project) {
            this.project = project;
        }

        private void process(String output) {
            for (String line : output.split("\n")) {
                this.parse(line);
            }
            this.processMessages();
        }

        private void processMessages() {
            ProblemsView problemsView = ProblemsView.SERVICE.getInstance((Project)this.project);
            UUID id = CompilationMessageProcessor.getProblemsViewSessionId(this.project);
            problemsView.clearProgress();
            problemsView.clearOldMessages((CompileScope)new ProjectCompileScope(this.project), UUID.randomUUID());
            for (CompilerMessage compilerMessage : this.compilerMessages) {
                problemsView.addMessage(compilerMessage, id);
            }
        }

        private void parse(String output) {
            String text = output.trim();
            if (StringUtil.isNotEmpty((String)text)) {
                if (text.startsWith("%%c")) {
                    this.outputBuffer.append(text);
                } else if (text.startsWith("%%m")) {
                    this.outputBuffer.append(text);
                    this.processMessage();
                }
                if (text.endsWith("/%c") && !text.startsWith("%%c")) {
                    this.outputBuffer.append(text);
                }
            }
        }

        private void processMessage() {
            int columnInt;
            int lineInt;
            if (this.outputBuffer.indexOf("/%m") == -1) {
                return;
            }
            String text = this.handleOutputBuffer("%%m", "/%m");
            List<String> tokens = this.splitAndTrim(text);
            LOG.assertTrue(tokens.size() > 4, (Object)"Wrong number of output params");
            String category = tokens.get(0);
            String message = tokens.get(1);
            String url = tokens.get(2);
            String lineNum = tokens.get(3);
            String columnNum = tokens.get(4);
            try {
                lineInt = Integer.parseInt(lineNum);
                columnInt = Integer.parseInt(columnNum);
            }
            catch (NumberFormatException e) {
                LOG.error((Throwable)e);
                lineInt = 0;
                columnInt = 0;
            }
            CompilerMessageCategory kind = category.equals("error") ? CompilerMessageCategory.ERROR : (category.equals("warning") ? CompilerMessageCategory.WARNING : CompilerMessageCategory.INFORMATION);
            VirtualFile file = this.fileOf(url);
            CompilerMessageImpl compilerMessage = new CompilerMessageImpl(this.project, kind, message, file, lineInt, columnInt, (Navigatable)PsiManager.getInstance((Project)this.project).findFile(file));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Message: " + compilerMessage);
            }
            this.compilerMessages.add((CompilerMessage)compilerMessage);
        }

        private VirtualFile fileOf(String url) {
            return VfsUtil.findFileByIoFile((File)new File(url), (boolean)true);
        }

        private String handleOutputBuffer(String startMarker, String endMarker) {
            int end;
            int start = this.outputBuffer.indexOf(startMarker);
            if (start > (end = this.outputBuffer.indexOf(endMarker))) {
                throw new AssertionError((Object)("Malformed Tarac output: " + this.outputBuffer.toString()));
            }
            String text = this.outputBuffer.substring(start + startMarker.length(), end);
            this.outputBuffer.delete(start, end + endMarker.length());
            return text.trim();
        }

        private List<String> splitAndTrim(String compiled) {
            return ContainerUtil.map((Collection)StringUtil.split((String)compiled, (String)"#%%#%%%#%%%%%%%%%#"), String::trim);
        }

        private static UUID getProblemsViewSessionId(Project project) {
            UUID problemsViewSessionId = (UUID)project.getUserData(PROBLEMS_VIEW_SESSION_ID_KEY);
            if (problemsViewSessionId == null) {
                problemsViewSessionId = UUID.randomUUID();
                project.putUserData(PROBLEMS_VIEW_SESSION_ID_KEY, (Object)problemsViewSessionId);
            }
            return problemsViewSessionId;
        }
    }
}

