/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.schema;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.schema.SchemaTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.bool.BoolData;
import io.intino.konos.model.graph.date.DateData;
import io.intino.konos.model.graph.datetime.DateTimeData;
import io.intino.konos.model.graph.file.FileData;
import io.intino.konos.model.graph.integer.IntegerData;
import io.intino.konos.model.graph.longinteger.LongIntegerData;
import io.intino.konos.model.graph.real.RealData;
import io.intino.konos.model.graph.text.TextData;
import io.intino.konos.model.graph.type.TypeData;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class SchemaRenderer {
    private final List<Schema> schemas;
    private File destination;
    private String rootPackage;

    public SchemaRenderer(KonosGraph graph, File destination, String rootPackage) {
        this.schemas = graph.core$().find(Schema.class).stream().filter(s -> !s.core$().owner().is(Schema.class)).collect(Collectors.toList());
        this.destination = destination;
        this.rootPackage = rootPackage;
    }

    public void execute() {
        this.schemas.forEach(this::processSchema);
    }

    private void processSchema(Schema schema) {
        Service service = (Service)schema.core$().ownerAs(Service.class);
        String subPackage = "schemas" + (service != null ? File.separator + service.name$().toLowerCase() : "");
        File packageFolder = new File(this.destination, subPackage);
        String packageName = subPackage.isEmpty() ? this.rootPackage : this.rootPackage + "." + subPackage.replace(File.separator, ".");
        Frame frame = this.createSchemaFrame(schema, packageName);
        Commons.writeFrame(packageFolder, schema.name$(), this.template().format((Object)new Frame(new String[]{"root"}).addSlot("root", new String[]{this.rootPackage}).addSlot("package", new String[]{packageName}).addSlot("schema", new AbstractFrame[]{frame})));
    }

    public Frame createSchemaFrame(Schema schema, String packageName) {
        return this.createSchemaFrame(schema, packageName, new HashSet<Schema>());
    }

    private Frame createSchemaFrame(Schema schema, String packageName, Set<Schema> processed) {
        Frame frame = new Frame(new String[]{"schema"}).addSlot("name", new String[]{schema.name$()}).addSlot("package", new String[]{packageName});
        if (schema.core$().owner().is(Schema.class)) {
            frame.addSlot("inner", new String[]{"static"});
        }
        frame.addSlot("attribute", (AbstractFrame[])SchemaRenderer.processAttributes(schema.attributeList()));
        frame.addSlot("attribute", (AbstractFrame[])SchemaRenderer.processSchemasAsAttribute(schema.schemaList(), this.rootPackage));
        frame.addSlot("attribute", (AbstractFrame[])SchemaRenderer.processHasAsAttribute(schema.hasList(), this.rootPackage));
        if (schema.attributeMap() != null) {
            frame.addSlot("attribute", new AbstractFrame[]{SchemaRenderer.render(schema.attributeMap())});
        }
        SchemaRenderer.addReturningValueToAttributes(schema.name$(), frame.frames("attribute"));
        Frame[] innerSchemas = (Frame[])schema.schemaList().stream().filter(processed::add).map(s -> this.createSchemaFrame((Schema)((Object)s), packageName, processed)).toArray(Frame[]::new);
        if (innerSchemas.length > 0) {
            frame.addSlot("schema", (AbstractFrame[])innerSchemas);
        }
        return frame;
    }

    private static Frame[] processAttributes(List<Schema.Attribute> attributes) {
        return (Frame[])attributes.stream().map(SchemaRenderer::processAttribute).toArray(value -> new Frame[attributes.size()]);
    }

    private static Frame[] processSchemasAsAttribute(List<Schema> members, String rootPackage) {
        return (Frame[])members.stream().map(m -> SchemaRenderer.processSchemaAsAttribute(m, rootPackage)).toArray(value -> new Frame[members.size()]);
    }

    private static Frame[] processHasAsAttribute(List<Schema.Has> members, String rootPackage) {
        return (Frame[])members.stream().map(m -> SchemaRenderer.processHasAsAttribute(m, rootPackage)).toArray(value -> new Frame[members.size()]);
    }

    private static Frame processAttribute(Schema.Attribute attribute) {
        if (attribute.isReal()) {
            return SchemaRenderer.processAttribute(attribute.asReal());
        }
        if (attribute.isInteger()) {
            return SchemaRenderer.processAttribute(attribute.asInteger());
        }
        if (attribute.isBool()) {
            return SchemaRenderer.processAttribute(attribute.asBool());
        }
        if (attribute.isText()) {
            return SchemaRenderer.processAttribute(attribute.asText());
        }
        if (attribute.isDateTime()) {
            return SchemaRenderer.processAttribute(attribute.asDateTime());
        }
        if (attribute.isDate()) {
            return SchemaRenderer.processAttribute(attribute.asDate());
        }
        if (attribute.isFile()) {
            return SchemaRenderer.processAttribute(attribute.asFile());
        }
        if (attribute.isLongInteger()) {
            return SchemaRenderer.processAttribute(attribute.asLongInteger());
        }
        return null;
    }

    private static Frame processAttribute(RealData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{"primitive", SchemaRenderer.multiple(attribute) ? "multiple" : "single", "double"}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{"double"}).addSlot("defaultValue", new Double[]{attribute.defaultValue()});
    }

    private static Frame processAttribute(IntegerData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{"primitive", SchemaRenderer.multiple(attribute) ? "multiple" : "single", attribute.type()}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{attribute.type()}).addSlot("defaultValue", new Integer[]{attribute.defaultValue()});
    }

    private static Frame processAttribute(LongIntegerData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{"primitive", SchemaRenderer.multiple(attribute) ? "multiple" : "single", attribute.type()}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{attribute.type()}).addSlot("defaultValue", new String[]{attribute.defaultValue() + "L"});
    }

    private static Frame processAttribute(FileData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{"primitive", SchemaRenderer.multiple(attribute) ? "multiple" : "single", attribute.type()}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{attribute.type()});
    }

    private static Frame processAttribute(BoolData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{"primitive", SchemaRenderer.multiple(attribute) ? "multiple" : "single", attribute.type()}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{attribute.type()}).addSlot("defaultValue", new Boolean[]{attribute.defaultValue()});
    }

    private static Frame processAttribute(TextData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{SchemaRenderer.multiple(attribute) ? "multiple" : "single", attribute.type()}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{attribute.type()}).addSlot("defaultValue", new String[]{"\"" + attribute.defaultValue() + "\""});
    }

    private static Frame processAttribute(DateTimeData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{"primitive", SchemaRenderer.multiple(attribute) ? "multiple" : "single", attribute.type()}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{attribute.type()});
    }

    private static Frame processAttribute(DateData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{"primitive", SchemaRenderer.multiple(attribute) ? "multiple" : "single", attribute.type()}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{attribute.type()});
    }

    private static Frame processSchemaAsAttribute(Schema schema, String rootPackage) {
        return new Frame(new String[0]).addTypes(new String[]{schema.multiple() ? "multiple" : "single", "member", schema.name$()}).addSlot("name", new String[]{schema.name$()}).addSlot("type", new String[]{schema.name$()}).addSlot("list", new String[]{"List"}).addSlot("package", new String[]{SchemaRenderer.packageOf(schema, rootPackage)});
    }

    private static Frame processHasAsAttribute(Schema.Has has, String rootPackage) {
        boolean anonymous = has.name$().contains("-");
        return new Frame(new String[0]).addTypes(new String[]{has.multiple() ? "multiple" : "single", "member", has.reference().name$()}).addSlot("name", new String[]{anonymous ? has.reference().name$() : has.name$()}).addSlot("type", new String[]{has.reference().name$()}).addSlot("list", new String[]{anonymous ? "List" : ""}).addSlot("package", new String[]{SchemaRenderer.packageOf(has.reference(), rootPackage)});
    }

    private static String packageOf(Schema schema, String rootPackage) {
        Service service = (Service)schema.core$().ownerAs(Service.class);
        String subPackage = "schemas" + (service != null ? File.separator + service.name$().toLowerCase() : "");
        return subPackage.isEmpty() ? rootPackage : rootPackage + "." + subPackage.replace(File.separator, ".");
    }

    private static Frame render(Schema.AttributeMap map) {
        return new Frame(new String[0]).addTypes(new String[]{"attributeMap"}).addSlot("name", new String[]{map.name$()});
    }

    private static void addReturningValueToAttributes(String elementName, Iterator<AbstractFrame> attributes) {
        while (attributes.hasNext()) {
            ((Frame)attributes.next()).addSlot("element", new String[]{elementName});
        }
    }

    private static boolean multiple(TypeData attribute) {
        return ((Schema.Attribute)attribute.a$(Schema.Attribute.class)).multiple();
    }

    private Template template() {
        Template template = Formatters.customize(SchemaTemplate.create());
        template.add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
        return template;
    }
}

