/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake;

import java.util.Locale;
import org.siani.itrules.LineSeparator;
import org.siani.itrules.Template;
import org.siani.itrules.model.Condition;
import org.siani.itrules.model.Rule;
import org.siani.itrules.model.Token;

public class NessJMXOperationsTemplate
extends Template {
    protected NessJMXOperationsTemplate(Locale locale, LineSeparator separator) {
        super(locale, separator);
    }

    public static Template create() {
        return new NessJMXOperationsTemplate(Locale.ENGLISH, LineSeparator.LF).define();
    }

    public Template define() {
        this.add(new Rule[]{this.rule().add(new Condition[]{this.condition("type", "interface")}).add((Token.Body)this.literal("package ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".ness;\n\nimport io.intino.konos.jmx.Description;\nimport io.intino.konos.jmx.Parameters;\n\npublic interface NessOperationsMBean {\n\t@Description(\"Shows information about the available operations\")\n\t@Parameters({})\n\tjava.util.List<String> help();\n\n\t@Description(\"Starts remount mode to reproduce events coming from datalake\")\n\t@Parameters({})\n\tboolean reflow();\n\n\t@Description(\"Starts remount mode to reproduce events coming from datalake since instant parameter\")\n\t@Parameters({})\n\tboolean reflow(String fromInstant);\n}")), this.rule().add(new Condition[]{this.condition("type", "operations"), this.not(this.condition("type", "interface"))}).add((Token.Body)this.literal("package ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".ness;\n\nimport io.intino.konos.datalake.MessageHandler;\nimport io.intino.konos.datalake.ReflowDispatcher;\nimport io.intino.konos.jmx.JMXServer;\nimport io.intino.tara.magritte.Graph;\nimport io.intino.tara.magritte.RemounterGraph;\nimport io.intino.tara.magritte.stores.FileSystemStore;\nimport org.apache.commons.io.FileUtils;\nimport ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".")).add((Token.Body)this.mark("box", new String[]{"FirstUpperCase"})).add((Token.Body)this.literal("Box;\nimport org.slf4j.Logger;\nimport org.slf4j.LoggerFactory;\n\nimport java.io.IOException;\nimport java.time.Instant;\nimport java.util.Collections;\n\nimport static org.slf4j.Logger.ROOT_LOGGER_NAME;\n\npublic class NessOperations implements NessOperationsMBean {\n\tprivate static Logger logger = LoggerFactory.getLogger(ROOT_LOGGER_NAME);\n\tprivate final ")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box;\n\tprivate final ReflowAssistant assistant;\n\tprivate int processed = 0;\n\tprivate io.intino.konos.datalake.Datalake.ReflowSession session;\n\tprivate Graph graph;\n\n\tpublic NessOperations(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box) {\n\t\tthis.box = box;\n\t\tthis.assistant = new ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".ness.ReflowAssistant(box);\n\t}\n\n\tpublic java.util.List<String> help() {\n\t\tjava.util.List<String> operations = new java.util.ArrayList<>();\n\t\toperations.add(\"boolean reflow():Starts remount mode to reproduce events coming from datalake\");\n\t\treturn operations;\n\t}\n\n\tpublic boolean reflow(String from) {\n\t\treturn reflow(Instant.parse(from));\n\t}\n\n\tpublic boolean reflow() {\n\t\treturn reflow(Instant.MIN);\n\t}\n\n\tpublic boolean reflow(Instant from) {\n\t\tlogger.info(\"Starting Reflow...\");\n\t\tassistant.before();\n\t\tTanksConnectors.unregister();\n\t\tthis.session = box.datalake().reflow(assistant.blockSize(), new ReflowDispatcher(assistant.tanks(), onBlock(), onFinish()), from);\n\t\tfinal Graph graph = assistant.graph();\n\t\ttry {\n\t\t\tif (graph.store() instanceof FileSystemStore && from.equals(Instant.MIN))\n\t\t\t\tFileUtils.deleteDirectory(((FileSystemStore) graph.store()).directory());\n\t\t\tfinal RemounterGraph original = (RemounterGraph) new RemounterGraph(graph.store()).loadStashes(assistant.coreStashes());\n\t\t\tallowWriting(original, false);\n\t\t\tthis.graph = original.realClone();\n\t\t\tbox.put(this.graph);\n\t\t\tthis.session.next();\n\t\t} catch (IOException e) {\n\t\t\tlogger.error(e.getMessage(), e);\n\t\t\treturn false;\n\t\t}\n\t\treturn true;\n\t}\n\n\tprivate MessageHandler onFinish() {\n\t\treturn m -> {\n\t\t\tdoWrite();\n\t\t\tsession.finish();\n\t\t\tfinal Graph graph = new Graph(NessOperations.this.graph.store());\n\t\t\tallowWriting(graph, true);\n\t\t\tbox.put(graph.loadStashes(assistant.coreStashes()));\n\t\t\tTanksConnectors.registerTanks(box);\n\t\t\tassistant.after();\n\t\t\tlogger.info(\"Reflow finished - \" + m.get(\"count\") + \" messages processed\");\n\t\t};\n\t}\n\n\tprivate MessageHandler onBlock() {\n\t\treturn m -> {\n\t\t\tdoWrite();\n\t\t\tlogger.info(\"Block processed - \" + m.get(\"count\") + \" messages processed\");\n\t\t\tsession.next();\n\t\t};\n\t}\n\n\tprivate void doWrite() {\n\t\tsession.pause();\n\t\tallowWriting(graph, true);\n\t\tassistant.saveGraph(graph);\n\t\tthis.graph = new RemounterGraph(graph.store()).loadStashes(assistant.coreStashes());\n\t\tallowWriting(graph, false);\n\t\tbox.put(graph);\n\t\tsession.play();\n\t}\n\n\tprivate void allowWriting(Graph original, boolean flag) {\n\t\tif (original.store() instanceof FileSystemStore) ((FileSystemStore) original.store()).allowWriting(flag);\n\t}\n\n\n\tpublic static JMXServer init(")).add((Token.Body)this.mark("box", new String[]{"FirstUpperCase"})).add((Token.Body)this.literal("Box box) {\n\t\tJMXServer server = new JMXServer(Collections.singletonMap(\"")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".ness.NessOperations\", new Object[]{box}));\n\t\tserver.init();\n\t\treturn server;\n\t}\n}"))});
        return this;
    }
}

