/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.BoxConfigurationTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.MessageHandler;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.jms.JMSService;
import io.intino.konos.model.graph.ness.NessClient;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.slackbot.SlackBotService;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.magritte.Layer;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class BoxConfigurationRenderer {
    private final KonosGraph graph;
    private final File gen;
    private final String packageName;
    private final Module module;
    private final Configuration configuration;
    private String parent;
    private boolean isTara;

    public BoxConfigurationRenderer(KonosGraph graph, File gen, String packageName, Module module, String parent, boolean isTara) {
        this.graph = graph;
        this.gen = gen;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
        this.parent = parent;
        this.isTara = isTara;
    }

    public Frame execute() {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"boxconfiguration"});
        String boxName = this.fillFrame(frame);
        Commons.writeFrame(this.gen, StringHelper.snakeCaseToCamelCase((String)boxName) + "Configuration", this.template().format((Object)frame));
        return frame;
    }

    private String fillFrame(Frame frame) {
        String boxName = this.name();
        frame.addSlot("name", new String[]{boxName});
        frame.addSlot("package", new String[]{this.packageName});
        if (this.parent != null && this.configuration != null && !Configuration.Level.Platform.equals((Object)this.configuration.level())) {
            frame.addSlot("parent", new String[]{this.parent});
        }
        frame.addSlot("parameter", (AbstractFrame[])this.graph.box().parameterList().stream().filter(p -> p.name() != null && p.value() != null).map(p -> new Frame(new String[0]).addSlot("name", new String[]{p.name()}).addSlot("value", new String[]{p.value()})).toArray(Frame[]::new));
        this.addRESTServices(frame, boxName);
        this.addJMSServices(frame, boxName);
        this.addSlackServices(frame, boxName);
        this.addDataLake(frame, boxName);
        this.addMessageHandlers(frame, boxName);
        this.addActivities(frame, boxName);
        if (this.isTara) {
            frame.addSlot("tara", new String[]{""});
        }
        return boxName;
    }

    private void addRESTServices(Frame frame, String boxName) {
        for (RESTService service : this.graph.rESTServiceList()) {
            Frame restFrame = new Frame(new String[0]).addTypes(new String[]{"service", "rest"}).addSlot("name", new String[]{service.name$()}).addSlot("configuration", new String[]{boxName});
            if (service.authenticated() != null) {
                restFrame.addTypes(new String[]{"auth"});
            }
            this.addUserVariables(service.a$(Service.class), restFrame, this.findCustomParameters(service));
            frame.addSlot("service", new AbstractFrame[]{restFrame});
        }
    }

    private void addJMSServices(Frame frame, String boxName) {
        for (JMSService service : this.graph.jMSServiceList()) {
            Frame jmsFrame = new Frame(new String[0]).addTypes(new String[]{"service", "jms"}).addSlot("name", new String[]{service.name$()}).addSlot("configuration", new String[]{boxName});
            this.addUserVariables(service.a$(Service.class), jmsFrame, this.findCustomParameters(service));
            frame.addSlot("service", new AbstractFrame[]{jmsFrame});
        }
    }

    private void addDataLake(Frame frame, String boxName) {
        if (this.graph.nessClientList().isEmpty()) {
            return;
        }
        NessClient datalake = this.graph.nessClient(0);
        if (datalake == null) {
            return;
        }
        Frame datalakeFrame = new Frame(new String[0]).addTypes(new String[]{"service", "datalake"}).addSlot("name", new String[]{datalake.name$()}).addSlot("configuration", new String[]{boxName});
        frame.addSlot("service", new AbstractFrame[]{datalakeFrame});
    }

    private void addMessageHandlers(Frame frame, String boxName) {
        if (this.graph.nessClientList().isEmpty()) {
            return;
        }
        NessClient datalake = this.graph.nessClient(0);
        if (datalake == null) {
            return;
        }
        for (MessageHandler handler : datalake.messageHandlerList()) {
            Frame channelFrame = new Frame(new String[0]).addTypes(new String[]{"service", "eventHandler"}).addSlot("name", new String[]{handler.schema() != null ? handler.schema().name$() : handler.name$()}).addSlot("configuration", new String[]{boxName});
            frame.addSlot("service", new AbstractFrame[]{channelFrame});
        }
    }

    private void addActivities(Frame frame, String boxName) {
        for (UIService service : this.graph.uIServiceList()) {
            Frame activityFrame = new Frame(new String[0]).addTypes(new String[]{"service", "ui"}).addSlot("name", new String[]{service.name$()}).addSlot("configuration", new String[]{boxName});
            frame.addSlot("service", new AbstractFrame[]{activityFrame});
            if (service.authentication() != null) {
                activityFrame.addTypes(new String[]{"auth"});
                activityFrame.addSlot("authURL", new AbstractFrame[]{new Frame(new String[0]).addSlot("name", new String[]{service.name$()}).addSlot("configuration", new String[]{boxName})});
                activityFrame.addSlot("auth", new String[]{service.authentication().by()});
            }
            this.addUserVariables(service, activityFrame, this.findCustomParameters(service));
        }
    }

    private void addSlackServices(Frame frame, String boxName) {
        for (SlackBotService service : this.graph.slackBotServiceList()) {
            frame.addSlot("service", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"service", "slack"}).addSlot("name", new String[]{service.name$()}).addSlot("configuration", new String[]{boxName})});
        }
    }

    private void addUserVariables(Layer layer, Frame frame, Collection<String> userVariables) {
        for (String custom : userVariables) {
            frame.addSlot("custom", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"custom"}).addSlot("conf", new String[]{layer.name$()}).addSlot("name", new String[]{custom}).addSlot("type", new String[]{"String"})});
        }
    }

    private Set<String> findCustomParameters(JMSService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (JMSService.Request request : service.requestList()) {
            set.addAll(Commons.extractParameters(request.path()));
        }
        return set;
    }

    private Set<String> findCustomParameters(RESTService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (RESTService.Resource resource : service.resourceList()) {
            set.addAll(Commons.extractParameters(resource.path()));
        }
        return set;
    }

    private Set<String> findCustomParameters(UIService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (service.authentication() != null) {
            set.addAll(Commons.extractParameters(service.authentication().by()));
        }
        for (AbstractUIService.Resource resource : service.resourceList()) {
            set.addAll(Commons.extractParameters(resource.path()));
        }
        return set;
    }

    private String name() {
        if (this.module != null) {
            Configuration configuration = TaraUtil.configurationOf((Module)this.module);
            String dsl = configuration.outDSL();
            if (dsl == null || dsl.isEmpty()) {
                return this.module.getName();
            }
            return dsl;
        }
        return "System";
    }

    private Template template() {
        return Formatters.customize(BoxConfigurationTemplate.create());
    }
}

