/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import io.intino.konos.builder.codegeneration.AbstractBoxTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.jms.JMSService;
import io.intino.konos.model.graph.jmx.JMXService;
import io.intino.konos.model.graph.ness.NessClient;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.slackbot.SlackBotService;
import io.intino.konos.model.graph.ui.UIService;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class AbstractBoxRenderer {
    private final File gen;
    private final String packageName;
    private final Module module;
    private final KonosGraph konos;
    private final Configuration configuration;
    private String parent;
    private final boolean hasModel;

    AbstractBoxRenderer(KonosGraph graph, File gen, String packageName, Module module, String parent, boolean hasModel) {
        this.konos = graph;
        this.gen = gen;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
        this.parent = parent;
        this.hasModel = hasModel;
    }

    public void execute() {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"box"});
        String name = this.name();
        frame.addSlot("name", new String[]{name});
        frame.addSlot("package", new String[]{this.packageName});
        if (this.hasModel) {
            frame.addSlot("tara", new String[]{name});
        }
        this.parent(frame);
        this.services(frame, name);
        this.tasks(frame, name);
        this.dataLake(frame, name);
        Commons.writeFrame(this.gen, "AbstractBox", this.template().format((Object)frame));
    }

    private void tasks(Frame frame, String name) {
        if (!this.konos.taskList().isEmpty()) {
            frame.addSlot("task", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"task"}).addSlot("configuration", new String[]{name})});
        }
    }

    private void dataLake(Frame root, String name) {
        if (!this.konos.nessClientList().isEmpty()) {
            NessClient client = this.konos.nessClientList().get(0);
            Frame datalake = new Frame(new String[0]).addTypes(new String[]{"dataLake"}).addSlot("mode", new String[]{this.konos.nessClient(0).mode().name()}).addSlot("name", new String[]{this.konos.nessClient(0).name$()}).addSlot("package", new String[]{this.packageName}).addSlot("configuration", new String[]{name});
            datalake.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(client.url()) ? "custom" : "standard"}).addSlot("value", new String[]{client.url()})});
            datalake.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(client.user()) ? "custom" : "standard"}).addSlot("value", new String[]{client.user()})});
            datalake.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(client.password()) ? "custom" : "standard"}).addSlot("value", new String[]{client.password()})});
            datalake.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(client.clientID()) ? "custom" : "standard"}).addSlot("value", new String[]{client.clientID()})});
            root.addSlot("dataLake", new AbstractFrame[]{datalake});
        }
    }

    private void services(Frame frame, String name) {
        Frame serviceFrame;
        if (!this.konos.jMSServiceList().isEmpty()) {
            frame.addSlot("jms", new String[]{""});
        }
        for (RESTService rESTService : this.konos.rESTServiceList()) {
            serviceFrame = new Frame(new String[0]).addTypes(new String[]{"service", "rest"}).addSlot("name", new String[]{rESTService.name$()}).addSlot("configuration", new String[]{name});
            serviceFrame.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(rESTService.port()) ? "custom" : "standard"}).addSlot("value", new String[]{rESTService.port()})});
            frame.addSlot("service", new AbstractFrame[]{serviceFrame});
        }
        for (JMSService jMSService : this.konos.jMSServiceList()) {
            serviceFrame = new Frame(new String[0]).addTypes(new String[]{"service", "jms"}).addSlot("name", new String[]{jMSService.name$()}).addSlot("configuration", new String[]{name});
            serviceFrame.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(jMSService.user()) ? "custom" : "standard"}).addSlot("value", new String[]{jMSService.user()})});
            serviceFrame.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(jMSService.password()) ? "custom" : "standard"}).addSlot("value", new String[]{jMSService.password()})});
            serviceFrame.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(jMSService.url()) ? "custom" : "standard"}).addSlot("value", new String[]{jMSService.url()})});
            frame.addSlot("service", new AbstractFrame[]{serviceFrame});
        }
        for (JMXService jMXService : this.konos.jMXServiceList()) {
            frame.addSlot("service", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"service", "jmx"}).addSlot("name", new String[]{jMXService.name$()}).addSlot("configuration", new String[]{name})});
        }
        for (SlackBotService slackBotService : this.konos.slackBotServiceList()) {
            Frame slackFrame = new Frame(new String[0]).addTypes(new String[]{"service", "slack"}).addSlot("name", new String[]{slackBotService.name$()}).addSlot("configuration", new String[]{name});
            slackFrame.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(slackBotService.token()) ? "custom" : "standard"}).addSlot("value", new String[]{slackBotService.token()})});
            frame.addSlot("service", new AbstractFrame[]{slackFrame});
        }
        if (!this.konos.rESTServiceList().isEmpty() || !this.konos.uIServiceList().isEmpty()) {
            frame.addSlot("spark", new String[]{"stop"});
        }
        if (!this.konos.uIServiceList().isEmpty()) {
            Frame uiFrame = new Frame(new String[0]);
            if (this.parent != null) {
                uiFrame.addSlot("parent", new String[]{this.parent});
            }
            frame.addSlot("hasUi", new AbstractFrame[]{uiFrame});
            frame.addSlot("service", (AbstractFrame[])this.konos.uIServiceList().stream().map(s -> this.uiServiceFrame((UIService)((Object)((Object)s)), name)).toArray(Frame[]::new));
        }
    }

    private Frame uiServiceFrame(UIService service, String name) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"service", "ui"}).addSlot("name", new String[]{service.name$()}).addSlot("configuration", new String[]{name}).addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(service.port()) ? "custom" : "standard"}).addSlot("value", new String[]{service.port()})});
        if (service.authentication() != null) {
            frame.addSlot("authentication", new AbstractFrame[]{new Frame(new String[]{this.isCustom(service.port()) ? "custom" : "standard"}).addSlot("value", new String[]{service.authentication().by()})});
        }
        return frame;
    }

    private boolean isCustom(String value) {
        return value != null && value.startsWith("{");
    }

    private void parent(Frame frame) {
        if (this.parent != null && this.configuration != null && !Configuration.Level.Platform.equals((Object)this.configuration.level())) {
            frame.addSlot("parent", new String[]{this.parent}).addSlot("hasParent", new String[]{""});
        } else {
            frame.addSlot("hasntParent", new String[]{""});
        }
    }

    private String name() {
        if (this.module != null) {
            String dsl = this.configuration.outDSL();
            if (dsl == null || dsl.isEmpty()) {
                return this.module.getName();
            }
            return dsl;
        }
        return "System";
    }

    private Template template() {
        return Formatters.customize(AbstractBoxTemplate.create());
    }
}

