/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display.toolbar;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.Renderer;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.codegeneration.services.ui.display.toolbar.OperationGenTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.toolbar.OperationSrcTemplate;
import io.intino.konos.model.graph.AbstractToolbar;
import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.Component;
import io.intino.tara.magritte.Layer;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class OperationRenderer
extends Renderer {
    private final AbstractToolbar.Operation operation;
    private final Component owner;

    public OperationRenderer(AbstractToolbar.Operation operation, Component owner, String box, String packageName) {
        super(operation.name$(), box, packageName);
        this.operation = operation;
        this.owner = owner;
    }

    public String buildSrc() {
        return Formatters.customize(OperationSrcTemplate.create()).format((Object)this.createFrame());
    }

    public String buildGen() {
        return Formatters.customize(OperationGenTemplate.create()).format((Object)this.createFrame());
    }

    @Override
    protected Template srcTemplate() {
        return null;
    }

    @Override
    protected Template genTemplate() {
        return null;
    }

    @Override
    protected Updater updater(String displayName, File sourceFile) {
        return null;
    }

    @Override
    protected Frame createFrame() {
        Frame frame = super.createFrame();
        frame.addTypes(new String[]{"operation", ((Object)((Object)this.operation)).getClass().getSimpleName()}).addSlot("title", new String[]{this.operation.title()}).addSlot("owner", new String[]{this.owner.name$()}).addSlot("ownerClass", new String[]{((Object)((Object)this.owner)).getClass().getSimpleName()}).addSlot("mode", new String[]{this.operation.mode().toString()});
        if (this.owner.i$(Catalog.class)) {
            frame.addSlot("itemClass", new String[]{((Catalog)this.owner.a$(Catalog.class)).itemClass()});
        }
        if (this.operation.polymerIcon() != null) {
            frame.addSlot("icon", new String[]{this.operation.polymerIcon()});
        }
        this.addTaskProperties(frame);
        this.addTaskSelectionProperties(frame);
        this.addOpenDialogProperties(frame);
        this.addOpenCatalogProperties(frame);
        this.addOpenCatalogSelectionProperties(frame);
        return frame;
    }

    private void addTaskProperties(Frame frame) {
        if (!this.operation.i$(AbstractToolbar.Task.class)) {
            return;
        }
        AbstractToolbar.Task task = (AbstractToolbar.Task)this.operation.a$(AbstractToolbar.Task.class);
        if (task.confirmText() == null) {
            return;
        }
        frame.addSlot("confirmText", new String[]{task.confirmText()});
    }

    private void addTaskSelectionProperties(Frame frame) {
        if (!this.operation.i$(AbstractToolbar.TaskSelection.class)) {
            return;
        }
        AbstractToolbar.TaskSelection taskSelection = (AbstractToolbar.TaskSelection)this.operation.a$(AbstractToolbar.TaskSelection.class);
        if (taskSelection.confirmText() == null) {
            return;
        }
        frame.addSlot("confirmText", new String[]{taskSelection.confirmText()});
    }

    private void addOpenDialogProperties(Frame frame) {
        if (!this.operation.i$(AbstractToolbar.OpenDialog.class)) {
            return;
        }
        frame.addSlot("dialog", new String[]{((AbstractToolbar.OpenDialog)this.operation.a$(AbstractToolbar.OpenDialog.class)).dialog().name$()});
    }

    private void addOpenCatalogProperties(Frame frame) {
        if (!this.operation.i$(AbstractToolbar.OpenCatalog.class)) {
            return;
        }
        AbstractToolbar.OpenCatalog openCatalog = (AbstractToolbar.OpenCatalog)this.operation.a$(AbstractToolbar.OpenCatalog.class);
        frame.addSlot("width", new Integer[]{openCatalog.width()});
        frame.addSlot("height", new Integer[]{openCatalog.height()});
        frame.addSlot("position", new String[]{openCatalog.position().toString()});
        frame.addSlot("openCatalog", new String[]{openCatalog.catalog().name$()});
        frame.addSlot("view", (String[])openCatalog.views().stream().map(Layer::name$).toArray(String[]::new));
        if (openCatalog.filtered()) {
            frame.addSlot("openCatalogOperationFilter", new AbstractFrame[]{new Frame(new String[0]).addSlot("owner", new String[]{this.owner.name$()}).addSlot("ownerClass", new String[]{((Object)((Object)this.owner)).getClass().getSimpleName()}).addSlot("box", new String[]{this.box})});
        }
    }

    private void addOpenCatalogSelectionProperties(Frame frame) {
        if (!this.operation.i$(AbstractToolbar.OpenCatalogSelection.class)) {
            return;
        }
        String itemClass = ((Catalog)this.owner.a$(Catalog.class)).itemClass();
        AbstractToolbar.OpenCatalogSelection openCatalogSelection = (AbstractToolbar.OpenCatalogSelection)this.operation.a$(AbstractToolbar.OpenCatalogSelection.class);
        frame.addSlot("width", new Integer[]{openCatalogSelection.width()});
        frame.addSlot("height", new Integer[]{openCatalogSelection.height()});
        frame.addSlot("position", new String[]{openCatalogSelection.position().toString()});
        frame.addSlot("openCatalog", new String[]{openCatalogSelection.catalog().name$()});
        frame.addSlot("view", (String[])openCatalogSelection.views().stream().map(Layer::name$).toArray(String[]::new));
        frame.addSlot("selection", new String[]{openCatalogSelection.selection().toString()});
        if (openCatalogSelection.filtered()) {
            frame.addSlot("openCatalogSelectionOperationFilter", new AbstractFrame[]{new Frame(new String[0]).addSlot("owner", new String[]{this.owner.name$()}).addSlot("ownerClass", new String[]{((Object)((Object)this.owner)).getClass().getSimpleName()}).addSlot("box", new String[]{this.box}).addSlot("itemClass", new String[]{itemClass})});
        }
        frame.addSlot("openCatalogSelectionOperation", new AbstractFrame[]{new Frame(new String[0]).addSlot("owner", new String[]{this.owner.name$()}).addSlot("ownerClass", new String[]{((Object)((Object)this.owner)).getClass().getSimpleName()}).addSlot("box", new String[]{this.box}).addSlot("itemClass", new String[]{itemClass})});
    }
}

