/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display.panel;

import com.intellij.openapi.project.Project;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.DisplayRenderer;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.codegeneration.services.ui.display.panel.PanelGenTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.panel.PanelSrcTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.panel.PanelUpdater;
import io.intino.konos.builder.codegeneration.services.ui.display.toolbar.OperationRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.view.ViewRenderer;
import io.intino.konos.model.graph.AbstractToolbar;
import io.intino.konos.model.graph.Panel;
import io.intino.konos.model.graph.Toolbar;
import io.intino.konos.model.graph.View;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class PanelRenderer
extends DisplayRenderer {
    private final Project project;

    public PanelRenderer(Project project, Panel panel, String packageName, String boxName) {
        super(panel, boxName, packageName);
        this.project = project;
    }

    @Override
    protected Frame createFrame() {
        Panel panel = (Panel)this.display().a$(Panel.class);
        Frame frame = super.createFrame();
        frame.addTypes(new String[]{panel.isDesktop() ? "desktop" : "panel"});
        if (panel.label() != null) {
            frame.addSlot("label", new String[]{panel.label()});
        }
        if (panel.toolbar() != null) {
            frame.addSlot("toolbar", new AbstractFrame[]{this.frameOf(panel.toolbar())});
        }
        this.views(panel.views(), frame);
        return frame;
    }

    private Frame frameOf(Toolbar toolbar) {
        Frame frame = new Frame(new String[]{"toolbar"});
        frame.addSlot("box", new String[]{this.box}).addSlot("canSearch", new Boolean[]{toolbar.canSearch()});
        boolean buildingSrc = this.buildingSrc();
        toolbar.operations().forEach(operation -> {
            OperationRenderer builder = new OperationRenderer((AbstractToolbar.Operation)((Object)operation), this.display(), this.box, this.packageName);
            frame.addSlot("operation", new String[]{buildingSrc ? builder.buildSrc() : builder.buildGen()});
        });
        return frame;
    }

    private void views(Panel.Views views, Frame frame) {
        views.viewList().forEach(view -> {
            ViewRenderer builder = new ViewRenderer((View)((Object)view), this.display(), this.box, this.packageName);
            frame.addSlot("view", new String[]{this.buildingSrc() ? builder.buildSrc() : builder.buildGen()});
        });
    }

    @Override
    protected Template srcTemplate() {
        return Formatters.customize(PanelSrcTemplate.create());
    }

    @Override
    protected Template genTemplate() {
        return Formatters.customize(PanelGenTemplate.create());
    }

    @Override
    protected Updater updater(String displayName, File sourceFile) {
        return new PanelUpdater(sourceFile, (Panel)this.display().a$(Panel.class), this.project, this.packageName, this.box);
    }
}

