/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display.desktop;

import com.intellij.openapi.project.Project;
import io.intino.konos.builder.codegeneration.services.ui.display.panel.PanelRenderer;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.Panel;
import io.intino.konos.model.graph.desktop.DesktopPanel;
import io.intino.konos.model.graph.ui.UIService;
import org.siani.itrules.model.Frame;

public class DesktopRenderer
extends PanelRenderer {
    public DesktopRenderer(Project project, DesktopPanel desktop, String packageName, String boxName) {
        super(project, (Panel)desktop.a$(Panel.class), packageName, boxName);
    }

    @Override
    protected Frame createFrame() {
        UIService service;
        DesktopPanel desktop = ((Panel)this.display().a$(Panel.class)).asDesktop();
        Frame frame = super.createFrame();
        frame.addTypes(new String[]{"desktop"});
        frame.addSlot("title", new String[]{desktop.title()});
        frame.addSlot("subtitle", new String[]{desktop.subTitle()});
        frame.addSlot("layout", new String[]{desktop.layout().name()});
        if (desktop.logoPath() != null && !desktop.logoPath().isEmpty()) {
            frame.addSlot("logo", new String[]{desktop.logoPath()});
        }
        if (desktop.faviconPath() != null && !desktop.faviconPath().isEmpty()) {
            frame.addSlot("favicon", new String[]{desktop.faviconPath()});
        }
        if ((service = this.findOwnerUIService()) != null && service.authentication() != null) {
            frame.addSlot("uiService", new String[]{service.name$()});
        }
        return frame;
    }

    private UIService findOwnerUIService() {
        Display display = this.display();
        return display.graph().uIServiceList().stream().filter(s -> s.userHome() != null && ((Object)((Object)display)).equals((Object)s.userHome().uses())).findFirst().orElse(null);
    }
}

