/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.helpers.Commons;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.Frame;

public abstract class Renderer {
    protected static final String DISPLAYS = "displays";
    protected final String box;
    protected final String packageName;
    protected final String name;
    private boolean buildingGen = false;

    protected Renderer(String name, String box, String packageName) {
        this.name = name;
        this.box = box;
        this.packageName = packageName;
    }

    public final void write(File src, File gen) {
        this.writeSrc(src);
        this.writeGen(gen);
    }

    private void writeSrc(File file) {
        this.buildingGen = false;
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)this.name);
        File sourceFile = Commons.javaFile(new File(file, DISPLAYS), newDisplay);
        if (!sourceFile.exists()) {
            Commons.writeFrame(new File(file, DISPLAYS), newDisplay, this.srcTemplate().format((Object)this.createFrame()));
        } else {
            Updater updater = this.updater(newDisplay, sourceFile);
            if (updater != null) {
                updater.update();
            }
        }
    }

    private void writeGen(File file) {
        this.buildingGen = true;
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)("Abstract" + Commons.firstUpperCase(this.name)));
        Commons.writeFrame(new File(file, DISPLAYS), newDisplay, this.genTemplate().format((Object)this.createFrame().addTypes(new String[]{"gen"})));
    }

    protected boolean buildingSrc() {
        return !this.buildingGen;
    }

    protected abstract Template srcTemplate();

    protected abstract Template genTemplate();

    protected abstract Updater updater(String var1, File var2);

    protected Frame createFrame() {
        return new Frame(new String[0]).addSlot("box", new String[]{this.box}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{this.name});
    }
}

