/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.NessTanksTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.DataLake;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class NessTanksRenderer {
    private final DataLake dataLake;
    private final File gen;
    private final String packageName;
    private final String boxName;

    public NessTanksRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        this.dataLake = graph.dataLake();
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"tanks"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{this.dataLake.name$()}).addSlot("box", new String[]{this.boxName}).addSlot("tank", (AbstractFrame[])this.dataLake.tankList().stream().map(this::frameOf).toArray(Frame[]::new));
        if (!this.dataLake.tankList().isEmpty()) {
            frame.addSlot("tankImport", new String[]{this.packageName});
        }
        if (!this.dataLake.graph().schemaList().isEmpty()) {
            frame.addSlot("schemaImport", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
        }
        Commons.writeFrame(new File(this.gen, "ness"), "NessTanks", this.template().format((Object)frame));
    }

    private Frame frameOf(DataLake.Tank tank) {
        String type = this.type(tank);
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"tank"}).addSlot("name", new String[]{type}).addSlot("box", new String[]{this.boxName}).addSlot("messageType", new String[]{(this.dataLake.domain().isEmpty() ? "" : this.dataLake.domain() + ".") + this.subdomain(tank) + type}).addSlot("simpleMessageType", new String[]{type});
        if (tank.schema() != null) {
            frame.addSlot("type", new AbstractFrame[]{new Frame(new String[]{"schema"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{tank.schema().name$()})});
        } else {
            frame.addSlot("type", new String[]{"message"});
        }
        return frame;
    }

    @NotNull
    private String subdomain(DataLake.Tank tank) {
        String string = tank.subdomain().isEmpty() ? "" : tank.subdomain() + ".";
        if (string == null) {
            NessTanksRenderer.$$$reportNull$$$0(0);
        }
        return string;
    }

    private String type(DataLake.Tank tank) {
        return tank.schema() == null ? tank.name$() : tank.schema().name$();
    }

    private Frame customize(String name, String topic) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"messageType"});
        frame.addSlot("name", new String[]{topic});
        for (String parameter : Commons.extractParameters(topic)) {
            frame.addSlot("custom", new AbstractFrame[]{this.custom(name, parameter)});
        }
        return frame;
    }

    private Frame custom(String name, String parameter) {
        return new Frame(new String[0]).addSlot("value", new String[]{parameter}).addSlot("conf", new String[]{name});
    }

    private Template template() {
        return Formatters.customize(NessTanksTemplate.create()).add("shortPath", value -> {
            String[] names = value.toString().split("\\.");
            return names[names.length - 1];
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/datalake/NessTanksRenderer", "subdomain"));
    }
}

