/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.MessageHandlerTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.DataLake;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class MessageHandlerRenderer {
    private final List<DataLake.Tank> tanks;
    private final File src;
    private final String packageName;
    private final String boxName;

    public MessageHandlerRenderer(KonosGraph graph, File src, String packageName, String boxName) {
        this.tanks = graph.dataLake() != null ? graph.dataLake().tankList() : Collections.emptyList();
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        for (DataLake.Tank tank : this.tanks) {
            String handlerName;
            File destination;
            String name = tank.schema() != null ? tank.schema().name$() : tank.name$();
            Frame frame = new Frame(new String[0]).addTypes(new String[]{"messageHandler"}).addSlot("box", new String[]{this.boxName}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{name});
            if (tank.schema() != null) {
                frame.addSlot("schemaImport", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
                frame.addSlot("type", new AbstractFrame[]{new Frame(new String[]{"schema"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{tank.schema().name$()})});
            } else {
                frame.addSlot("type", new String[]{"message"});
            }
            if (this.alreadyRendered(destination = new File(this.src, "ness/messagehandlers"), handlerName = Formatters.firstUpperCase(name) + "MessageHandler")) continue;
            Commons.writeFrame(destination, handlerName, Formatters.customize(MessageHandlerTemplate.create()).format((Object)frame));
        }
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

