/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.action;

import com.intellij.openapi.project.Project;
import io.intino.konos.builder.codegeneration.action.ActionRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import java.io.File;
import java.util.List;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class UIActionRenderer
extends ActionRenderer {
    private final AbstractUIService.Resource resource;
    private final File gen;
    private final UIService service;

    public UIActionRenderer(Project project, AbstractUIService.Resource resource, File src, File gen, String packageName, String boxName) {
        super(project, src, packageName, boxName);
        this.gen = gen;
        this.resource = resource;
        this.service = (UIService)resource.core$().ownerAs(UIService.class);
    }

    public void execute() {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"action", "ui"});
        frame.addSlot("name", new String[]{this.resource.name$()});
        frame.addSlot("uiService", new String[]{((UIService)this.resource.core$().ownerAs(UIService.class)).name$()});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("box", new String[]{this.boxName});
        if (this.resource.uses().i$(Dialog.class)) {
            frame.addSlot("importDialogs", new String[]{this.packageName});
        } else {
            frame.addSlot("importDisplays", new String[]{this.packageName});
        }
        frame.addSlot("component", new String[]{this.resource.uses().name$()});
        frame.addSlot("parameter", (AbstractFrame[])this.parameters());
        if (this.service.favicon() != null) {
            frame.addSlot("favicon", new String[]{this.service.favicon()});
        } else if (this.service.title() != null) {
            frame.addSlot("title", new String[]{this.service.title()});
        }
        if (!this.alreadyRendered(this.destiny, this.resource.name$())) {
            Commons.writeFrame(this.destinyPackage(this.destiny), this.resource.name$() + "Action", this.template().format((Object)frame));
        }
        Commons.writeFrame(this.destinyPackage(this.gen), "Abstract" + this.firstUpperCase(this.resource.name$()) + "Action", this.template().format((Object)frame.addTypes(new String[]{"gen"})));
    }

    private Frame[] parameters() {
        List<String> parameters = Commons.extractUrlPathParameters(this.resource.path());
        return (Frame[])parameters.stream().map(parameter -> new Frame(new String[0]).addTypes(new String[]{"parameter"}).addSlot("type", new String[]{"String"}).addSlot("name", new String[]{parameter})).toArray(Frame[]::new);
    }
}

