/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.AbstractGraph;
import io.intino.konos.model.graph.Activity;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.jms.JMSService;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.tara.magritte.Graph;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KonosGraph
extends AbstractGraph {
    public KonosGraph(Graph graph) {
        super(graph);
    }

    public KonosGraph(Graph graph, KonosGraph wrapper) {
        super(graph, wrapper);
    }

    public static List<Display> displaysOf(Activity activity) {
        return activity.graph().core$().find(Display.class);
    }

    public static List<Dialog> dialogsOf(Activity activity) {
        return activity.graph().core$().find(Dialog.class);
    }

    public static List<Component> componentsOf(Activity activity) {
        ArrayList<Component> components = new ArrayList<Component>();
        components.addAll(KonosGraph.dialogsOf(activity));
        components.addAll(KonosGraph.displaysOf(activity));
        return components;
    }

    public Set<String> findCustomParameters(JMSService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (JMSService.Request request : service.requestList()) {
            set.addAll(KonosGraph.extractParameters(request.path()));
        }
        return set;
    }

    public Set<String> findCustomParameters(RESTService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (RESTService.Resource resource : service.resourceList()) {
            set.addAll(KonosGraph.extractParameters(resource.path()));
        }
        return set;
    }

    public Set<String> findCustomParameters(Activity activity) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (activity.authenticated() != null) {
            set.addAll(KonosGraph.extractParameters(activity.authenticated().by()));
        }
        for (Activity.AbstractPage page : activity.abstractPageList()) {
            for (String path : page.paths()) {
                set.addAll(KonosGraph.extractParameters(path));
            }
        }
        return set;
    }

    private static Set<String> extractParameters(String text) {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        Pattern pattern = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        return list;
    }
}

