/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.multiple.dialog.tab.MultipleInput;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.DoubleLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Dialog
extends Component
implements Terminal {
    protected String url;
    protected String label;
    protected String description;
    protected Mode mode;
    protected boolean readonly;
    protected Toolbar toolbar;
    protected List<Tab> tabList = new ArrayList<Tab>();

    public Dialog(Node node) {
        super(node);
    }

    public String url() {
        return this.url;
    }

    public String label() {
        return this.label;
    }

    public String description() {
        return this.description;
    }

    public Mode mode() {
        return this.mode;
    }

    public boolean readonly() {
        return this.readonly;
    }

    public Dialog url(String value) {
        this.url = value;
        return this;
    }

    public Dialog label(String value) {
        this.label = value;
        return this;
    }

    public Dialog description(String value) {
        this.description = value;
        return this;
    }

    public Dialog mode(Mode value) {
        this.mode = value;
        return this;
    }

    public Dialog readonly(boolean value) {
        this.readonly = value;
        return this;
    }

    public Toolbar toolbar() {
        return this.toolbar;
    }

    public List<Tab> tabList() {
        return Collections.unmodifiableList(this.tabList);
    }

    public Tab tab(int index) {
        return this.tabList.get(index);
    }

    public List<Tab> tabList(Predicate<Tab> predicate) {
        return this.tabList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Dialog toolbar(Toolbar value) {
        this.toolbar = value;
        return this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.toolbar != null) {
            components.add(this.toolbar.core$());
        }
        new ArrayList<Tab>(this.tabList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
        map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
        map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
        map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
        map.put("readonly", new ArrayList<Boolean>(Collections.singletonList(this.readonly)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Dialog$Toolbar")) {
            this.toolbar = (Toolbar)node.as(Toolbar.class);
        }
        if (node.is("Dialog$Tab")) {
            this.tabList.add((Tab)node.as(Tab.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Dialog$Toolbar")) {
            this.toolbar = null;
        }
        if (node.is("Dialog$Tab")) {
            this.tabList.remove(node.as(Tab.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("url")) {
            this.url = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("label")) {
            this.label = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("description")) {
            this.description = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("mode")) {
            this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("readonly")) {
            this.readonly = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("url")) {
            this.url = (String)values.get(0);
        } else if (name.equalsIgnoreCase("label")) {
            this.label = (String)values.get(0);
        } else if (name.equalsIgnoreCase("description")) {
            this.description = (String)values.get(0);
        } else if (name.equalsIgnoreCase("mode")) {
            this.mode = (Mode)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("readonly")) {
            this.readonly = (Boolean)values.get(0);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Tab
    extends Layer
    implements Terminal {
        protected String label;
        protected List<Input> inputList = new ArrayList<Input>();
        protected List<Text> textList = new ArrayList<Text>();
        protected List<Section> sectionList = new ArrayList<Section>();
        protected List<Memo> memoList = new ArrayList<Memo>();
        protected List<Password> passwordList = new ArrayList<Password>();
        protected List<OptionBox> optionBoxList = new ArrayList<OptionBox>();
        protected List<RadioBox> radioBoxList = new ArrayList<RadioBox>();
        protected List<CheckBox> checkBoxList = new ArrayList<CheckBox>();
        protected List<ComboBox> comboBoxList = new ArrayList<ComboBox>();
        protected List<Resource> resourceList = new ArrayList<Resource>();
        protected List<File> fileList = new ArrayList<File>();
        protected List<Picture> pictureList = new ArrayList<Picture>();
        protected List<Date> dateList = new ArrayList<Date>();
        protected List<DateTime> dateTimeList = new ArrayList<DateTime>();

        public Tab(Node node) {
            super(node);
        }

        public String label() {
            return this.label;
        }

        public Tab label(String value) {
            this.label = value;
            return this;
        }

        public List<Input> inputList() {
            return Collections.unmodifiableList(this.inputList);
        }

        public Input input(int index) {
            return this.inputList.get(index);
        }

        public List<Input> inputList(Predicate<Input> predicate) {
            return this.inputList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Text> textList() {
            return Collections.unmodifiableList(this.textList);
        }

        public Text text(int index) {
            return this.textList.get(index);
        }

        public List<Text> textList(Predicate<Text> predicate) {
            return this.textList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Section> sectionList() {
            return Collections.unmodifiableList(this.sectionList);
        }

        public Section section(int index) {
            return this.sectionList.get(index);
        }

        public List<Section> sectionList(Predicate<Section> predicate) {
            return this.sectionList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Memo> memoList() {
            return Collections.unmodifiableList(this.memoList);
        }

        public Memo memo(int index) {
            return this.memoList.get(index);
        }

        public List<Memo> memoList(Predicate<Memo> predicate) {
            return this.memoList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Password> passwordList() {
            return Collections.unmodifiableList(this.passwordList);
        }

        public Password password(int index) {
            return this.passwordList.get(index);
        }

        public List<Password> passwordList(Predicate<Password> predicate) {
            return this.passwordList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<OptionBox> optionBoxList() {
            return Collections.unmodifiableList(this.optionBoxList);
        }

        public OptionBox optionBox(int index) {
            return this.optionBoxList.get(index);
        }

        public List<OptionBox> optionBoxList(Predicate<OptionBox> predicate) {
            return this.optionBoxList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<RadioBox> radioBoxList() {
            return Collections.unmodifiableList(this.radioBoxList);
        }

        public RadioBox radioBox(int index) {
            return this.radioBoxList.get(index);
        }

        public List<RadioBox> radioBoxList(Predicate<RadioBox> predicate) {
            return this.radioBoxList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<CheckBox> checkBoxList() {
            return Collections.unmodifiableList(this.checkBoxList);
        }

        public CheckBox checkBox(int index) {
            return this.checkBoxList.get(index);
        }

        public List<CheckBox> checkBoxList(Predicate<CheckBox> predicate) {
            return this.checkBoxList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<ComboBox> comboBoxList() {
            return Collections.unmodifiableList(this.comboBoxList);
        }

        public ComboBox comboBox(int index) {
            return this.comboBoxList.get(index);
        }

        public List<ComboBox> comboBoxList(Predicate<ComboBox> predicate) {
            return this.comboBoxList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Resource> resourceList() {
            return Collections.unmodifiableList(this.resourceList);
        }

        public Resource resource(int index) {
            return this.resourceList.get(index);
        }

        public List<Resource> resourceList(Predicate<Resource> predicate) {
            return this.resourceList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<File> fileList() {
            return Collections.unmodifiableList(this.fileList);
        }

        public File file(int index) {
            return this.fileList.get(index);
        }

        public List<File> fileList(Predicate<File> predicate) {
            return this.fileList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Picture> pictureList() {
            return Collections.unmodifiableList(this.pictureList);
        }

        public Picture picture(int index) {
            return this.pictureList.get(index);
        }

        public List<Picture> pictureList(Predicate<Picture> predicate) {
            return this.pictureList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Date> dateList() {
            return Collections.unmodifiableList(this.dateList);
        }

        public Date date(int index) {
            return this.dateList.get(index);
        }

        public List<Date> dateList(Predicate<Date> predicate) {
            return this.dateList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<DateTime> dateTimeList() {
            return Collections.unmodifiableList(this.dateTimeList);
        }

        public DateTime dateTime(int index) {
            return this.dateTimeList.get(index);
        }

        public List<DateTime> dateTimeList(Predicate<DateTime> predicate) {
            return this.dateTimeList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Input>(this.inputList).forEach(c -> components.add(c.core$()));
            new ArrayList<Text>(this.textList).forEach(c -> components.add(c.core$()));
            new ArrayList<Section>(this.sectionList).forEach(c -> components.add(c.core$()));
            new ArrayList<Memo>(this.memoList).forEach(c -> components.add(c.core$()));
            new ArrayList<Password>(this.passwordList).forEach(c -> components.add(c.core$()));
            new ArrayList<OptionBox>(this.optionBoxList).forEach(c -> components.add(c.core$()));
            new ArrayList<RadioBox>(this.radioBoxList).forEach(c -> components.add(c.core$()));
            new ArrayList<CheckBox>(this.checkBoxList).forEach(c -> components.add(c.core$()));
            new ArrayList<ComboBox>(this.comboBoxList).forEach(c -> components.add(c.core$()));
            new ArrayList<Resource>(this.resourceList).forEach(c -> components.add(c.core$()));
            new ArrayList<File>(this.fileList).forEach(c -> components.add(c.core$()));
            new ArrayList<Picture>(this.pictureList).forEach(c -> components.add(c.core$()));
            new ArrayList<Date>(this.dateList).forEach(c -> components.add(c.core$()));
            new ArrayList<DateTime>(this.dateTimeList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Dialog$Tab$Input")) {
                this.inputList.add((Input)node.as(Input.class));
            }
            if (node.is("Dialog$Tab$Text")) {
                this.textList.add((Text)node.as(Text.class));
            }
            if (node.is("Dialog$Tab$Section")) {
                this.sectionList.add((Section)node.as(Section.class));
            }
            if (node.is("Dialog$Tab$Memo")) {
                this.memoList.add((Memo)node.as(Memo.class));
            }
            if (node.is("Dialog$Tab$Password")) {
                this.passwordList.add((Password)node.as(Password.class));
            }
            if (node.is("Dialog$Tab$OptionBox")) {
                this.optionBoxList.add((OptionBox)node.as(OptionBox.class));
            }
            if (node.is("Dialog$Tab$RadioBox")) {
                this.radioBoxList.add((RadioBox)node.as(RadioBox.class));
            }
            if (node.is("Dialog$Tab$CheckBox")) {
                this.checkBoxList.add((CheckBox)node.as(CheckBox.class));
            }
            if (node.is("Dialog$Tab$ComboBox")) {
                this.comboBoxList.add((ComboBox)node.as(ComboBox.class));
            }
            if (node.is("Dialog$Tab$Resource")) {
                this.resourceList.add((Resource)node.as(Resource.class));
            }
            if (node.is("Dialog$Tab$File")) {
                this.fileList.add((File)node.as(File.class));
            }
            if (node.is("Dialog$Tab$Picture")) {
                this.pictureList.add((Picture)node.as(Picture.class));
            }
            if (node.is("Dialog$Tab$Date")) {
                this.dateList.add((Date)node.as(Date.class));
            }
            if (node.is("Dialog$Tab$DateTime")) {
                this.dateTimeList.add((DateTime)node.as(DateTime.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Dialog$Tab$Input")) {
                this.inputList.remove(node.as(Input.class));
            }
            if (node.is("Dialog$Tab$Text")) {
                this.textList.remove(node.as(Text.class));
            }
            if (node.is("Dialog$Tab$Section")) {
                this.sectionList.remove(node.as(Section.class));
            }
            if (node.is("Dialog$Tab$Memo")) {
                this.memoList.remove(node.as(Memo.class));
            }
            if (node.is("Dialog$Tab$Password")) {
                this.passwordList.remove(node.as(Password.class));
            }
            if (node.is("Dialog$Tab$OptionBox")) {
                this.optionBoxList.remove(node.as(OptionBox.class));
            }
            if (node.is("Dialog$Tab$RadioBox")) {
                this.radioBoxList.remove(node.as(RadioBox.class));
            }
            if (node.is("Dialog$Tab$CheckBox")) {
                this.checkBoxList.remove(node.as(CheckBox.class));
            }
            if (node.is("Dialog$Tab$ComboBox")) {
                this.comboBoxList.remove(node.as(ComboBox.class));
            }
            if (node.is("Dialog$Tab$Resource")) {
                this.resourceList.remove(node.as(Resource.class));
            }
            if (node.is("Dialog$Tab$File")) {
                this.fileList.remove(node.as(File.class));
            }
            if (node.is("Dialog$Tab$Picture")) {
                this.pictureList.remove(node.as(Picture.class));
            }
            if (node.is("Dialog$Tab$Date")) {
                this.dateList.remove(node.as(Date.class));
            }
            if (node.is("Dialog$Tab$DateTime")) {
                this.dateTimeList.remove(node.as(DateTime.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class DateTime
        extends Input
        implements Terminal {
            protected String format;

            public DateTime(Node node) {
                super(node);
            }

            public String format() {
                return this.format;
            }

            public DateTime format(String value) {
                this.format = value;
                return this;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.a$(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.core$().addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.core$().is(MultipleInput.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("format", new ArrayList<String>(Collections.singletonList(this.format)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("format")) {
                    this.format = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("format")) {
                    this.format = (String)values.get(0);
                }
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Date
        extends Input
        implements Terminal {
            protected String format;

            public Date(Node node) {
                super(node);
            }

            public String format() {
                return this.format;
            }

            public Date format(String value) {
                this.format = value;
                return this;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.a$(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.core$().addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.core$().is(MultipleInput.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("format", new ArrayList<String>(Collections.singletonList(this.format)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("format")) {
                    this.format = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("format")) {
                    this.format = (String)values.get(0);
                }
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Picture
        extends Resource
        implements Terminal {
            public Picture(Node node) {
                super(node);
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.a$(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.core$().addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.core$().is(MultipleInput.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class File
        extends Resource
        implements Terminal {
            public File(Node node) {
                super(node);
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.a$(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.core$().addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.core$().is(MultipleInput.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static abstract class Resource
        extends Input
        implements Terminal {
            protected boolean showPreview;
            protected Validation validation;

            public Resource(Node node) {
                super(node);
            }

            public boolean showPreview() {
                return this.showPreview;
            }

            public Resource showPreview(boolean value) {
                this.showPreview = value;
                return this;
            }

            public Validation validation() {
                return this.validation;
            }

            public Resource validation(Validation value) {
                this.validation = value;
                return this;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.a$(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.core$().addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.core$().is(MultipleInput.class);
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                if (this.validation != null) {
                    components.add(this.validation.core$());
                }
                return new ArrayList<Node>(components);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("showPreview", new ArrayList<Boolean>(Collections.singletonList(this.showPreview)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Dialog$Tab$Resource$Validation")) {
                    this.validation = (Validation)node.as(Validation.class);
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Dialog$Tab$Resource$Validation")) {
                    this.validation = null;
                }
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("showPreview")) {
                    this.showPreview = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("showPreview")) {
                    this.showPreview = (Boolean)values.get(0);
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Validation
            extends Layer
            implements Terminal {
                protected double maxSize;
                protected List<String> allowedExtensions = new ArrayList<String>();

                public Validation(Node node) {
                    super(node);
                }

                public double maxSize() {
                    return this.maxSize;
                }

                public List<String> allowedExtensions() {
                    return this.allowedExtensions;
                }

                public String allowedExtensions(int index) {
                    return this.allowedExtensions.get(index);
                }

                public List<String> allowedExtensions(Predicate<String> predicate) {
                    return this.allowedExtensions().stream().filter(predicate).collect(Collectors.toList());
                }

                public Validation maxSize(double value) {
                    this.maxSize = value;
                    return this;
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("maxSize", new ArrayList<Double>(Collections.singletonList(this.maxSize)));
                    map.put("allowedExtensions", this.allowedExtensions);
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("maxSize")) {
                        this.maxSize = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("allowedExtensions")) {
                        this.allowedExtensions = StringLoader.load(values, (Layer)this);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("maxSize")) {
                        this.maxSize = (Double)values.get(0);
                    } else if (name.equalsIgnoreCase("allowedExtensions")) {
                        this.allowedExtensions = new ArrayList(values);
                    }
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public class Clear {
            }

            public class Create
            extends Input.Create {
                public Create(String name) {
                    super(name);
                }

                public Validation validation(double maxSize) {
                    Validation newElement = (Validation)Resource.this.core$().graph().concept(Validation.class).createNode(this.name, Resource.this.core$()).as(Validation.class);
                    newElement.core$().set((Layer)newElement, "maxSize", Collections.singletonList(maxSize));
                    return newElement;
                }
            }
        }

        public static class ComboBox
        extends OptionBox
        implements Terminal {
            public ComboBox(Node node) {
                super(node);
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.a$(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.core$().addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.core$().is(MultipleInput.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class CheckBox
        extends OptionBox
        implements Terminal {
            protected Mode mode;

            public CheckBox(Node node) {
                super(node);
            }

            public Mode mode() {
                return this.mode;
            }

            public CheckBox mode(Mode value) {
                this.mode = value;
                return this;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.a$(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.core$().addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.core$().is(MultipleInput.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("mode")) {
                    this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("mode")) {
                    this.mode = (Mode)((Object)values.get(0));
                }
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static enum Mode {
                Boolean,
                List;

            }
        }

        public static class RadioBox
        extends OptionBox
        implements Terminal {
            public RadioBox(Node node) {
                super(node);
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.a$(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.core$().addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.core$().is(MultipleInput.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static abstract class OptionBox
        extends Input
        implements Terminal {
            protected List<String> options = new ArrayList<String>();
            protected String source;

            public OptionBox(Node node) {
                super(node);
            }

            public List<String> options() {
                return this.options;
            }

            public String options(int index) {
                return this.options.get(index);
            }

            public List<String> options(Predicate<String> predicate) {
                return this.options().stream().filter(predicate).collect(Collectors.toList());
            }

            public String source() {
                return this.source;
            }

            public OptionBox source(String value) {
                this.source = value;
                return this;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.a$(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.core$().addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.core$().is(MultipleInput.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("options", this.options);
                map.put("source", new ArrayList<String>(Collections.singletonList(this.source)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("options")) {
                    this.options = StringLoader.load(values, (Layer)this);
                } else if (name.equalsIgnoreCase("source")) {
                    this.source = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("options")) {
                    this.options = new ArrayList(values);
                } else if (name.equalsIgnoreCase("source")) {
                    this.source = (String)values.get(0);
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Create
            extends Input.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Password
        extends Input
        implements Terminal {
            protected Validation validation;

            public Password(Node node) {
                super(node);
            }

            public Validation validation() {
                return this.validation;
            }

            public Password validation(Validation value) {
                this.validation = value;
                return this;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.a$(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.core$().addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.core$().is(MultipleInput.class);
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                if (this.validation != null) {
                    components.add(this.validation.core$());
                }
                return new ArrayList<Node>(components);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Dialog$Tab$Password$Validation")) {
                    this.validation = (Validation)node.as(Validation.class);
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Dialog$Tab$Password$Validation")) {
                    this.validation = null;
                }
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Validation
            extends Layer
            implements Terminal {
                protected List<Required> required = new ArrayList<Required>();
                protected Length length;

                public Validation(Node node) {
                    super(node);
                }

                public List<Required> required() {
                    return this.required;
                }

                public Length length() {
                    return this.length;
                }

                public Validation length(Length value) {
                    this.length = value;
                    return this;
                }

                protected List<Node> componentList$() {
                    LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                    if (this.length != null) {
                        components.add(this.length.core$());
                    }
                    return new ArrayList<Node>(components);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("required", this.required);
                    return map;
                }

                protected void addNode$(Node node) {
                    super.addNode$(node);
                    if (node.is("Dialog$Tab$Password$Validation$Length")) {
                        this.length = (Length)node.as(Length.class);
                    }
                }

                protected void removeNode$(Node node) {
                    super.removeNode$(node);
                    if (node.is("Dialog$Tab$Password$Validation$Length")) {
                        this.length = null;
                    }
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("required")) {
                        this.required = WordLoader.load(values, Required.class, (Layer)this);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("required")) {
                        this.required = new ArrayList(values);
                    }
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Clear clear() {
                    return new Clear();
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public static class Length
                extends Layer
                implements Terminal {
                    protected int min;
                    protected int max;

                    public Length(Node node) {
                        super(node);
                    }

                    public int min() {
                        return this.min;
                    }

                    public int max() {
                        return this.max;
                    }

                    public Length min(int value) {
                        this.min = value;
                        return this;
                    }

                    public Length max(int value) {
                        this.max = value;
                        return this;
                    }

                    protected Map<String, List<?>> variables$() {
                        LinkedHashMap map = new LinkedHashMap();
                        map.put("min", new ArrayList<Integer>(Collections.singletonList(this.min)));
                        map.put("max", new ArrayList<Integer>(Collections.singletonList(this.max)));
                        return map;
                    }

                    protected void load$(String name, List<?> values) {
                        super.load$(name, values);
                        if (name.equalsIgnoreCase("min")) {
                            this.min = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                        } else if (name.equalsIgnoreCase("max")) {
                            this.max = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                        }
                    }

                    protected void set$(String name, List<?> values) {
                        super.set$(name, values);
                        if (name.equalsIgnoreCase("min")) {
                            this.min = (Integer)values.get(0);
                        } else if (name.equalsIgnoreCase("max")) {
                            this.max = (Integer)values.get(0);
                        }
                    }

                    public KonosGraph graph() {
                        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                    }
                }

                public class Clear {
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public Length length(int min, int max) {
                        Length newElement = (Length)Validation.this.core$().graph().concept(Length.class).createNode(this.name, Validation.this.core$()).as(Length.class);
                        newElement.core$().set((Layer)newElement, "min", Collections.singletonList(min));
                        newElement.core$().set((Layer)newElement, "max", Collections.singletonList(max));
                        return newElement;
                    }
                }

                public static enum Required {
                    letter,
                    number,
                    symbol;

                }
            }

            public class Clear {
            }

            public class Create
            extends Input.Create {
                public Create(String name) {
                    super(name);
                }

                public Validation validation() {
                    Validation newElement = (Validation)Password.this.core$().graph().concept(Validation.class).createNode(this.name, Password.this.core$()).as(Validation.class);
                    return newElement;
                }
            }
        }

        public static class Memo
        extends Input
        implements Terminal {
            protected Mode mode;
            protected int height;

            public Memo(Node node) {
                super(node);
            }

            public Mode mode() {
                return this.mode;
            }

            public int height() {
                return this.height;
            }

            public Memo mode(Mode value) {
                this.mode = value;
                return this;
            }

            public Memo height(int value) {
                this.height = value;
                return this;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.a$(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.core$().addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.core$().is(MultipleInput.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
                map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("mode")) {
                    this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("height")) {
                    this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("mode")) {
                    this.mode = (Mode)((Object)values.get(0));
                } else if (name.equalsIgnoreCase("height")) {
                    this.height = (Integer)values.get(0);
                }
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static enum Mode {
                raw,
                rich;

            }
        }

        public static class Section
        extends Input
        implements Terminal {
            protected List<Input> inputList = new ArrayList<Input>();

            public Section(Node node) {
                super(node);
            }

            public List<Input> inputList() {
                return Collections.unmodifiableList(this.inputList);
            }

            public Input input(int index) {
                return this.inputList.get(index);
            }

            public List<Input> inputList(Predicate<Input> predicate) {
                return this.inputList().stream().filter(predicate).collect(Collectors.toList());
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.a$(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.core$().addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.core$().is(MultipleInput.class);
            }

            protected List<Node> componentList$() {
                LinkedHashSet components = new LinkedHashSet(super.componentList$());
                new ArrayList<Input>(this.inputList).forEach(c -> components.add(c.core$()));
                return new ArrayList<Node>(components);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Dialog$Tab$Input")) {
                    this.inputList.add((Input)node.as(Input.class));
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Dialog$Tab$Input")) {
                    this.inputList.remove(node.as(Input.class));
                }
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
            }

            public class Create
            extends Input.Create {
                public Create(String name) {
                    super(name);
                }

                public Password password(String label) {
                    Password newElement = (Password)Section.this.core$().graph().concept(Password.class).createNode(this.name, Section.this.core$()).as(Password.class);
                    newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public Text text(String label) {
                    Text newElement = (Text)Section.this.core$().graph().concept(Text.class).createNode(this.name, Section.this.core$()).as(Text.class);
                    newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public RadioBox radioBox(String label) {
                    RadioBox newElement = (RadioBox)Section.this.core$().graph().concept(RadioBox.class).createNode(this.name, Section.this.core$()).as(RadioBox.class);
                    newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public ComboBox comboBox(String label) {
                    ComboBox newElement = (ComboBox)Section.this.core$().graph().concept(ComboBox.class).createNode(this.name, Section.this.core$()).as(ComboBox.class);
                    newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public Picture picture(String label) {
                    Picture newElement = (Picture)Section.this.core$().graph().concept(Picture.class).createNode(this.name, Section.this.core$()).as(Picture.class);
                    newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public Date date(String label) {
                    Date newElement = (Date)Section.this.core$().graph().concept(Date.class).createNode(this.name, Section.this.core$()).as(Date.class);
                    newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public Memo memo(String label) {
                    Memo newElement = (Memo)Section.this.core$().graph().concept(Memo.class).createNode(this.name, Section.this.core$()).as(Memo.class);
                    newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public CheckBox checkBox(String label, CheckBox.Mode mode) {
                    CheckBox newElement = (CheckBox)Section.this.core$().graph().concept(CheckBox.class).createNode(this.name, Section.this.core$()).as(CheckBox.class);
                    newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                    newElement.core$().set((Layer)newElement, "mode", Collections.singletonList(mode));
                    return newElement;
                }

                public Section section(String label) {
                    Section newElement = (Section)Section.this.core$().graph().concept(Section.class).createNode(this.name, Section.this.core$()).as(Section.class);
                    newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public File file(String label) {
                    File newElement = (File)Section.this.core$().graph().concept(File.class).createNode(this.name, Section.this.core$()).as(File.class);
                    newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public DateTime dateTime(String label) {
                    DateTime newElement = (DateTime)Section.this.core$().graph().concept(DateTime.class).createNode(this.name, Section.this.core$()).as(DateTime.class);
                    newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }
            }
        }

        public static class Text
        extends Input
        implements Terminal {
            protected Edition edition;
            protected Validation validation;

            public Text(Node node) {
                super(node);
            }

            public Edition edition() {
                return this.edition;
            }

            public Text edition(Edition value) {
                this.edition = value;
                return this;
            }

            public Validation validation() {
                return this.validation;
            }

            public Text validation(Validation value) {
                this.validation = value;
                return this;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.a$(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.core$().addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.core$().is(MultipleInput.class);
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                if (this.validation != null) {
                    components.add(this.validation.core$());
                }
                return new ArrayList<Node>(components);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("edition", new ArrayList<Edition>(Collections.singletonList(this.edition)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Dialog$Tab$Text$Validation")) {
                    this.validation = (Validation)node.as(Validation.class);
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Dialog$Tab$Text$Validation")) {
                    this.validation = null;
                }
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("edition")) {
                    this.edition = (Edition)((Object)WordLoader.load(values, Edition.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("edition")) {
                    this.edition = (Edition)((Object)values.get(0));
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Validation
            extends Layer
            implements Terminal {
                protected List<String> allowedValues = new ArrayList<String>();
                protected List<String> disallowedValues = new ArrayList<String>();
                protected boolean disallowEmptySpaces;
                protected String mask;
                protected Length length;

                public Validation(Node node) {
                    super(node);
                }

                public List<String> allowedValues() {
                    return this.allowedValues;
                }

                public String allowedValues(int index) {
                    return this.allowedValues.get(index);
                }

                public List<String> allowedValues(Predicate<String> predicate) {
                    return this.allowedValues().stream().filter(predicate).collect(Collectors.toList());
                }

                public List<String> disallowedValues() {
                    return this.disallowedValues;
                }

                public String disallowedValues(int index) {
                    return this.disallowedValues.get(index);
                }

                public List<String> disallowedValues(Predicate<String> predicate) {
                    return this.disallowedValues().stream().filter(predicate).collect(Collectors.toList());
                }

                public boolean disallowEmptySpaces() {
                    return this.disallowEmptySpaces;
                }

                public String mask() {
                    return this.mask;
                }

                public Validation disallowEmptySpaces(boolean value) {
                    this.disallowEmptySpaces = value;
                    return this;
                }

                public Validation mask(String value) {
                    this.mask = value;
                    return this;
                }

                public Length length() {
                    return this.length;
                }

                public Validation length(Length value) {
                    this.length = value;
                    return this;
                }

                protected List<Node> componentList$() {
                    LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                    if (this.length != null) {
                        components.add(this.length.core$());
                    }
                    return new ArrayList<Node>(components);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("allowedValues", this.allowedValues);
                    map.put("disallowedValues", this.disallowedValues);
                    map.put("disallowEmptySpaces", new ArrayList<Boolean>(Collections.singletonList(this.disallowEmptySpaces)));
                    map.put("mask", new ArrayList<String>(Collections.singletonList(this.mask)));
                    return map;
                }

                protected void addNode$(Node node) {
                    super.addNode$(node);
                    if (node.is("Dialog$Tab$Text$Validation$Length")) {
                        this.length = (Length)node.as(Length.class);
                    }
                }

                protected void removeNode$(Node node) {
                    super.removeNode$(node);
                    if (node.is("Dialog$Tab$Text$Validation$Length")) {
                        this.length = null;
                    }
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("allowedValues")) {
                        this.allowedValues = StringLoader.load(values, (Layer)this);
                    } else if (name.equalsIgnoreCase("disallowedValues")) {
                        this.disallowedValues = StringLoader.load(values, (Layer)this);
                    } else if (name.equalsIgnoreCase("disallowEmptySpaces")) {
                        this.disallowEmptySpaces = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("mask")) {
                        this.mask = (String)StringLoader.load(values, (Layer)this).get(0);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("allowedValues")) {
                        this.allowedValues = new ArrayList(values);
                    } else if (name.equalsIgnoreCase("disallowedValues")) {
                        this.disallowedValues = new ArrayList(values);
                    } else if (name.equalsIgnoreCase("disallowEmptySpaces")) {
                        this.disallowEmptySpaces = (Boolean)values.get(0);
                    } else if (name.equalsIgnoreCase("mask")) {
                        this.mask = (String)values.get(0);
                    }
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Clear clear() {
                    return new Clear();
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public static class Length
                extends Layer
                implements Terminal {
                    protected int min;
                    protected int max;

                    public Length(Node node) {
                        super(node);
                    }

                    public int min() {
                        return this.min;
                    }

                    public int max() {
                        return this.max;
                    }

                    public Length min(int value) {
                        this.min = value;
                        return this;
                    }

                    public Length max(int value) {
                        this.max = value;
                        return this;
                    }

                    protected Map<String, List<?>> variables$() {
                        LinkedHashMap map = new LinkedHashMap();
                        map.put("min", new ArrayList<Integer>(Collections.singletonList(this.min)));
                        map.put("max", new ArrayList<Integer>(Collections.singletonList(this.max)));
                        return map;
                    }

                    protected void load$(String name, List<?> values) {
                        super.load$(name, values);
                        if (name.equalsIgnoreCase("min")) {
                            this.min = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                        } else if (name.equalsIgnoreCase("max")) {
                            this.max = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                        }
                    }

                    protected void set$(String name, List<?> values) {
                        super.set$(name, values);
                        if (name.equalsIgnoreCase("min")) {
                            this.min = (Integer)values.get(0);
                        } else if (name.equalsIgnoreCase("max")) {
                            this.max = (Integer)values.get(0);
                        }
                    }

                    public KonosGraph graph() {
                        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                    }
                }

                public class Clear {
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public Length length(int min, int max) {
                        Length newElement = (Length)Validation.this.core$().graph().concept(Length.class).createNode(this.name, Validation.this.core$()).as(Length.class);
                        newElement.core$().set((Layer)newElement, "min", Collections.singletonList(min));
                        newElement.core$().set((Layer)newElement, "max", Collections.singletonList(max));
                        return newElement;
                    }
                }
            }

            public class Clear {
            }

            public class Create
            extends Input.Create {
                public Create(String name) {
                    super(name);
                }

                public Validation validation() {
                    Validation newElement = (Validation)Text.this.core$().graph().concept(Validation.class).createNode(this.name, Text.this.core$()).as(Validation.class);
                    return newElement;
                }
            }

            public static enum Edition {
                Normal,
                Uppercase,
                Lowercase,
                Email,
                Url;

            }
        }

        public static abstract class Input
        extends Layer
        implements Terminal {
            protected String label;
            protected boolean required;
            protected boolean readonly;
            protected String placeHolder;
            protected String helper;
            protected String defaultValue;
            protected String validator;

            public Input(Node node) {
                super(node);
            }

            public String label() {
                return this.label;
            }

            public boolean required() {
                return this.required;
            }

            public boolean readonly() {
                return this.readonly;
            }

            public String placeHolder() {
                return this.placeHolder;
            }

            public String helper() {
                return this.helper;
            }

            public String defaultValue() {
                return this.defaultValue;
            }

            public String validator() {
                return this.validator;
            }

            public Input label(String value) {
                this.label = value;
                return this;
            }

            public Input required(boolean value) {
                this.required = value;
                return this;
            }

            public Input readonly(boolean value) {
                this.readonly = value;
                return this;
            }

            public Input placeHolder(String value) {
                this.placeHolder = value;
                return this;
            }

            public Input helper(String value) {
                this.helper = value;
                return this;
            }

            public Input defaultValue(String value) {
                this.defaultValue = value;
                return this;
            }

            public Input validator(String value) {
                this.validator = value;
                return this;
            }

            public MultipleInput asMultiple() {
                Layer as = this.a$(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.core$().addFacet(MultipleInput.class);
            }

            public boolean isMultiple() {
                return this.core$().is(MultipleInput.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
                map.put("required", new ArrayList<Boolean>(Collections.singletonList(this.required)));
                map.put("readonly", new ArrayList<Boolean>(Collections.singletonList(this.readonly)));
                map.put("placeHolder", new ArrayList<String>(Collections.singletonList(this.placeHolder)));
                map.put("helper", new ArrayList<String>(Collections.singletonList(this.helper)));
                map.put("defaultValue", new ArrayList<String>(Collections.singletonList(this.defaultValue)));
                map.put("validator", new ArrayList<String>(Collections.singletonList(this.validator)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("required")) {
                    this.required = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("readonly")) {
                    this.readonly = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("placeHolder")) {
                    this.placeHolder = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("helper")) {
                    this.helper = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("defaultValue")) {
                    this.defaultValue = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("validator")) {
                    this.validator = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)values.get(0);
                } else if (name.equalsIgnoreCase("required")) {
                    this.required = (Boolean)values.get(0);
                } else if (name.equalsIgnoreCase("readonly")) {
                    this.readonly = (Boolean)values.get(0);
                } else if (name.equalsIgnoreCase("placeHolder")) {
                    this.placeHolder = (String)values.get(0);
                } else if (name.equalsIgnoreCase("helper")) {
                    this.helper = (String)values.get(0);
                } else if (name.equalsIgnoreCase("defaultValue")) {
                    this.defaultValue = (String)values.get(0);
                } else if (name.equalsIgnoreCase("validator")) {
                    this.validator = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Clear {
            public void text(Predicate<Text> filter) {
                new ArrayList<Text>(Tab.this.textList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void section(Predicate<Section> filter) {
                new ArrayList<Section>(Tab.this.sectionList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void memo(Predicate<Memo> filter) {
                new ArrayList<Memo>(Tab.this.memoList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void password(Predicate<Password> filter) {
                new ArrayList<Password>(Tab.this.passwordList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void radioBox(Predicate<RadioBox> filter) {
                new ArrayList<RadioBox>(Tab.this.radioBoxList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void checkBox(Predicate<CheckBox> filter) {
                new ArrayList<CheckBox>(Tab.this.checkBoxList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void comboBox(Predicate<ComboBox> filter) {
                new ArrayList<ComboBox>(Tab.this.comboBoxList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void file(Predicate<File> filter) {
                new ArrayList<File>(Tab.this.fileList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void picture(Predicate<Picture> filter) {
                new ArrayList<Picture>(Tab.this.pictureList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void date(Predicate<Date> filter) {
                new ArrayList<Date>(Tab.this.dateList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void dateTime(Predicate<DateTime> filter) {
                new ArrayList<DateTime>(Tab.this.dateTimeList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Text text(String label) {
                Text newElement = (Text)Tab.this.core$().graph().concept(Text.class).createNode(this.name, Tab.this.core$()).as(Text.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public Section section(String label) {
                Section newElement = (Section)Tab.this.core$().graph().concept(Section.class).createNode(this.name, Tab.this.core$()).as(Section.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public Memo memo(String label) {
                Memo newElement = (Memo)Tab.this.core$().graph().concept(Memo.class).createNode(this.name, Tab.this.core$()).as(Memo.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public Password password(String label) {
                Password newElement = (Password)Tab.this.core$().graph().concept(Password.class).createNode(this.name, Tab.this.core$()).as(Password.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public RadioBox radioBox(String label) {
                RadioBox newElement = (RadioBox)Tab.this.core$().graph().concept(RadioBox.class).createNode(this.name, Tab.this.core$()).as(RadioBox.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public CheckBox checkBox(String label, CheckBox.Mode mode) {
                CheckBox newElement = (CheckBox)Tab.this.core$().graph().concept(CheckBox.class).createNode(this.name, Tab.this.core$()).as(CheckBox.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                newElement.core$().set((Layer)newElement, "mode", Collections.singletonList(mode));
                return newElement;
            }

            public ComboBox comboBox(String label) {
                ComboBox newElement = (ComboBox)Tab.this.core$().graph().concept(ComboBox.class).createNode(this.name, Tab.this.core$()).as(ComboBox.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public File file(String label) {
                File newElement = (File)Tab.this.core$().graph().concept(File.class).createNode(this.name, Tab.this.core$()).as(File.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public Picture picture(String label) {
                Picture newElement = (Picture)Tab.this.core$().graph().concept(Picture.class).createNode(this.name, Tab.this.core$()).as(Picture.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public Date date(String label) {
                Date newElement = (Date)Tab.this.core$().graph().concept(Date.class).createNode(this.name, Tab.this.core$()).as(Date.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public DateTime dateTime(String label) {
                DateTime newElement = (DateTime)Tab.this.core$().graph().concept(DateTime.class).createNode(this.name, Tab.this.core$()).as(DateTime.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }
        }
    }

    public static class Toolbar
    extends Layer
    implements Terminal {
        protected List<Operation> operationList = new ArrayList<Operation>();

        public Toolbar(Node node) {
            super(node);
        }

        public List<Operation> operationList() {
            return Collections.unmodifiableList(this.operationList);
        }

        public Operation operation(int index) {
            return this.operationList.get(index);
        }

        public List<Operation> operationList(Predicate<Operation> predicate) {
            return this.operationList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Operation>(this.operationList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Dialog$Toolbar$Operation")) {
                this.operationList.add((Operation)node.as(Operation.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Dialog$Toolbar$Operation")) {
                this.operationList.remove(node.as(Operation.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Operation
        extends Layer
        implements Terminal {
            protected String label;

            public Operation(Node node) {
                super(node);
            }

            public String label() {
                return this.label;
            }

            public Operation label(String value) {
                this.label = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)values.get(0);
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public class Clear {
            public void operation(Predicate<Operation> filter) {
                new ArrayList<Operation>(Toolbar.this.operationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Operation operation(String label) {
                Operation newElement = (Operation)Toolbar.this.core$().graph().concept(Operation.class).createNode(this.name, Toolbar.this.core$()).as(Operation.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }
        }
    }

    public class Clear {
        public void tab(Predicate<Tab> filter) {
            new ArrayList<Tab>(Dialog.this.tabList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Component.Create {
        public Create(String name) {
            super(name);
        }

        public Toolbar toolbar() {
            Toolbar newElement = (Toolbar)Dialog.this.core$().graph().concept(Toolbar.class).createNode(this.name, Dialog.this.core$()).as(Toolbar.class);
            return newElement;
        }

        public Tab tab(String label) {
            Tab newElement = (Tab)Dialog.this.core$().graph().concept(Tab.class).createNode(this.name, Dialog.this.core$()).as(Tab.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }
    }

    public static enum Mode {
        Tabs,
        Wizard;

    }
}

