/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.utils;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import io.intino.konos.builder.utils.KonosUtils;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.Language;
import io.intino.tara.StashBuilder;
import io.intino.tara.io.Stash;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import tara.dsl.Konos;

public class GraphLoader {
    public static KonosGraph loadGraph(Module module) {
        List<PsiFile> konosFiles = KonosUtils.findKonosFiles(module);
        if (!konosFiles.isEmpty()) {
            Map<File, Charset> files = konosFiles.stream().map(PsiFile::getVirtualFile).collect(Collectors.toMap(vf -> new File(vf.getPath()), VirtualFile::getCharset));
            Stash stash = new StashBuilder(files, (Language)new Konos(), module.getName()).build();
            if (stash == null) {
                return null;
            }
            return GraphLoader.loadGraph(stash);
        }
        return GraphLoader.loadGraph(new Stash[0]);
    }

    public static KonosGraph loadGraph(Stash ... stashes) {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(GraphLoader.class.getClassLoader());
        Graph graph = new Graph().loadStashes(new String[]{"Konos"}).loadStashes(stashes);
        Thread.currentThread().setContextClassLoader(currentLoader);
        return graph == null ? null : (KonosGraph)graph.as(KonosGraph.class);
    }
}

