/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display;

import java.util.Locale;
import org.siani.itrules.LineSeparator;
import org.siani.itrules.Template;
import org.siani.itrules.model.Condition;
import org.siani.itrules.model.Rule;
import org.siani.itrules.model.Token;

public class DisplaysTemplate
extends Template {
    protected DisplaysTemplate(Locale locale, LineSeparator separator) {
        super(locale, separator);
    }

    public static Template create() {
        return new DisplaysTemplate(Locale.ENGLISH, LineSeparator.LF).define();
    }

    public Template define() {
        this.add(new Rule[]{this.rule().add(new Condition[]{this.condition("type", "Displays")}).add((Token.Body)this.literal("package ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".displays;\n\nimport io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;\nimport io.intino.konos.alexandria.activity.displays.*;\nimport ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box;\n\nimport java.lang.reflect.Constructor;\nimport java.lang.reflect.InvocationTargetException;\nimport java.util.HashMap;\nimport java.util.Map;\n\npublic class Displays {\n\tprivate static Map<String, ElementDisplayBuilder> displayMap = new HashMap<>();\n\n\tstatic {\n\t\t{\n\t\t\t")).add((Token.Body)this.mark("display", new String[0]).multiple("\n")).add((Token.Body)this.literal("\n\t\t\t")).add((Token.Body)this.mark("dialog", new String[0]).multiple("\n")).add((Token.Body)this.literal("\n\t\t}\n\t}\n\n\tpublic static AlexandriaElementDisplay displayFor(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box, String name) {\n\t\tif (!displayMap.containsKey(name)) return null;\n\t\treturn displayMap.get(name).build(box);\n\t}\n\n\tpublic static AlexandriaElementDisplay displayFor(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box, io.intino.konos.alexandria.activity.model.Element element) {\n\t\tif (!displayMap.containsKey(element.name())) return defaultElement(box, element);\n\t\treturn displayMap.get(element.name()).build(box);\n\t}\n\n\tpublic static <T extends io.intino.konos.alexandria.activity.model.Element> java.util.List<T> elementsFor(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box, Class<T> tClass, String... elements) {\n\t\tjava.util.List<T> list = new java.util.ArrayList<>();\n\t\tfor (String element : elements)\n\t\t\tlist.add((T) displayMap.get(element).build(box).element());\n\t\treturn list;\n\t}\n\n\tpublic static Class<? extends AlexandriaElementDisplay> displayTypeFor(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box, io.intino.konos.alexandria.activity.model.Element element) {\n\t\tif (!displayMap.containsKey(element.name())) return defaultElementType(box, element);\n\t\treturn displayMap.get(element.name()).build(box).getClass();\n\t}\n\n\tprivate static Class<? extends AlexandriaElementDisplay> defaultElementType(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box, io.intino.konos.alexandria.activity.model.Element element) {\n\t\tif (element instanceof io.intino.konos.alexandria.activity.model.Panel) return AlexandriaPanel.class;\n\n\t\tif (element instanceof io.intino.konos.alexandria.activity.model.TemporalCatalog)\n\t\t\treturn ((io.intino.konos.alexandria.activity.model.TemporalCatalog) element).type() == io.intino.konos.alexandria.activity.model.TemporalCatalog.Type.Range ? AlexandriaTemporalRangeCatalog.class : AlexandriaTemporalTimeCatalog.class;\n\n\t\tif (element instanceof io.intino.konos.alexandria.activity.model.Catalog)\n\t\t\treturn AlexandriaCatalog.class;\n\n\t\tif (element instanceof io.intino.konos.alexandria.activity.model.Layout)\n\t\t\treturn ((io.intino.konos.alexandria.activity.model.Layout) element).mode() == io.intino.konos.alexandria.activity.model.Layout.Mode.Menu ? AlexandriaMenuLayout.class : AlexandriaTabLayout.class;\n\n\t\tif (element instanceof io.intino.konos.alexandria.activity.model.Desktop)\n\t\t\treturn AlexandriaDesktop.class;\n\n\t\treturn null;\n\t}\n\n\tprivate static AlexandriaElementDisplay defaultElement(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box, io.intino.konos.alexandria.activity.model.Element element) {\n\t\tif (element instanceof io.intino.konos.alexandria.activity.model.Panel) return new AlexandriaPanel(box);\n\n\t\tif (element instanceof io.intino.konos.alexandria.activity.model.TemporalCatalog)\n\t\t\treturn ((io.intino.konos.alexandria.activity.model.TemporalCatalog) element).type() == io.intino.konos.alexandria.activity.model.TemporalCatalog.Type.Range ? new AlexandriaTemporalRangeCatalog(box) : new AlexandriaTemporalTimeCatalog(box);\n\n\t\tif (element instanceof io.intino.konos.alexandria.activity.model.Catalog)\n\t\t\treturn new AlexandriaCatalog(box);\n\n\t\tif (element instanceof io.intino.konos.alexandria.activity.model.Layout)\n\t\t\treturn ((io.intino.konos.alexandria.activity.model.Layout) element).mode() == io.intino.konos.alexandria.activity.model.Layout.Mode.Menu ? new AlexandriaMenuLayout(box) : new AlexandriaTabLayout(box);\n\n\t\tif (element instanceof io.intino.konos.alexandria.activity.model.Desktop)\n\t\t\treturn new AlexandriaDesktop(box);\n\n\t\treturn null;\n\t}\n\n/*\t\tprivate void refreshCatalog(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box, String catalog, Item... items) {\n\t\tactivitySouls.values().stream().map(Soul::getAll).flatMap(Collection::stream)\n\t\t\t\t.filter(d -> d instanceof AlexandriaAbstractCatalog && ((AlexandriaAbstractCatalog) d)\n\t\t\t\t\t\t.isFor(catalog)).forEach(d -> {\n\t\t\tAlexandriaAbstractCatalog display = (AlexandriaAbstractCatalog) d;\n\t\t\tdisplay.dirty(true);\n\t\t\tif (categorizationsHaveChanges || items.length == 0)\n\t\t\t\tdisplay.refresh();\n\t\t\telse\n\t\t\t\tdisplay.refresh(items);\n\t\t});\n\t}\n*/\n\tprivate interface ElementDisplayBuilder {\n\t\tAlexandriaElementDisplay build(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box);\n\t}\n}")), this.rule().add(new Condition[]{this.condition("trigger", "display")}).add((Token.Body)this.literal("displayMap.put(\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\", (box) -> new ")).add((Token.Body)this.mark("name", new String[]{"FirstUpperCase"})).add((Token.Body)this.literal("(box));")), this.rule().add(new Condition[]{this.condition("trigger", "dialog")}).add((Token.Body)this.literal("dialogMap.put(\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\", (box) -> new ")).add((Token.Body)this.mark("name", new String[]{"FirstUpperCase"})).add((Token.Body)this.literal("(box));"))});
        return this;
    }
}

