/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.activity.ActivityTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Activity;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class ActivityRenderer {
    private final File src;
    private final File gen;
    private final String packageName;
    private final String boxName;
    private final List<Activity> activities;

    public ActivityRenderer(KonosGraph graph, File src, File gen, String packageName, String boxName) {
        this.src = src;
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
        this.activities = graph.activityList();
    }

    public void execute() {
        this.activities.forEach(this::processActivity);
    }

    private void processActivity(Activity activity) {
        List<Dialog> dialogs = KonosGraph.dialogsOf(activity);
        List<Display> displays = KonosGraph.displaysOf(activity);
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"activity"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{activity.name$()}).addSlot("box", new String[]{this.boxName}).addSlot("resource", (AbstractFrame[])this.resourcesFrame(activity.abstractPageList()));
        if (activity.userHome() != null) {
            frame.addSlot("userHome", new String[]{activity.userHome().name$()});
        }
        if (!dialogs.isEmpty()) {
            frame.addSlot("dialog", (AbstractFrame[])this.dialogsFrame(dialogs)).addSlot("dialogsImport", new String[]{this.packageName});
        }
        if (!displays.isEmpty()) {
            frame.addSlot("display", (AbstractFrame[])this.displaysFrame(displays)).addSlot("displaysImport", new String[]{this.packageName});
        }
        if (activity.authenticated() != null) {
            frame.addSlot("auth", new String[]{activity.authenticated().by()});
        }
        Commons.writeFrame(this.gen, StringHelper.snakeCaseToCamelCase((String)(activity.name$() + "Activity")), this.template().format((Object)frame));
    }

    private Frame[] resourcesFrame(List<Activity.AbstractPage> pages) {
        return (Frame[])pages.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame[] displaysFrame(List<Display> displays) {
        return (Frame[])displays.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame[] dialogsFrame(List<Dialog> dialogs) {
        return (Frame[])dialogs.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame frameOf(Activity.AbstractPage resource) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"resource", "abstractPage"});
        frame.addSlot("name", new String[]{resource.name$()});
        Activity activity = (Activity)resource.core$().ownerAs(Activity.class);
        for (String path : resource.paths()) {
            Set<String> custom = Commons.extractParameters(path);
            Frame pathFrame = new Frame(new String[0]).addSlot("value", new String[]{path}).addSlot("name", new String[]{resource.name$()});
            if (activity.userHome() != null) {
                pathFrame.addSlot("userHome", new String[]{activity.userHome().name$()});
            }
            if (!custom.isEmpty()) {
                pathFrame.addSlot("custom", custom.toArray(new String[custom.size()]));
            }
            frame.addSlot("path", new AbstractFrame[]{pathFrame});
        }
        return frame;
    }

    private Frame frameOf(Display display) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"display"});
        frame.addSlot("name", new String[]{display.name$()}).addSlot("package", new String[]{this.packageName});
        if (display.requestList().stream().anyMatch(r -> r.responseType().equals((Object)Display.Request.ResponseType.Asset))) {
            frame.addSlot("asset", new String[]{display.name$()});
        }
        return frame;
    }

    private Frame frameOf(Dialog dialog) {
        return new Frame(new String[0]).addTypes(new String[]{"dialog"}).addSlot("name", new String[]{dialog.name$()}).addSlot("package", new String[]{this.packageName});
    }

    private Template template() {
        Template template = ActivityTemplate.create();
        this.addFormats(template);
        return template;
    }

    private void addFormats(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
    }
}

