/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display.prototypes.updaters;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.MoldRenderer;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.MoldTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.PrototypeRenderer;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.updaters.Updater;
import io.intino.konos.model.graph.Mold;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;

public class MoldUpdater
extends Updater {
    private final MoldRenderer moldRenderer;
    private final Template template;
    private PsiClass stamps;
    private Mold mold;
    private PsiClass psiClass;

    public MoldUpdater(File sourceFile, Mold mold, Project project, String packageName, String box) {
        super(sourceFile, project, packageName, box);
        this.mold = mold;
        this.moldRenderer = new MoldRenderer(project, mold, null, null, packageName, box);
        this.template = PrototypeRenderer.customize(MoldTemplate.create());
        if (this.file != null && this.file instanceof PsiJavaFile && ((PsiJavaFile)this.file).getClasses().length != 0) {
            this.psiClass = ((PsiJavaFile)this.file).getClasses()[0];
            this.stamps = this.innerClass(this.psiClass, "Stamps");
            if (this.stamps == null) {
                PsiClass stamps = this.createInnerClass("Stamps");
                this.psiClass.addAfter(this.psiClass.getConstructors()[0].getNextSibling(), (PsiElement)stamps);
                this.stamps = stamps;
            }
        }
    }

    @Override
    public void update() {
        if (this.psiClass == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
            WriteCommandAction.runWriteCommandAction((Project)this.project, this::updateMold);
        } else {
            this.updateMold();
        }
    }

    private void updateMold() {
        this.update(this.mold.blockList());
    }

    private void update(List<Mold.Block> blocks) {
        for (Mold.Block block : blocks) {
            this.updateStamps(block.stampList());
            this.update(block.blockList());
        }
    }

    private void updateStamps(List<Mold.Block.Stamp> stamps) {
        for (Mold.Block.Stamp stamp : stamps) {
            if (this.exists(stamp)) continue;
            this.update(stamp);
        }
    }

    private void update(Mold.Block.Stamp stamp) {
        String text = this.classFor(stamp);
        if (!text.isEmpty()) {
            this.stamps.addAfter((PsiElement)this.createClass(text, this.psiClass), this.stamps.getLBrace().getNextSibling());
        }
    }

    private boolean exists(Mold.Block.Stamp stamp) {
        return this.innerClass(this.stamps, Formatters.firstUpperCase(stamp.name$())) != null;
    }

    private String classFor(Mold.Block.Stamp stamp) {
        return this.template.format((Object)this.moldRenderer.frameOf(stamp));
    }
}

