/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.exception;

import io.intino.konos.builder.codegeneration.exception.ExceptionTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.Frame;

public class ExceptionRenderer {
    private static final String EXCEPTIONS = "exceptions";
    private final List<Exception> exceptions;
    private File gen;
    private String packageName;

    public ExceptionRenderer(KonosGraph graph, File gen, String packageName) {
        this.exceptions = graph.exceptionList();
        this.gen = gen;
        this.packageName = packageName;
    }

    public void execute() {
        this.exceptions.forEach(this::processException);
    }

    private void processException(Exception exception) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"exception"});
        frame.addSlot("name", new String[]{exception.name$()});
        frame.addSlot("code", new Object[]{exception.code()});
        frame.addSlot("package", new String[]{this.packageName});
        Commons.writeFrame(this.destinyPackage(this.gen), Commons.firstUpperCase(exception.name$()), this.template().format((Object)frame));
    }

    private File destinyPackage(File destiny) {
        return new File(destiny, EXCEPTIONS);
    }

    private Template template() {
        return ExceptionTemplate.create();
    }
}

