/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.CatalogView;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Operation;
import io.intino.konos.model.graph.Toolbar;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractToolbar
extends Layer
implements Component,
Terminal {
    protected boolean canSearch;
    protected OpenDialog openDialog;
    protected Task task;
    protected TaskSelection taskSelection;
    protected Download download;
    protected DownloadSelection downloadSelection;
    protected Export export;
    protected ExportSelection exportSelection;
    protected OpenCatalog openCatalog;
    protected OpenCatalogSelection openCatalogSelection;

    public AbstractToolbar(Node node) {
        super(node);
    }

    public boolean canSearch() {
        return this.canSearch;
    }

    public Toolbar canSearch(boolean value) {
        this.canSearch = value;
        return (Toolbar)this;
    }

    public OpenDialog openDialog() {
        return this.openDialog;
    }

    public Task task() {
        return this.task;
    }

    public TaskSelection taskSelection() {
        return this.taskSelection;
    }

    public Download download() {
        return this.download;
    }

    public DownloadSelection downloadSelection() {
        return this.downloadSelection;
    }

    public Export export() {
        return this.export;
    }

    public ExportSelection exportSelection() {
        return this.exportSelection;
    }

    public OpenCatalog openCatalog() {
        return this.openCatalog;
    }

    public OpenCatalogSelection openCatalogSelection() {
        return this.openCatalogSelection;
    }

    public Toolbar openDialog(OpenDialog value) {
        this.openDialog = value;
        return (Toolbar)this;
    }

    public Toolbar task(Task value) {
        this.task = value;
        return (Toolbar)this;
    }

    public Toolbar taskSelection(TaskSelection value) {
        this.taskSelection = value;
        return (Toolbar)this;
    }

    public Toolbar download(Download value) {
        this.download = value;
        return (Toolbar)this;
    }

    public Toolbar downloadSelection(DownloadSelection value) {
        this.downloadSelection = value;
        return (Toolbar)this;
    }

    public Toolbar export(Export value) {
        this.export = value;
        return (Toolbar)this;
    }

    public Toolbar exportSelection(ExportSelection value) {
        this.exportSelection = value;
        return (Toolbar)this;
    }

    public Toolbar openCatalog(OpenCatalog value) {
        this.openCatalog = value;
        return (Toolbar)this;
    }

    public Toolbar openCatalogSelection(OpenCatalogSelection value) {
        this.openCatalogSelection = value;
        return (Toolbar)this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.openDialog != null) {
            components.add(this.openDialog.core$());
        }
        if (this.task != null) {
            components.add(this.task.core$());
        }
        if (this.taskSelection != null) {
            components.add(this.taskSelection.core$());
        }
        if (this.download != null) {
            components.add(this.download.core$());
        }
        if (this.downloadSelection != null) {
            components.add(this.downloadSelection.core$());
        }
        if (this.export != null) {
            components.add(this.export.core$());
        }
        if (this.exportSelection != null) {
            components.add(this.exportSelection.core$());
        }
        if (this.openCatalog != null) {
            components.add(this.openCatalog.core$());
        }
        if (this.openCatalogSelection != null) {
            components.add(this.openCatalogSelection.core$());
        }
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("canSearch", new ArrayList<Boolean>(Collections.singletonList(this.canSearch)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Toolbar$OpenDialog")) {
            this.openDialog = (OpenDialog)node.as(OpenDialog.class);
        }
        if (node.is("Toolbar$Task")) {
            this.task = (Task)node.as(Task.class);
        }
        if (node.is("Toolbar$TaskSelection")) {
            this.taskSelection = (TaskSelection)node.as(TaskSelection.class);
        }
        if (node.is("Toolbar$Download")) {
            this.download = (Download)node.as(Download.class);
        }
        if (node.is("Toolbar$DownloadSelection")) {
            this.downloadSelection = (DownloadSelection)node.as(DownloadSelection.class);
        }
        if (node.is("Toolbar$Export")) {
            this.export = (Export)node.as(Export.class);
        }
        if (node.is("Toolbar$ExportSelection")) {
            this.exportSelection = (ExportSelection)node.as(ExportSelection.class);
        }
        if (node.is("Toolbar$OpenCatalog")) {
            this.openCatalog = (OpenCatalog)node.as(OpenCatalog.class);
        }
        if (node.is("Toolbar$OpenCatalogSelection")) {
            this.openCatalogSelection = (OpenCatalogSelection)node.as(OpenCatalogSelection.class);
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Toolbar$OpenDialog")) {
            this.openDialog = null;
        }
        if (node.is("Toolbar$Task")) {
            this.task = null;
        }
        if (node.is("Toolbar$TaskSelection")) {
            this.taskSelection = null;
        }
        if (node.is("Toolbar$Download")) {
            this.download = null;
        }
        if (node.is("Toolbar$DownloadSelection")) {
            this.downloadSelection = null;
        }
        if (node.is("Toolbar$Export")) {
            this.export = null;
        }
        if (node.is("Toolbar$ExportSelection")) {
            this.exportSelection = null;
        }
        if (node.is("Toolbar$OpenCatalog")) {
            this.openCatalog = null;
        }
        if (node.is("Toolbar$OpenCatalogSelection")) {
            this.openCatalogSelection = null;
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("canSearch")) {
            this.canSearch = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("canSearch")) {
            this.canSearch = (Boolean)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class OpenCatalogSelection
    extends Operation
    implements Component,
    Terminal {
        protected Catalog catalog;
        protected List<CatalogView> views = new ArrayList<CatalogView>();
        protected boolean filtered;
        protected Selection selection;
        protected Position position;
        protected int width;
        protected int height;

        public OpenCatalogSelection(Node node) {
            super(node);
        }

        public Catalog catalog() {
            return this.catalog;
        }

        public List<CatalogView> views() {
            return this.views;
        }

        public CatalogView views(int index) {
            return this.views.get(index);
        }

        public List<CatalogView> views(Predicate<CatalogView> predicate) {
            return this.views().stream().filter(predicate).collect(Collectors.toList());
        }

        public boolean filtered() {
            return this.filtered;
        }

        public Selection selection() {
            return this.selection;
        }

        public Position position() {
            return this.position;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public OpenCatalogSelection catalog(Catalog value) {
            this.catalog = value;
            return this;
        }

        public OpenCatalogSelection filtered(boolean value) {
            this.filtered = value;
            return this;
        }

        public OpenCatalogSelection selection(Selection value) {
            this.selection = value;
            return this;
        }

        public OpenCatalogSelection position(Position value) {
            this.position = value;
            return this;
        }

        public OpenCatalogSelection width(int value) {
            this.width = value;
            return this;
        }

        public OpenCatalogSelection height(int value) {
            this.height = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("catalog", this.catalog != null ? new ArrayList<Catalog>(Collections.singletonList(this.catalog)) : Collections.emptyList());
            map.put("views", this.views);
            map.put("filtered", new ArrayList<Boolean>(Collections.singletonList(this.filtered)));
            map.put("selection", new ArrayList<Selection>(Collections.singletonList(this.selection)));
            map.put("position", new ArrayList<Position>(Collections.singletonList(this.position)));
            map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
            map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("catalog")) {
                this.catalog = (Catalog)((Object)NodeLoader.load(values, Catalog.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("views")) {
                this.views = NodeLoader.load(values, CatalogView.class, (Layer)this);
            } else if (name.equalsIgnoreCase("filtered")) {
                this.filtered = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("selection")) {
                this.selection = (Selection)((Object)WordLoader.load(values, Selection.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)WordLoader.load(values, Position.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("catalog")) {
                this.catalog = values.get(0) != null ? (Catalog)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Catalog.class) : null;
            } else if (name.equalsIgnoreCase("views")) {
                this.views = values.stream().map(s -> (CatalogView)this.graph().core$().load(((Layer)s).core$().id()).as(CatalogView.class)).collect(Collectors.toList());
            } else if (name.equalsIgnoreCase("filtered")) {
                this.filtered = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("selection")) {
                this.selection = (Selection)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum Position {
            Standalone,
            RelativeToOperation;

        }

        public static enum Selection {
            None,
            Single,
            Multiple;

        }
    }

    public static class OpenCatalog
    extends Operation
    implements Component,
    Terminal {
        protected Catalog catalog;
        protected List<CatalogView> views = new ArrayList<CatalogView>();
        protected boolean filtered;
        protected int width;
        protected int height;
        protected Position position;

        public OpenCatalog(Node node) {
            super(node);
        }

        public Catalog catalog() {
            return this.catalog;
        }

        public List<CatalogView> views() {
            return this.views;
        }

        public CatalogView views(int index) {
            return this.views.get(index);
        }

        public List<CatalogView> views(Predicate<CatalogView> predicate) {
            return this.views().stream().filter(predicate).collect(Collectors.toList());
        }

        public boolean filtered() {
            return this.filtered;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public Position position() {
            return this.position;
        }

        public OpenCatalog catalog(Catalog value) {
            this.catalog = value;
            return this;
        }

        public OpenCatalog filtered(boolean value) {
            this.filtered = value;
            return this;
        }

        public OpenCatalog width(int value) {
            this.width = value;
            return this;
        }

        public OpenCatalog height(int value) {
            this.height = value;
            return this;
        }

        public OpenCatalog position(Position value) {
            this.position = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("catalog", this.catalog != null ? new ArrayList<Catalog>(Collections.singletonList(this.catalog)) : Collections.emptyList());
            map.put("views", this.views);
            map.put("filtered", new ArrayList<Boolean>(Collections.singletonList(this.filtered)));
            map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
            map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
            map.put("position", new ArrayList<Position>(Collections.singletonList(this.position)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("catalog")) {
                this.catalog = (Catalog)((Object)NodeLoader.load(values, Catalog.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("views")) {
                this.views = NodeLoader.load(values, CatalogView.class, (Layer)this);
            } else if (name.equalsIgnoreCase("filtered")) {
                this.filtered = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)WordLoader.load(values, Position.class, (Layer)this).get(0));
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("catalog")) {
                this.catalog = values.get(0) != null ? (Catalog)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Catalog.class) : null;
            } else if (name.equalsIgnoreCase("views")) {
                this.views = values.stream().map(s -> (CatalogView)this.graph().core$().load(((Layer)s).core$().id()).as(CatalogView.class)).collect(Collectors.toList());
            } else if (name.equalsIgnoreCase("filtered")) {
                this.filtered = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)values.get(0));
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum Position {
            Standalone,
            RelativeToOperation;

        }
    }

    public static class ExportSelection
    extends Operation
    implements Component,
    Terminal {
        public ExportSelection(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Export
    extends Operation
    implements Component,
    Terminal {
        public Export(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class DownloadSelection
    extends Operation
    implements Component,
    Terminal {
        protected List<String> options = new ArrayList<String>();

        public DownloadSelection(Node node) {
            super(node);
        }

        public List<String> options() {
            return this.options;
        }

        public String options(int index) {
            return this.options.get(index);
        }

        public List<String> options(Predicate<String> predicate) {
            return this.options().stream().filter(predicate).collect(Collectors.toList());
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("options", this.options);
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("options")) {
                this.options = StringLoader.load(values, (Layer)this);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("options")) {
                this.options = new ArrayList(values);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Download
    extends Operation
    implements Component,
    Terminal {
        protected List<String> options = new ArrayList<String>();

        public Download(Node node) {
            super(node);
        }

        public List<String> options() {
            return this.options;
        }

        public String options(int index) {
            return this.options.get(index);
        }

        public List<String> options(Predicate<String> predicate) {
            return this.options().stream().filter(predicate).collect(Collectors.toList());
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("options", this.options);
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("options")) {
                this.options = StringLoader.load(values, (Layer)this);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("options")) {
                this.options = new ArrayList(values);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class TaskSelection
    extends Operation
    implements Component,
    Terminal {
        public TaskSelection(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Task
    extends Operation
    implements Component,
    Terminal {
        public Task(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class OpenDialog
    extends Operation
    implements Component,
    Terminal {
        protected Dialog dialog;

        public OpenDialog(Node node) {
            super(node);
        }

        public Dialog dialog() {
            return this.dialog;
        }

        public OpenDialog dialog(Dialog value) {
            this.dialog = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("dialog", this.dialog != null ? new ArrayList<Dialog>(Collections.singletonList(this.dialog)) : Collections.emptyList());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("dialog")) {
                this.dialog = (Dialog)((Object)NodeLoader.load(values, Dialog.class, (Layer)this).get(0));
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("dialog")) {
                this.dialog = values.get(0) != null ? (Dialog)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Dialog.class) : null;
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public OpenDialog openDialog(String title, Dialog dialog) {
            OpenDialog newElement = (OpenDialog)AbstractToolbar.this.core$().graph().concept(OpenDialog.class).createNode(this.name, AbstractToolbar.this.core$()).as(OpenDialog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "dialog", Collections.singletonList(dialog));
            return newElement;
        }

        public Task task(String title) {
            Task newElement = (Task)AbstractToolbar.this.core$().graph().concept(Task.class).createNode(this.name, AbstractToolbar.this.core$()).as(Task.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public TaskSelection taskSelection(String title) {
            TaskSelection newElement = (TaskSelection)AbstractToolbar.this.core$().graph().concept(TaskSelection.class).createNode(this.name, AbstractToolbar.this.core$()).as(TaskSelection.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public Download download(String title) {
            Download newElement = (Download)AbstractToolbar.this.core$().graph().concept(Download.class).createNode(this.name, AbstractToolbar.this.core$()).as(Download.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public DownloadSelection downloadSelection(String title) {
            DownloadSelection newElement = (DownloadSelection)AbstractToolbar.this.core$().graph().concept(DownloadSelection.class).createNode(this.name, AbstractToolbar.this.core$()).as(DownloadSelection.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public Export export(String title) {
            Export newElement = (Export)AbstractToolbar.this.core$().graph().concept(Export.class).createNode(this.name, AbstractToolbar.this.core$()).as(Export.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public ExportSelection exportSelection(String title) {
            ExportSelection newElement = (ExportSelection)AbstractToolbar.this.core$().graph().concept(ExportSelection.class).createNode(this.name, AbstractToolbar.this.core$()).as(ExportSelection.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public OpenCatalog openCatalog(String title, Catalog catalog, List<CatalogView> views) {
            OpenCatalog newElement = (OpenCatalog)AbstractToolbar.this.core$().graph().concept(OpenCatalog.class).createNode(this.name, AbstractToolbar.this.core$()).as(OpenCatalog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "catalog", Collections.singletonList(catalog));
            newElement.core$().set((Layer)newElement, "views", views);
            return newElement;
        }

        public OpenCatalogSelection openCatalogSelection(String title, Catalog catalog, List<CatalogView> views) {
            OpenCatalogSelection newElement = (OpenCatalogSelection)AbstractToolbar.this.core$().graph().concept(OpenCatalogSelection.class).createNode(this.name, AbstractToolbar.this.core$()).as(OpenCatalogSelection.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "catalog", Collections.singletonList(catalog));
            newElement.core$().set((Layer)newElement, "views", views);
            return newElement;
        }
    }
}

