/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Activity;
import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.Data;
import io.intino.konos.model.graph.DataLake;
import io.intino.konos.model.graph.Desktop;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.ElementOption;
import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.Layout;
import io.intino.konos.model.graph.Mold;
import io.intino.konos.model.graph.Panel;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.Task;
import io.intino.konos.model.graph.TemporalCatalog;
import io.intino.konos.model.graph.bool.BoolData;
import io.intino.konos.model.graph.boottrigger.BootTriggerTask;
import io.intino.konos.model.graph.crontrigger.CronTriggerTask;
import io.intino.konos.model.graph.date.DateData;
import io.intino.konos.model.graph.datetime.DateTimeData;
import io.intino.konos.model.graph.directorysentinel.DirectorySentinelTask;
import io.intino.konos.model.graph.event.EventSchema;
import io.intino.konos.model.graph.file.FileData;
import io.intino.konos.model.graph.functions.ProcessChecker;
import io.intino.konos.model.graph.integer.IntegerData;
import io.intino.konos.model.graph.jms.JMSService;
import io.intino.konos.model.graph.jmsqueuesentinel.JMSQueueSentinelTask;
import io.intino.konos.model.graph.jmstopicsentinel.JMSTopicSentinelTask;
import io.intino.konos.model.graph.jmx.JMXService;
import io.intino.konos.model.graph.list.ListData;
import io.intino.konos.model.graph.longinteger.LongIntegerData;
import io.intino.konos.model.graph.multiple.dialog.tab.MultipleInput;
import io.intino.konos.model.graph.object.ObjectData;
import io.intino.konos.model.graph.periodictrigger.PeriodicTriggerTask;
import io.intino.konos.model.graph.processsentinel.ProcessSentinelTask;
import io.intino.konos.model.graph.real.RealData;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.restricted.activity.RestrictedAbstractPage;
import io.intino.konos.model.graph.rules.ExceptionCodes;
import io.intino.konos.model.graph.scheduled.ScheduledTask;
import io.intino.konos.model.graph.shutdowntrigger.ShutdownTriggerTask;
import io.intino.konos.model.graph.slackbot.SlackBotService;
import io.intino.konos.model.graph.text.TextData;
import io.intino.konos.model.graph.timeouttrigger.TimeoutTriggerTask;
import io.intino.konos.model.graph.type.TypeData;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.GraphWrapper;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.utils.I18n;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private List<Service> serviceList;
    private List<RESTService> rESTServiceList;
    private List<JMXService> jMXServiceList;
    private List<JMSService> jMSServiceList;
    private List<SlackBotService> slackBotServiceList;
    private List<Activity> activityList;
    private List<RestrictedAbstractPage> restrictedAbstractPageList;
    private List<Component> componentList;
    private List<Catalog> catalogList;
    private List<TemporalCatalog> temporalCatalogList;
    private List<Display> displayList;
    private List<Panel> panelList;
    private List<Desktop> desktopList;
    private List<Layout> layoutList;
    private List<ElementOption> elementOptionList;
    private List<Mold> moldList;
    private List<Task> taskList;
    private List<ScheduledTask> scheduledTaskList;
    private List<BootTriggerTask> bootTriggerTaskList;
    private List<TimeoutTriggerTask> timeoutTriggerTaskList;
    private List<PeriodicTriggerTask> periodicTriggerTaskList;
    private List<CronTriggerTask> cronTriggerTaskList;
    private List<ShutdownTriggerTask> shutdownTriggerTaskList;
    private List<DirectorySentinelTask> directorySentinelTaskList;
    private List<ProcessSentinelTask> processSentinelTaskList;
    private List<JMSQueueSentinelTask> jMSQueueSentinelTaskList;
    private List<JMSTopicSentinelTask> jMSTopicSentinelTaskList;
    private List<Dialog> dialogList;
    private List<MultipleInput> multipleInputList;
    private DataLake dataLake;
    private List<Data> dataList;
    private List<TypeData> typeDataList;
    private List<RealData> realDataList;
    private List<IntegerData> integerDataList;
    private List<LongIntegerData> longIntegerDataList;
    private List<BoolData> boolDataList;
    private List<TextData> textDataList;
    private List<DateData> dateDataList;
    private List<DateTimeData> dateTimeDataList;
    private List<FileData> fileDataList;
    private List<ObjectData> objectDataList;
    private List<ListData> listDataList;
    private List<Schema> schemaList;
    private List<Exception> exceptionList;
    private List<EventSchema> eventSchemaList;

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("Konos");
    }

    public AbstractGraph(Graph graph, AbstractGraph wrapper) {
        this.graph = graph;
        this.graph.i18n().register("Konos");
        this.serviceList = new ArrayList<Service>(wrapper.serviceList);
        this.rESTServiceList = new ArrayList<RESTService>(wrapper.rESTServiceList);
        this.jMXServiceList = new ArrayList<JMXService>(wrapper.jMXServiceList);
        this.jMSServiceList = new ArrayList<JMSService>(wrapper.jMSServiceList);
        this.slackBotServiceList = new ArrayList<SlackBotService>(wrapper.slackBotServiceList);
        this.activityList = new ArrayList<Activity>(wrapper.activityList);
        this.restrictedAbstractPageList = new ArrayList<RestrictedAbstractPage>(wrapper.restrictedAbstractPageList);
        this.componentList = new ArrayList<Component>(wrapper.componentList);
        this.catalogList = new ArrayList<Catalog>(wrapper.catalogList);
        this.temporalCatalogList = new ArrayList<TemporalCatalog>(wrapper.temporalCatalogList);
        this.displayList = new ArrayList<Display>(wrapper.displayList);
        this.panelList = new ArrayList<Panel>(wrapper.panelList);
        this.desktopList = new ArrayList<Desktop>(wrapper.desktopList);
        this.layoutList = new ArrayList<Layout>(wrapper.layoutList);
        this.elementOptionList = new ArrayList<ElementOption>(wrapper.elementOptionList);
        this.moldList = new ArrayList<Mold>(wrapper.moldList);
        this.taskList = new ArrayList<Task>(wrapper.taskList);
        this.scheduledTaskList = new ArrayList<ScheduledTask>(wrapper.scheduledTaskList);
        this.bootTriggerTaskList = new ArrayList<BootTriggerTask>(wrapper.bootTriggerTaskList);
        this.timeoutTriggerTaskList = new ArrayList<TimeoutTriggerTask>(wrapper.timeoutTriggerTaskList);
        this.periodicTriggerTaskList = new ArrayList<PeriodicTriggerTask>(wrapper.periodicTriggerTaskList);
        this.cronTriggerTaskList = new ArrayList<CronTriggerTask>(wrapper.cronTriggerTaskList);
        this.shutdownTriggerTaskList = new ArrayList<ShutdownTriggerTask>(wrapper.shutdownTriggerTaskList);
        this.directorySentinelTaskList = new ArrayList<DirectorySentinelTask>(wrapper.directorySentinelTaskList);
        this.processSentinelTaskList = new ArrayList<ProcessSentinelTask>(wrapper.processSentinelTaskList);
        this.jMSQueueSentinelTaskList = new ArrayList<JMSQueueSentinelTask>(wrapper.jMSQueueSentinelTaskList);
        this.jMSTopicSentinelTaskList = new ArrayList<JMSTopicSentinelTask>(wrapper.jMSTopicSentinelTaskList);
        this.dialogList = new ArrayList<Dialog>(wrapper.dialogList);
        this.multipleInputList = new ArrayList<MultipleInput>(wrapper.multipleInputList);
        this.dataLake = wrapper.dataLake;
        this.dataList = new ArrayList<Data>(wrapper.dataList);
        this.typeDataList = new ArrayList<TypeData>(wrapper.typeDataList);
        this.realDataList = new ArrayList<RealData>(wrapper.realDataList);
        this.integerDataList = new ArrayList<IntegerData>(wrapper.integerDataList);
        this.longIntegerDataList = new ArrayList<LongIntegerData>(wrapper.longIntegerDataList);
        this.boolDataList = new ArrayList<BoolData>(wrapper.boolDataList);
        this.textDataList = new ArrayList<TextData>(wrapper.textDataList);
        this.dateDataList = new ArrayList<DateData>(wrapper.dateDataList);
        this.dateTimeDataList = new ArrayList<DateTimeData>(wrapper.dateTimeDataList);
        this.fileDataList = new ArrayList<FileData>(wrapper.fileDataList);
        this.objectDataList = new ArrayList<ObjectData>(wrapper.objectDataList);
        this.listDataList = new ArrayList<ListData>(wrapper.listDataList);
        this.schemaList = new ArrayList<Schema>(wrapper.schemaList);
        this.exceptionList = new ArrayList<Exception>(wrapper.exceptionList);
        this.eventSchemaList = new ArrayList<EventSchema>(wrapper.eventSchemaList);
    }

    public void update() {
        this.serviceList = this.graph.rootList(Service.class);
        this.rESTServiceList = this.graph.rootList(RESTService.class);
        this.jMXServiceList = this.graph.rootList(JMXService.class);
        this.jMSServiceList = this.graph.rootList(JMSService.class);
        this.slackBotServiceList = this.graph.rootList(SlackBotService.class);
        this.activityList = this.graph.rootList(Activity.class);
        this.restrictedAbstractPageList = this.graph.rootList(RestrictedAbstractPage.class);
        this.componentList = this.graph.rootList(Component.class);
        this.catalogList = this.graph.rootList(Catalog.class);
        this.temporalCatalogList = this.graph.rootList(TemporalCatalog.class);
        this.displayList = this.graph.rootList(Display.class);
        this.panelList = this.graph.rootList(Panel.class);
        this.desktopList = this.graph.rootList(Desktop.class);
        this.layoutList = this.graph.rootList(Layout.class);
        this.elementOptionList = this.graph.rootList(ElementOption.class);
        this.moldList = this.graph.rootList(Mold.class);
        this.taskList = this.graph.rootList(Task.class);
        this.scheduledTaskList = this.graph.rootList(ScheduledTask.class);
        this.bootTriggerTaskList = this.graph.rootList(BootTriggerTask.class);
        this.timeoutTriggerTaskList = this.graph.rootList(TimeoutTriggerTask.class);
        this.periodicTriggerTaskList = this.graph.rootList(PeriodicTriggerTask.class);
        this.cronTriggerTaskList = this.graph.rootList(CronTriggerTask.class);
        this.shutdownTriggerTaskList = this.graph.rootList(ShutdownTriggerTask.class);
        this.directorySentinelTaskList = this.graph.rootList(DirectorySentinelTask.class);
        this.processSentinelTaskList = this.graph.rootList(ProcessSentinelTask.class);
        this.jMSQueueSentinelTaskList = this.graph.rootList(JMSQueueSentinelTask.class);
        this.jMSTopicSentinelTaskList = this.graph.rootList(JMSTopicSentinelTask.class);
        this.dialogList = this.graph.rootList(Dialog.class);
        this.multipleInputList = this.graph.rootList(MultipleInput.class);
        this.dataLake = this.graph.rootList(DataLake.class).stream().findFirst().orElse(null);
        this.dataList = this.graph.rootList(Data.class);
        this.typeDataList = this.graph.rootList(TypeData.class);
        this.realDataList = this.graph.rootList(RealData.class);
        this.integerDataList = this.graph.rootList(IntegerData.class);
        this.longIntegerDataList = this.graph.rootList(LongIntegerData.class);
        this.boolDataList = this.graph.rootList(BoolData.class);
        this.textDataList = this.graph.rootList(TextData.class);
        this.dateDataList = this.graph.rootList(DateData.class);
        this.dateTimeDataList = this.graph.rootList(DateTimeData.class);
        this.fileDataList = this.graph.rootList(FileData.class);
        this.objectDataList = this.graph.rootList(ObjectData.class);
        this.listDataList = this.graph.rootList(ListData.class);
        this.schemaList = this.graph.rootList(Schema.class);
        this.exceptionList = this.graph.rootList(Exception.class);
        this.eventSchemaList = this.graph.rootList(EventSchema.class);
    }

    protected void addNode$(Node node) {
        if (node.is("Service")) {
            this.serviceList.add((Service)node.as(Service.class));
        }
        if (node.is("REST#Service")) {
            this.rESTServiceList.add((RESTService)node.as(RESTService.class));
        }
        if (node.is("JMX#Service")) {
            this.jMXServiceList.add((JMXService)node.as(JMXService.class));
        }
        if (node.is("JMS#Service")) {
            this.jMSServiceList.add((JMSService)node.as(JMSService.class));
        }
        if (node.is("SlackBot#Service")) {
            this.slackBotServiceList.add((SlackBotService)node.as(SlackBotService.class));
        }
        if (node.is("Activity")) {
            this.activityList.add((Activity)node.as(Activity.class));
        }
        if (node.is("Restricted#Activity$AbstractPage")) {
            this.restrictedAbstractPageList.add((RestrictedAbstractPage)node.as(RestrictedAbstractPage.class));
        }
        if (node.is("Component")) {
            this.componentList.add((Component)node.as(Component.class));
        }
        if (node.is("Catalog")) {
            this.catalogList.add((Catalog)node.as(Catalog.class));
        }
        if (node.is("TemporalCatalog")) {
            this.temporalCatalogList.add((TemporalCatalog)node.as(TemporalCatalog.class));
        }
        if (node.is("Display")) {
            this.displayList.add((Display)node.as(Display.class));
        }
        if (node.is("Panel")) {
            this.panelList.add((Panel)node.as(Panel.class));
        }
        if (node.is("Desktop")) {
            this.desktopList.add((Desktop)node.as(Desktop.class));
        }
        if (node.is("Layout")) {
            this.layoutList.add((Layout)node.as(Layout.class));
        }
        if (node.is("ElementOption")) {
            this.elementOptionList.add((ElementOption)node.as(ElementOption.class));
        }
        if (node.is("Mold")) {
            this.moldList.add((Mold)node.as(Mold.class));
        }
        if (node.is("Task")) {
            this.taskList.add((Task)node.as(Task.class));
        }
        if (node.is("Scheduled#Task")) {
            this.scheduledTaskList.add((ScheduledTask)node.as(ScheduledTask.class));
        }
        if (node.is("BootTrigger#Task")) {
            this.bootTriggerTaskList.add((BootTriggerTask)node.as(BootTriggerTask.class));
        }
        if (node.is("TimeoutTrigger#Task")) {
            this.timeoutTriggerTaskList.add((TimeoutTriggerTask)node.as(TimeoutTriggerTask.class));
        }
        if (node.is("PeriodicTrigger#Task")) {
            this.periodicTriggerTaskList.add((PeriodicTriggerTask)node.as(PeriodicTriggerTask.class));
        }
        if (node.is("CronTrigger#Task")) {
            this.cronTriggerTaskList.add((CronTriggerTask)node.as(CronTriggerTask.class));
        }
        if (node.is("ShutdownTrigger#Task")) {
            this.shutdownTriggerTaskList.add((ShutdownTriggerTask)node.as(ShutdownTriggerTask.class));
        }
        if (node.is("DirectorySentinel#Task")) {
            this.directorySentinelTaskList.add((DirectorySentinelTask)node.as(DirectorySentinelTask.class));
        }
        if (node.is("ProcessSentinel#Task")) {
            this.processSentinelTaskList.add((ProcessSentinelTask)node.as(ProcessSentinelTask.class));
        }
        if (node.is("JMSQueueSentinel#Task")) {
            this.jMSQueueSentinelTaskList.add((JMSQueueSentinelTask)node.as(JMSQueueSentinelTask.class));
        }
        if (node.is("JMSTopicSentinel#Task")) {
            this.jMSTopicSentinelTaskList.add((JMSTopicSentinelTask)node.as(JMSTopicSentinelTask.class));
        }
        if (node.is("Dialog")) {
            this.dialogList.add((Dialog)node.as(Dialog.class));
        }
        if (node.is("Multiple#Dialog$Tab$Input")) {
            this.multipleInputList.add((MultipleInput)node.as(MultipleInput.class));
        }
        if (node.is("DataLake")) {
            this.dataLake = (DataLake)node.as(DataLake.class);
        }
        if (node.is("Data")) {
            this.dataList.add((Data)node.as(Data.class));
        }
        if (node.is("Type#Data")) {
            this.typeDataList.add((TypeData)node.as(TypeData.class));
        }
        if (node.is("Real#Data")) {
            this.realDataList.add((RealData)node.as(RealData.class));
        }
        if (node.is("Integer#Data")) {
            this.integerDataList.add((IntegerData)node.as(IntegerData.class));
        }
        if (node.is("LongInteger#Data")) {
            this.longIntegerDataList.add((LongIntegerData)node.as(LongIntegerData.class));
        }
        if (node.is("Bool#Data")) {
            this.boolDataList.add((BoolData)node.as(BoolData.class));
        }
        if (node.is("Text#Data")) {
            this.textDataList.add((TextData)node.as(TextData.class));
        }
        if (node.is("Date#Data")) {
            this.dateDataList.add((DateData)node.as(DateData.class));
        }
        if (node.is("DateTime#Data")) {
            this.dateTimeDataList.add((DateTimeData)node.as(DateTimeData.class));
        }
        if (node.is("File#Data")) {
            this.fileDataList.add((FileData)node.as(FileData.class));
        }
        if (node.is("Object#Data")) {
            this.objectDataList.add((ObjectData)node.as(ObjectData.class));
        }
        if (node.is("List#Data")) {
            this.listDataList.add((ListData)node.as(ListData.class));
        }
        if (node.is("Schema")) {
            this.schemaList.add((Schema)node.as(Schema.class));
        }
        if (node.is("Exception")) {
            this.exceptionList.add((Exception)node.as(Exception.class));
        }
        if (node.is("Event#Schema")) {
            this.eventSchemaList.add((EventSchema)node.as(EventSchema.class));
        }
    }

    protected void removeNode$(Node node) {
        if (node.is("Service")) {
            this.serviceList.remove(node.as(Service.class));
        }
        if (node.is("REST#Service")) {
            this.rESTServiceList.remove(node.as(RESTService.class));
        }
        if (node.is("JMX#Service")) {
            this.jMXServiceList.remove(node.as(JMXService.class));
        }
        if (node.is("JMS#Service")) {
            this.jMSServiceList.remove(node.as(JMSService.class));
        }
        if (node.is("SlackBot#Service")) {
            this.slackBotServiceList.remove(node.as(SlackBotService.class));
        }
        if (node.is("Activity")) {
            this.activityList.remove(node.as(Activity.class));
        }
        if (node.is("Restricted#Activity$AbstractPage")) {
            this.restrictedAbstractPageList.remove(node.as(RestrictedAbstractPage.class));
        }
        if (node.is("Component")) {
            this.componentList.remove(node.as(Component.class));
        }
        if (node.is("Catalog")) {
            this.catalogList.remove(node.as(Catalog.class));
        }
        if (node.is("TemporalCatalog")) {
            this.temporalCatalogList.remove(node.as(TemporalCatalog.class));
        }
        if (node.is("Display")) {
            this.displayList.remove(node.as(Display.class));
        }
        if (node.is("Panel")) {
            this.panelList.remove(node.as(Panel.class));
        }
        if (node.is("Desktop")) {
            this.desktopList.remove(node.as(Desktop.class));
        }
        if (node.is("Layout")) {
            this.layoutList.remove(node.as(Layout.class));
        }
        if (node.is("ElementOption")) {
            this.elementOptionList.remove(node.as(ElementOption.class));
        }
        if (node.is("Mold")) {
            this.moldList.remove(node.as(Mold.class));
        }
        if (node.is("Task")) {
            this.taskList.remove(node.as(Task.class));
        }
        if (node.is("Scheduled#Task")) {
            this.scheduledTaskList.remove(node.as(ScheduledTask.class));
        }
        if (node.is("BootTrigger#Task")) {
            this.bootTriggerTaskList.remove(node.as(BootTriggerTask.class));
        }
        if (node.is("TimeoutTrigger#Task")) {
            this.timeoutTriggerTaskList.remove(node.as(TimeoutTriggerTask.class));
        }
        if (node.is("PeriodicTrigger#Task")) {
            this.periodicTriggerTaskList.remove(node.as(PeriodicTriggerTask.class));
        }
        if (node.is("CronTrigger#Task")) {
            this.cronTriggerTaskList.remove(node.as(CronTriggerTask.class));
        }
        if (node.is("ShutdownTrigger#Task")) {
            this.shutdownTriggerTaskList.remove(node.as(ShutdownTriggerTask.class));
        }
        if (node.is("DirectorySentinel#Task")) {
            this.directorySentinelTaskList.remove(node.as(DirectorySentinelTask.class));
        }
        if (node.is("ProcessSentinel#Task")) {
            this.processSentinelTaskList.remove(node.as(ProcessSentinelTask.class));
        }
        if (node.is("JMSQueueSentinel#Task")) {
            this.jMSQueueSentinelTaskList.remove(node.as(JMSQueueSentinelTask.class));
        }
        if (node.is("JMSTopicSentinel#Task")) {
            this.jMSTopicSentinelTaskList.remove(node.as(JMSTopicSentinelTask.class));
        }
        if (node.is("Dialog")) {
            this.dialogList.remove(node.as(Dialog.class));
        }
        if (node.is("Multiple#Dialog$Tab$Input")) {
            this.multipleInputList.remove(node.as(MultipleInput.class));
        }
        if (node.is("DataLake")) {
            this.dataLake = null;
        }
        if (node.is("Data")) {
            this.dataList.remove(node.as(Data.class));
        }
        if (node.is("Type#Data")) {
            this.typeDataList.remove(node.as(TypeData.class));
        }
        if (node.is("Real#Data")) {
            this.realDataList.remove(node.as(RealData.class));
        }
        if (node.is("Integer#Data")) {
            this.integerDataList.remove(node.as(IntegerData.class));
        }
        if (node.is("LongInteger#Data")) {
            this.longIntegerDataList.remove(node.as(LongIntegerData.class));
        }
        if (node.is("Bool#Data")) {
            this.boolDataList.remove(node.as(BoolData.class));
        }
        if (node.is("Text#Data")) {
            this.textDataList.remove(node.as(TextData.class));
        }
        if (node.is("Date#Data")) {
            this.dateDataList.remove(node.as(DateData.class));
        }
        if (node.is("DateTime#Data")) {
            this.dateTimeDataList.remove(node.as(DateTimeData.class));
        }
        if (node.is("File#Data")) {
            this.fileDataList.remove(node.as(FileData.class));
        }
        if (node.is("Object#Data")) {
            this.objectDataList.remove(node.as(ObjectData.class));
        }
        if (node.is("List#Data")) {
            this.listDataList.remove(node.as(ListData.class));
        }
        if (node.is("Schema")) {
            this.schemaList.remove(node.as(Schema.class));
        }
        if (node.is("Exception")) {
            this.exceptionList.remove(node.as(Exception.class));
        }
        if (node.is("Event#Schema")) {
            this.eventSchemaList.remove(node.as(EventSchema.class));
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public List<Service> serviceList() {
        return this.serviceList;
    }

    public List<RESTService> rESTServiceList() {
        return this.rESTServiceList;
    }

    public List<JMXService> jMXServiceList() {
        return this.jMXServiceList;
    }

    public List<JMSService> jMSServiceList() {
        return this.jMSServiceList;
    }

    public List<SlackBotService> slackBotServiceList() {
        return this.slackBotServiceList;
    }

    public List<Activity> activityList() {
        return this.activityList;
    }

    public List<RestrictedAbstractPage> restrictedAbstractPageList() {
        return this.restrictedAbstractPageList;
    }

    public List<Component> componentList() {
        return this.componentList;
    }

    public List<Catalog> catalogList() {
        return this.catalogList;
    }

    public List<TemporalCatalog> temporalCatalogList() {
        return this.temporalCatalogList;
    }

    public List<Display> displayList() {
        return this.displayList;
    }

    public List<Panel> panelList() {
        return this.panelList;
    }

    public List<Desktop> desktopList() {
        return this.desktopList;
    }

    public List<Layout> layoutList() {
        return this.layoutList;
    }

    public List<ElementOption> elementOptionList() {
        return this.elementOptionList;
    }

    public List<Mold> moldList() {
        return this.moldList;
    }

    public List<Task> taskList() {
        return this.taskList;
    }

    public List<ScheduledTask> scheduledTaskList() {
        return this.scheduledTaskList;
    }

    public List<BootTriggerTask> bootTriggerTaskList() {
        return this.bootTriggerTaskList;
    }

    public List<TimeoutTriggerTask> timeoutTriggerTaskList() {
        return this.timeoutTriggerTaskList;
    }

    public List<PeriodicTriggerTask> periodicTriggerTaskList() {
        return this.periodicTriggerTaskList;
    }

    public List<CronTriggerTask> cronTriggerTaskList() {
        return this.cronTriggerTaskList;
    }

    public List<ShutdownTriggerTask> shutdownTriggerTaskList() {
        return this.shutdownTriggerTaskList;
    }

    public List<DirectorySentinelTask> directorySentinelTaskList() {
        return this.directorySentinelTaskList;
    }

    public List<ProcessSentinelTask> processSentinelTaskList() {
        return this.processSentinelTaskList;
    }

    public List<JMSQueueSentinelTask> jMSQueueSentinelTaskList() {
        return this.jMSQueueSentinelTaskList;
    }

    public List<JMSTopicSentinelTask> jMSTopicSentinelTaskList() {
        return this.jMSTopicSentinelTaskList;
    }

    public List<Dialog> dialogList() {
        return this.dialogList;
    }

    public List<MultipleInput> multipleInputList() {
        return this.multipleInputList;
    }

    public DataLake dataLake() {
        return this.dataLake;
    }

    public List<Data> dataList() {
        return this.dataList;
    }

    public List<TypeData> typeDataList() {
        return this.typeDataList;
    }

    public List<RealData> realDataList() {
        return this.realDataList;
    }

    public List<IntegerData> integerDataList() {
        return this.integerDataList;
    }

    public List<LongIntegerData> longIntegerDataList() {
        return this.longIntegerDataList;
    }

    public List<BoolData> boolDataList() {
        return this.boolDataList;
    }

    public List<TextData> textDataList() {
        return this.textDataList;
    }

    public List<DateData> dateDataList() {
        return this.dateDataList;
    }

    public List<DateTimeData> dateTimeDataList() {
        return this.dateTimeDataList;
    }

    public List<FileData> fileDataList() {
        return this.fileDataList;
    }

    public List<ObjectData> objectDataList() {
        return this.objectDataList;
    }

    public List<ListData> listDataList() {
        return this.listDataList;
    }

    public List<Schema> schemaList() {
        return this.schemaList;
    }

    public List<Exception> exceptionList() {
        return this.exceptionList;
    }

    public List<EventSchema> eventSchemaList() {
        return this.eventSchemaList;
    }

    public Stream<Service> serviceList(Predicate<Service> filter) {
        return this.serviceList.stream().filter(filter);
    }

    public Service service(int index) {
        return this.serviceList.get(index);
    }

    public Stream<RESTService> rESTServiceList(Predicate<RESTService> filter) {
        return this.rESTServiceList.stream().filter(filter);
    }

    public RESTService rESTService(int index) {
        return this.rESTServiceList.get(index);
    }

    public Stream<JMXService> jMXServiceList(Predicate<JMXService> filter) {
        return this.jMXServiceList.stream().filter(filter);
    }

    public JMXService jMXService(int index) {
        return this.jMXServiceList.get(index);
    }

    public Stream<JMSService> jMSServiceList(Predicate<JMSService> filter) {
        return this.jMSServiceList.stream().filter(filter);
    }

    public JMSService jMSService(int index) {
        return this.jMSServiceList.get(index);
    }

    public Stream<SlackBotService> slackBotServiceList(Predicate<SlackBotService> filter) {
        return this.slackBotServiceList.stream().filter(filter);
    }

    public SlackBotService slackBotService(int index) {
        return this.slackBotServiceList.get(index);
    }

    public Stream<Activity> activityList(Predicate<Activity> filter) {
        return this.activityList.stream().filter(filter);
    }

    public Activity activity(int index) {
        return this.activityList.get(index);
    }

    public Stream<RestrictedAbstractPage> restrictedAbstractPageList(Predicate<RestrictedAbstractPage> filter) {
        return this.restrictedAbstractPageList.stream().filter(filter);
    }

    public RestrictedAbstractPage restrictedAbstractPage(int index) {
        return this.restrictedAbstractPageList.get(index);
    }

    public Stream<Component> componentList(Predicate<Component> filter) {
        return this.componentList.stream().filter(filter);
    }

    public Component component(int index) {
        return this.componentList.get(index);
    }

    public Stream<Catalog> catalogList(Predicate<Catalog> filter) {
        return this.catalogList.stream().filter(filter);
    }

    public Catalog catalog(int index) {
        return this.catalogList.get(index);
    }

    public Stream<TemporalCatalog> temporalCatalogList(Predicate<TemporalCatalog> filter) {
        return this.temporalCatalogList.stream().filter(filter);
    }

    public TemporalCatalog temporalCatalog(int index) {
        return this.temporalCatalogList.get(index);
    }

    public Stream<Display> displayList(Predicate<Display> filter) {
        return this.displayList.stream().filter(filter);
    }

    public Display display(int index) {
        return this.displayList.get(index);
    }

    public Stream<Panel> panelList(Predicate<Panel> filter) {
        return this.panelList.stream().filter(filter);
    }

    public Panel panel(int index) {
        return this.panelList.get(index);
    }

    public Stream<Desktop> desktopList(Predicate<Desktop> filter) {
        return this.desktopList.stream().filter(filter);
    }

    public Desktop desktop(int index) {
        return this.desktopList.get(index);
    }

    public Stream<Layout> layoutList(Predicate<Layout> filter) {
        return this.layoutList.stream().filter(filter);
    }

    public Layout layout(int index) {
        return this.layoutList.get(index);
    }

    public Stream<ElementOption> elementOptionList(Predicate<ElementOption> filter) {
        return this.elementOptionList.stream().filter(filter);
    }

    public ElementOption elementOption(int index) {
        return this.elementOptionList.get(index);
    }

    public Stream<Mold> moldList(Predicate<Mold> filter) {
        return this.moldList.stream().filter(filter);
    }

    public Mold mold(int index) {
        return this.moldList.get(index);
    }

    public Stream<Task> taskList(Predicate<Task> filter) {
        return this.taskList.stream().filter(filter);
    }

    public Task task(int index) {
        return this.taskList.get(index);
    }

    public Stream<ScheduledTask> scheduledTaskList(Predicate<ScheduledTask> filter) {
        return this.scheduledTaskList.stream().filter(filter);
    }

    public ScheduledTask scheduledTask(int index) {
        return this.scheduledTaskList.get(index);
    }

    public Stream<BootTriggerTask> bootTriggerTaskList(Predicate<BootTriggerTask> filter) {
        return this.bootTriggerTaskList.stream().filter(filter);
    }

    public BootTriggerTask bootTriggerTask(int index) {
        return this.bootTriggerTaskList.get(index);
    }

    public Stream<TimeoutTriggerTask> timeoutTriggerTaskList(Predicate<TimeoutTriggerTask> filter) {
        return this.timeoutTriggerTaskList.stream().filter(filter);
    }

    public TimeoutTriggerTask timeoutTriggerTask(int index) {
        return this.timeoutTriggerTaskList.get(index);
    }

    public Stream<PeriodicTriggerTask> periodicTriggerTaskList(Predicate<PeriodicTriggerTask> filter) {
        return this.periodicTriggerTaskList.stream().filter(filter);
    }

    public PeriodicTriggerTask periodicTriggerTask(int index) {
        return this.periodicTriggerTaskList.get(index);
    }

    public Stream<CronTriggerTask> cronTriggerTaskList(Predicate<CronTriggerTask> filter) {
        return this.cronTriggerTaskList.stream().filter(filter);
    }

    public CronTriggerTask cronTriggerTask(int index) {
        return this.cronTriggerTaskList.get(index);
    }

    public Stream<ShutdownTriggerTask> shutdownTriggerTaskList(Predicate<ShutdownTriggerTask> filter) {
        return this.shutdownTriggerTaskList.stream().filter(filter);
    }

    public ShutdownTriggerTask shutdownTriggerTask(int index) {
        return this.shutdownTriggerTaskList.get(index);
    }

    public Stream<DirectorySentinelTask> directorySentinelTaskList(Predicate<DirectorySentinelTask> filter) {
        return this.directorySentinelTaskList.stream().filter(filter);
    }

    public DirectorySentinelTask directorySentinelTask(int index) {
        return this.directorySentinelTaskList.get(index);
    }

    public Stream<ProcessSentinelTask> processSentinelTaskList(Predicate<ProcessSentinelTask> filter) {
        return this.processSentinelTaskList.stream().filter(filter);
    }

    public ProcessSentinelTask processSentinelTask(int index) {
        return this.processSentinelTaskList.get(index);
    }

    public Stream<JMSQueueSentinelTask> jMSQueueSentinelTaskList(Predicate<JMSQueueSentinelTask> filter) {
        return this.jMSQueueSentinelTaskList.stream().filter(filter);
    }

    public JMSQueueSentinelTask jMSQueueSentinelTask(int index) {
        return this.jMSQueueSentinelTaskList.get(index);
    }

    public Stream<JMSTopicSentinelTask> jMSTopicSentinelTaskList(Predicate<JMSTopicSentinelTask> filter) {
        return this.jMSTopicSentinelTaskList.stream().filter(filter);
    }

    public JMSTopicSentinelTask jMSTopicSentinelTask(int index) {
        return this.jMSTopicSentinelTaskList.get(index);
    }

    public Stream<Dialog> dialogList(Predicate<Dialog> filter) {
        return this.dialogList.stream().filter(filter);
    }

    public Dialog dialog(int index) {
        return this.dialogList.get(index);
    }

    public Stream<MultipleInput> multipleInputList(Predicate<MultipleInput> filter) {
        return this.multipleInputList.stream().filter(filter);
    }

    public MultipleInput multipleInput(int index) {
        return this.multipleInputList.get(index);
    }

    public Stream<Data> dataList(Predicate<Data> filter) {
        return this.dataList.stream().filter(filter);
    }

    public Data data(int index) {
        return this.dataList.get(index);
    }

    public Stream<TypeData> typeDataList(Predicate<TypeData> filter) {
        return this.typeDataList.stream().filter(filter);
    }

    public TypeData typeData(int index) {
        return this.typeDataList.get(index);
    }

    public Stream<RealData> realDataList(Predicate<RealData> filter) {
        return this.realDataList.stream().filter(filter);
    }

    public RealData realData(int index) {
        return this.realDataList.get(index);
    }

    public Stream<IntegerData> integerDataList(Predicate<IntegerData> filter) {
        return this.integerDataList.stream().filter(filter);
    }

    public IntegerData integerData(int index) {
        return this.integerDataList.get(index);
    }

    public Stream<LongIntegerData> longIntegerDataList(Predicate<LongIntegerData> filter) {
        return this.longIntegerDataList.stream().filter(filter);
    }

    public LongIntegerData longIntegerData(int index) {
        return this.longIntegerDataList.get(index);
    }

    public Stream<BoolData> boolDataList(Predicate<BoolData> filter) {
        return this.boolDataList.stream().filter(filter);
    }

    public BoolData boolData(int index) {
        return this.boolDataList.get(index);
    }

    public Stream<TextData> textDataList(Predicate<TextData> filter) {
        return this.textDataList.stream().filter(filter);
    }

    public TextData textData(int index) {
        return this.textDataList.get(index);
    }

    public Stream<DateData> dateDataList(Predicate<DateData> filter) {
        return this.dateDataList.stream().filter(filter);
    }

    public DateData dateData(int index) {
        return this.dateDataList.get(index);
    }

    public Stream<DateTimeData> dateTimeDataList(Predicate<DateTimeData> filter) {
        return this.dateTimeDataList.stream().filter(filter);
    }

    public DateTimeData dateTimeData(int index) {
        return this.dateTimeDataList.get(index);
    }

    public Stream<FileData> fileDataList(Predicate<FileData> filter) {
        return this.fileDataList.stream().filter(filter);
    }

    public FileData fileData(int index) {
        return this.fileDataList.get(index);
    }

    public Stream<ObjectData> objectDataList(Predicate<ObjectData> filter) {
        return this.objectDataList.stream().filter(filter);
    }

    public ObjectData objectData(int index) {
        return this.objectDataList.get(index);
    }

    public Stream<ListData> listDataList(Predicate<ListData> filter) {
        return this.listDataList.stream().filter(filter);
    }

    public ListData listData(int index) {
        return this.listDataList.get(index);
    }

    public Stream<Schema> schemaList(Predicate<Schema> filter) {
        return this.schemaList.stream().filter(filter);
    }

    public Schema schema(int index) {
        return this.schemaList.get(index);
    }

    public Stream<Exception> exceptionList(Predicate<Exception> filter) {
        return this.exceptionList.stream().filter(filter);
    }

    public Exception exception(int index) {
        return this.exceptionList.get(index);
    }

    public Stream<EventSchema> eventSchemaList(Predicate<EventSchema> filter) {
        return this.eventSchemaList.stream().filter(filter);
    }

    public EventSchema eventSchema(int index) {
        return this.eventSchemaList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    public class Clear {
        public void service(Predicate<Service> filter) {
            new ArrayList<Service>(AbstractGraph.this.serviceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void rESTService(Predicate<RESTService> filter) {
            new ArrayList<RESTService>(AbstractGraph.this.rESTServiceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void jMXService(Predicate<JMXService> filter) {
            new ArrayList<JMXService>(AbstractGraph.this.jMXServiceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void jMSService(Predicate<JMSService> filter) {
            new ArrayList<JMSService>(AbstractGraph.this.jMSServiceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void slackBotService(Predicate<SlackBotService> filter) {
            new ArrayList<SlackBotService>(AbstractGraph.this.slackBotServiceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void activity(Predicate<Activity> filter) {
            new ArrayList<Activity>(AbstractGraph.this.activityList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void restrictedAbstractPage(Predicate<RestrictedAbstractPage> filter) {
            new ArrayList<RestrictedAbstractPage>(AbstractGraph.this.restrictedAbstractPageList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void catalog(Predicate<Catalog> filter) {
            new ArrayList<Catalog>(AbstractGraph.this.catalogList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void temporalCatalog(Predicate<TemporalCatalog> filter) {
            new ArrayList<TemporalCatalog>(AbstractGraph.this.temporalCatalogList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void display(Predicate<Display> filter) {
            new ArrayList<Display>(AbstractGraph.this.displayList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void panel(Predicate<Panel> filter) {
            new ArrayList<Panel>(AbstractGraph.this.panelList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void desktop(Predicate<Desktop> filter) {
            new ArrayList<Desktop>(AbstractGraph.this.desktopList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void layout(Predicate<Layout> filter) {
            new ArrayList<Layout>(AbstractGraph.this.layoutList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void elementOption(Predicate<ElementOption> filter) {
            new ArrayList<ElementOption>(AbstractGraph.this.elementOptionList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void mold(Predicate<Mold> filter) {
            new ArrayList<Mold>(AbstractGraph.this.moldList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void task(Predicate<Task> filter) {
            new ArrayList<Task>(AbstractGraph.this.taskList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void bootTriggerTask(Predicate<BootTriggerTask> filter) {
            new ArrayList<BootTriggerTask>(AbstractGraph.this.bootTriggerTaskList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void timeoutTriggerTask(Predicate<TimeoutTriggerTask> filter) {
            new ArrayList<TimeoutTriggerTask>(AbstractGraph.this.timeoutTriggerTaskList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void periodicTriggerTask(Predicate<PeriodicTriggerTask> filter) {
            new ArrayList<PeriodicTriggerTask>(AbstractGraph.this.periodicTriggerTaskList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void cronTriggerTask(Predicate<CronTriggerTask> filter) {
            new ArrayList<CronTriggerTask>(AbstractGraph.this.cronTriggerTaskList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void shutdownTriggerTask(Predicate<ShutdownTriggerTask> filter) {
            new ArrayList<ShutdownTriggerTask>(AbstractGraph.this.shutdownTriggerTaskList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void directorySentinelTask(Predicate<DirectorySentinelTask> filter) {
            new ArrayList<DirectorySentinelTask>(AbstractGraph.this.directorySentinelTaskList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void processSentinelTask(Predicate<ProcessSentinelTask> filter) {
            new ArrayList<ProcessSentinelTask>(AbstractGraph.this.processSentinelTaskList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void jMSQueueSentinelTask(Predicate<JMSQueueSentinelTask> filter) {
            new ArrayList<JMSQueueSentinelTask>(AbstractGraph.this.jMSQueueSentinelTaskList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void jMSTopicSentinelTask(Predicate<JMSTopicSentinelTask> filter) {
            new ArrayList<JMSTopicSentinelTask>(AbstractGraph.this.jMSTopicSentinelTaskList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void dialog(Predicate<Dialog> filter) {
            new ArrayList<Dialog>(AbstractGraph.this.dialogList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void multipleInput(Predicate<MultipleInput> filter) {
            new ArrayList<MultipleInput>(AbstractGraph.this.multipleInputList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void realData(Predicate<RealData> filter) {
            new ArrayList<RealData>(AbstractGraph.this.realDataList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void integerData(Predicate<IntegerData> filter) {
            new ArrayList<IntegerData>(AbstractGraph.this.integerDataList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void longIntegerData(Predicate<LongIntegerData> filter) {
            new ArrayList<LongIntegerData>(AbstractGraph.this.longIntegerDataList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void boolData(Predicate<BoolData> filter) {
            new ArrayList<BoolData>(AbstractGraph.this.boolDataList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void textData(Predicate<TextData> filter) {
            new ArrayList<TextData>(AbstractGraph.this.textDataList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void dateData(Predicate<DateData> filter) {
            new ArrayList<DateData>(AbstractGraph.this.dateDataList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void dateTimeData(Predicate<DateTimeData> filter) {
            new ArrayList<DateTimeData>(AbstractGraph.this.dateTimeDataList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void fileData(Predicate<FileData> filter) {
            new ArrayList<FileData>(AbstractGraph.this.fileDataList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void objectData(Predicate<ObjectData> filter) {
            new ArrayList<ObjectData>(AbstractGraph.this.objectDataList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void listData(Predicate<ListData> filter) {
            new ArrayList<ListData>(AbstractGraph.this.listDataList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void schema(Predicate<Schema> filter) {
            new ArrayList<Schema>(AbstractGraph.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void exception(Predicate<Exception> filter) {
            new ArrayList<Exception>(AbstractGraph.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void eventSchema(Predicate<EventSchema> filter) {
            new ArrayList<EventSchema>(AbstractGraph.this.eventSchemaList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public Service service() {
            Service newElement = (Service)((Service)AbstractGraph.this.graph.createRoot(Service.class, this.stash, this.name)).a$(Service.class);
            return newElement;
        }

        public RESTService rESTService(String basePath) {
            RESTService newElement = (RESTService)((RESTService)AbstractGraph.this.graph.createRoot(RESTService.class, this.stash, this.name)).a$(RESTService.class);
            newElement.core$().set((Layer)newElement, "basePath", Collections.singletonList(basePath));
            return newElement;
        }

        public JMXService jMXService() {
            JMXService newElement = (JMXService)((JMXService)AbstractGraph.this.graph.createRoot(JMXService.class, this.stash, this.name)).a$(JMXService.class);
            return newElement;
        }

        public JMSService jMSService(JMSService.SubscriptionModel subscriptionModel) {
            JMSService newElement = (JMSService)((JMSService)AbstractGraph.this.graph.createRoot(JMSService.class, this.stash, this.name)).a$(JMSService.class);
            newElement.core$().set((Layer)newElement, "subscriptionModel", Collections.singletonList(subscriptionModel));
            return newElement;
        }

        public SlackBotService slackBotService() {
            SlackBotService newElement = (SlackBotService)((SlackBotService)AbstractGraph.this.graph.createRoot(SlackBotService.class, this.stash, this.name)).a$(SlackBotService.class);
            return newElement;
        }

        public Activity activity(String title, String favicon) {
            Activity newElement = (Activity)((Activity)AbstractGraph.this.graph.createRoot(Activity.class, this.stash, this.name)).a$(Activity.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "favicon", Collections.singletonList(favicon));
            return newElement;
        }

        public RestrictedAbstractPage restrictedAbstractPage() {
            RestrictedAbstractPage newElement = (RestrictedAbstractPage)((RestrictedAbstractPage)AbstractGraph.this.graph.createRoot(RestrictedAbstractPage.class, this.stash, this.name)).a$(RestrictedAbstractPage.class);
            return newElement;
        }

        public Catalog catalog(String modelClass) {
            Catalog newElement = (Catalog)((Catalog)AbstractGraph.this.graph.createRoot(Catalog.class, this.stash, this.name)).a$(Catalog.class);
            newElement.core$().set((Layer)newElement, "modelClass", Collections.singletonList(modelClass));
            return newElement;
        }

        public TemporalCatalog temporalCatalog(String modelClass, TemporalCatalog.Type type, List<TemporalCatalog.Scales> scales) {
            TemporalCatalog newElement = (TemporalCatalog)((TemporalCatalog)AbstractGraph.this.graph.createRoot(TemporalCatalog.class, this.stash, this.name)).a$(TemporalCatalog.class);
            newElement.core$().set((Layer)newElement, "modelClass", Collections.singletonList(modelClass));
            newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
            newElement.core$().set((Layer)newElement, "scales", scales);
            return newElement;
        }

        public Display display() {
            Display newElement = (Display)((Display)AbstractGraph.this.graph.createRoot(Display.class, this.stash, this.name)).a$(Display.class);
            return newElement;
        }

        public Panel panel() {
            Panel newElement = (Panel)((Panel)AbstractGraph.this.graph.createRoot(Panel.class, this.stash, this.name)).a$(Panel.class);
            return newElement;
        }

        public Desktop desktop(Layout layout, String title, String subTitle, String logoPath, String faviconPath) {
            Desktop newElement = (Desktop)((Desktop)AbstractGraph.this.graph.createRoot(Desktop.class, this.stash, this.name)).a$(Desktop.class);
            newElement.core$().set((Layer)newElement, "layout", Collections.singletonList(layout));
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "subTitle", Collections.singletonList(subTitle));
            newElement.core$().set((Layer)newElement, "logoPath", Collections.singletonList(logoPath));
            newElement.core$().set((Layer)newElement, "faviconPath", Collections.singletonList(faviconPath));
            return newElement;
        }

        public Layout layout(Layout.Mode mode) {
            Layout newElement = (Layout)((Layout)AbstractGraph.this.graph.createRoot(Layout.class, this.stash, this.name)).a$(Layout.class);
            newElement.core$().set((Layer)newElement, "mode", Collections.singletonList(mode));
            return newElement;
        }

        public ElementOption elementOption() {
            ElementOption newElement = (ElementOption)((ElementOption)AbstractGraph.this.graph.createRoot(ElementOption.class, this.stash, this.name)).a$(ElementOption.class);
            return newElement;
        }

        public Mold mold(String modelClass) {
            Mold newElement = (Mold)((Mold)AbstractGraph.this.graph.createRoot(Mold.class, this.stash, this.name)).a$(Mold.class);
            newElement.core$().set((Layer)newElement, "modelClass", Collections.singletonList(modelClass));
            return newElement;
        }

        public Task task() {
            Task newElement = (Task)((Task)AbstractGraph.this.graph.createRoot(Task.class, this.stash, this.name)).a$(Task.class);
            return newElement;
        }

        public BootTriggerTask bootTriggerTask() {
            BootTriggerTask newElement = (BootTriggerTask)((BootTriggerTask)AbstractGraph.this.graph.createRoot(BootTriggerTask.class, this.stash, this.name)).a$(BootTriggerTask.class);
            return newElement;
        }

        public TimeoutTriggerTask timeoutTriggerTask(int delay) {
            TimeoutTriggerTask newElement = (TimeoutTriggerTask)((TimeoutTriggerTask)AbstractGraph.this.graph.createRoot(TimeoutTriggerTask.class, this.stash, this.name)).a$(TimeoutTriggerTask.class);
            newElement.core$().set((Layer)newElement, "delay", Collections.singletonList(delay));
            return newElement;
        }

        public PeriodicTriggerTask periodicTriggerTask(int delay, int interval) {
            PeriodicTriggerTask newElement = (PeriodicTriggerTask)((PeriodicTriggerTask)AbstractGraph.this.graph.createRoot(PeriodicTriggerTask.class, this.stash, this.name)).a$(PeriodicTriggerTask.class);
            newElement.core$().set((Layer)newElement, "delay", Collections.singletonList(delay));
            newElement.core$().set((Layer)newElement, "interval", Collections.singletonList(interval));
            return newElement;
        }

        public CronTriggerTask cronTriggerTask(String pattern) {
            CronTriggerTask newElement = (CronTriggerTask)((CronTriggerTask)AbstractGraph.this.graph.createRoot(CronTriggerTask.class, this.stash, this.name)).a$(CronTriggerTask.class);
            newElement.core$().set((Layer)newElement, "pattern", Collections.singletonList(pattern));
            return newElement;
        }

        public ShutdownTriggerTask shutdownTriggerTask() {
            ShutdownTriggerTask newElement = (ShutdownTriggerTask)((ShutdownTriggerTask)AbstractGraph.this.graph.createRoot(ShutdownTriggerTask.class, this.stash, this.name)).a$(ShutdownTriggerTask.class);
            return newElement;
        }

        public DirectorySentinelTask directorySentinelTask(String directory, List<DirectorySentinelTask.Events> events) {
            DirectorySentinelTask newElement = (DirectorySentinelTask)((DirectorySentinelTask)AbstractGraph.this.graph.createRoot(DirectorySentinelTask.class, this.stash, this.name)).a$(DirectorySentinelTask.class);
            newElement.core$().set((Layer)newElement, "directory", Collections.singletonList(directory));
            newElement.core$().set((Layer)newElement, "events", events);
            return newElement;
        }

        public ProcessSentinelTask processSentinelTask(String processName, List<ProcessSentinelTask.Events> events, ProcessChecker check) {
            ProcessSentinelTask newElement = (ProcessSentinelTask)((ProcessSentinelTask)AbstractGraph.this.graph.createRoot(ProcessSentinelTask.class, this.stash, this.name)).a$(ProcessSentinelTask.class);
            newElement.core$().set((Layer)newElement, "processName", Collections.singletonList(processName));
            newElement.core$().set((Layer)newElement, "events", events);
            newElement.core$().set((Layer)newElement, "check", Collections.singletonList(check));
            return newElement;
        }

        public JMSQueueSentinelTask jMSQueueSentinelTask(String queue) {
            JMSQueueSentinelTask newElement = (JMSQueueSentinelTask)((JMSQueueSentinelTask)AbstractGraph.this.graph.createRoot(JMSQueueSentinelTask.class, this.stash, this.name)).a$(JMSQueueSentinelTask.class);
            newElement.core$().set((Layer)newElement, "queue", Collections.singletonList(queue));
            return newElement;
        }

        public JMSTopicSentinelTask jMSTopicSentinelTask(String topic) {
            JMSTopicSentinelTask newElement = (JMSTopicSentinelTask)((JMSTopicSentinelTask)AbstractGraph.this.graph.createRoot(JMSTopicSentinelTask.class, this.stash, this.name)).a$(JMSTopicSentinelTask.class);
            newElement.core$().set((Layer)newElement, "topic", Collections.singletonList(topic));
            return newElement;
        }

        public Dialog dialog(String url, String label, String description) {
            Dialog newElement = (Dialog)((Dialog)AbstractGraph.this.graph.createRoot(Dialog.class, this.stash, this.name)).a$(Dialog.class);
            newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "description", Collections.singletonList(description));
            return newElement;
        }

        public MultipleInput multipleInput() {
            MultipleInput newElement = (MultipleInput)((MultipleInput)AbstractGraph.this.graph.createRoot(MultipleInput.class, this.stash, this.name)).a$(MultipleInput.class);
            return newElement;
        }

        public DataLake dataLake(String domain, String clientID) {
            DataLake newElement = (DataLake)((DataLake)AbstractGraph.this.graph.createRoot(DataLake.class, this.stash, this.name)).a$(DataLake.class);
            newElement.core$().set((Layer)newElement, "domain", Collections.singletonList(domain));
            newElement.core$().set((Layer)newElement, "clientID", Collections.singletonList(clientID));
            return newElement;
        }

        public RealData realData() {
            RealData newElement = (RealData)((RealData)AbstractGraph.this.graph.createRoot(RealData.class, this.stash, this.name)).a$(RealData.class);
            return newElement;
        }

        public IntegerData integerData() {
            IntegerData newElement = (IntegerData)((IntegerData)AbstractGraph.this.graph.createRoot(IntegerData.class, this.stash, this.name)).a$(IntegerData.class);
            return newElement;
        }

        public LongIntegerData longIntegerData() {
            LongIntegerData newElement = (LongIntegerData)((LongIntegerData)AbstractGraph.this.graph.createRoot(LongIntegerData.class, this.stash, this.name)).a$(LongIntegerData.class);
            return newElement;
        }

        public BoolData boolData() {
            BoolData newElement = (BoolData)((BoolData)AbstractGraph.this.graph.createRoot(BoolData.class, this.stash, this.name)).a$(BoolData.class);
            return newElement;
        }

        public TextData textData() {
            TextData newElement = (TextData)((TextData)AbstractGraph.this.graph.createRoot(TextData.class, this.stash, this.name)).a$(TextData.class);
            return newElement;
        }

        public DateData dateData() {
            DateData newElement = (DateData)((DateData)AbstractGraph.this.graph.createRoot(DateData.class, this.stash, this.name)).a$(DateData.class);
            return newElement;
        }

        public DateTimeData dateTimeData() {
            DateTimeData newElement = (DateTimeData)((DateTimeData)AbstractGraph.this.graph.createRoot(DateTimeData.class, this.stash, this.name)).a$(DateTimeData.class);
            return newElement;
        }

        public FileData fileData() {
            FileData newElement = (FileData)((FileData)AbstractGraph.this.graph.createRoot(FileData.class, this.stash, this.name)).a$(FileData.class);
            return newElement;
        }

        public ObjectData objectData(Schema schema) {
            ObjectData newElement = (ObjectData)((ObjectData)AbstractGraph.this.graph.createRoot(ObjectData.class, this.stash, this.name)).a$(ObjectData.class);
            newElement.core$().set((Layer)newElement, "schema", Collections.singletonList(schema));
            return newElement;
        }

        public ListData listData() {
            ListData newElement = (ListData)((ListData)AbstractGraph.this.graph.createRoot(ListData.class, this.stash, this.name)).a$(ListData.class);
            return newElement;
        }

        public Schema schema() {
            Schema newElement = (Schema)((Schema)AbstractGraph.this.graph.createRoot(Schema.class, this.stash, this.name)).a$(Schema.class);
            return newElement;
        }

        public Exception exception(ExceptionCodes code) {
            Exception newElement = (Exception)((Exception)AbstractGraph.this.graph.createRoot(Exception.class, this.stash, this.name)).a$(Exception.class);
            newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
            return newElement;
        }

        public EventSchema eventSchema() {
            EventSchema newElement = (EventSchema)((EventSchema)AbstractGraph.this.graph.createRoot(EventSchema.class, this.stash, this.name)).a$(EventSchema.class);
            return newElement;
        }
    }
}

