/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display.prototypes;

import com.intellij.openapi.project.Project;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.DesktopTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.PrototypeRenderer;
import io.intino.konos.model.graph.Activity;
import io.intino.konos.model.graph.Desktop;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.Frame;

public class DesktopRenderer
extends PrototypeRenderer {
    private final Project project;

    public DesktopRenderer(Project project, Desktop desktop, File src, File gen, String packageName, String boxName) {
        super(desktop, boxName, packageName, src, gen);
        this.project = project;
    }

    public void render() {
        Frame frame = this.createFrame();
        this.writeSrc(frame);
        this.writeAbstract(frame.addTypes(new String[]{"gen"}));
    }

    @Override
    protected Frame createFrame() {
        Activity used;
        Desktop desktop = (Desktop)this.display.a$(Desktop.class);
        Frame frame = super.createFrame();
        frame.addSlot("title", new String[]{desktop.title()});
        frame.addSlot("subtitle", new String[]{desktop.subTitle()});
        if (desktop.logoPath() != null && !desktop.logoPath().isEmpty()) {
            frame.addSlot("logo", new String[]{desktop.logoPath()});
        }
        if (desktop.faviconPath() != null && !desktop.faviconPath().isEmpty()) {
            frame.addSlot("favicon", new String[]{desktop.faviconPath()});
        }
        if ((used = this.findOwnerActivity()) != null && used.authenticated() != null) {
            frame.addSlot("activity", new String[]{used.name$()});
        }
        if (desktop.layout() != null) {
            frame.addSlot("layout", new String[]{desktop.layout().name$()});
        }
        return frame;
    }

    private Activity findOwnerActivity() {
        return this.display.graph().activityList().stream().filter(activity -> activity.userHome() != null && ((Object)((Object)this.display)).equals((Object)activity.userHome().uses())).findFirst().orElse(null);
    }

    @Override
    protected Template template() {
        return DesktopRenderer.customize(DesktopTemplate.create());
    }

    @Override
    protected Template srcTemplate() {
        return this.template();
    }
}

