/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import cottons.utils.StringHelper;
import org.siani.itrules.Formatter;
import org.siani.itrules.Template;

public class Formatters {
    public static Formatter validMoldName() {
        return value -> {
            String name = value.toString().replace("-", "");
            return Character.isDigit(name.charAt(0)) ? "m" + name : name;
        };
    }

    public static Formatter validName() {
        return value -> StringHelper.snakeCaseToCamelCase((String)value.toString().replace(".", "-"));
    }

    public static Formatter snakeCaseToCamelCase() {
        return value -> StringHelper.snakeCaseToCamelCase((String)value.toString());
    }

    public static Formatter returnType() {
        return value -> value.equals("Void") ? "void" : value;
    }

    public static String firstLowerCase(String value) {
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }

    public static String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    public static Formatter returnTypeFormatter() {
        return value -> {
            if (value.equals("Void")) {
                return "void";
            }
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        };
    }

    public static Formatter camelCaseToSnakeCase() {
        return value -> StringHelper.camelCaseToSnakeCase((String)value.toString());
    }

    public static Formatter quoted() {
        return value -> '\"' + value.toString() + '\"';
    }

    public static Formatter validPackage() {
        return value -> value.toString().replace("-", "").toLowerCase();
    }

    private static Formatter subPath() {
        return value -> {
            String path = value.toString();
            return path.contains(":") ? path.substring(0, path.indexOf(":")) : path;
        };
    }

    public static Template customize(Template template) {
        template.add("validname", Formatters.validName());
        template.add("snakecaseToCamelCase", Formatters.snakeCaseToCamelCase());
        template.add("returnType", Formatters.returnType());
        template.add("returnTypeFormatter", Formatters.returnTypeFormatter());
        template.add("quoted", Formatters.quoted());
        template.add("validPackage", Formatters.validPackage());
        template.add("camelCaseToSnakeCase", Formatters.camelCaseToSnakeCase());
        template.add("subpath", Formatters.subPath());
        return template;
    }
}

