/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Activity;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.Data;
import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.bool.BoolData;
import io.intino.konos.model.graph.date.DateData;
import io.intino.konos.model.graph.datetime.DateTimeData;
import io.intino.konos.model.graph.file.FileData;
import io.intino.konos.model.graph.integer.IntegerData;
import io.intino.konos.model.graph.list.ListData;
import io.intino.konos.model.graph.longinteger.LongIntegerData;
import io.intino.konos.model.graph.object.ObjectData;
import io.intino.konos.model.graph.real.RealData;
import io.intino.konos.model.graph.rules.ExceptionCodes;
import io.intino.konos.model.graph.text.TextData;
import io.intino.konos.model.graph.type.TypeData;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Display
extends Component
implements Terminal {
    protected String label;
    protected List<Display> displays = new ArrayList<Display>();
    protected String parentDisplay;
    protected List<Request> requestList = new ArrayList<Request>();
    protected List<Notification> notificationList = new ArrayList<Notification>();

    public Display(Node node) {
        super(node);
    }

    public String label() {
        return this.label;
    }

    public List<Display> displays() {
        return this.displays;
    }

    public Display displays(int index) {
        return this.displays.get(index);
    }

    public List<Display> displays(Predicate<Display> predicate) {
        return this.displays().stream().filter(predicate).collect(Collectors.toList());
    }

    public String parentDisplay() {
        return this.parentDisplay;
    }

    public Display label(String value) {
        this.label = value;
        return this;
    }

    public Display parentDisplay(String value) {
        this.parentDisplay = value;
        return this;
    }

    public List<Request> requestList() {
        return Collections.unmodifiableList(this.requestList);
    }

    public Request request(int index) {
        return this.requestList.get(index);
    }

    public List<Request> requestList(Predicate<Request> predicate) {
        return this.requestList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Notification> notificationList() {
        return Collections.unmodifiableList(this.notificationList);
    }

    public Notification notification(int index) {
        return this.notificationList.get(index);
    }

    public List<Notification> notificationList(Predicate<Notification> predicate) {
        return this.notificationList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Request>(this.requestList).forEach(c -> components.add(c.core$()));
        new ArrayList<Notification>(this.notificationList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
        map.put("displays", this.displays);
        map.put("parentDisplay", new ArrayList<String>(Collections.singletonList(this.parentDisplay)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Display$Request")) {
            this.requestList.add((Request)node.as(Request.class));
        }
        if (node.is("Display$Notification")) {
            this.notificationList.add((Notification)node.as(Notification.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Display$Request")) {
            this.requestList.remove(node.as(Request.class));
        }
        if (node.is("Display$Notification")) {
            this.notificationList.remove(node.as(Notification.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("displays")) {
            this.displays = NodeLoader.load(values, Display.class, (Layer)this);
        } else if (name.equalsIgnoreCase("parentDisplay")) {
            this.parentDisplay = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)values.get(0);
        } else if (name.equalsIgnoreCase("displays")) {
            this.displays = values.stream().map(s -> (Display)this.graph().core$().load(((Layer)s).core$().id()).as(Display.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("parentDisplay")) {
            this.parentDisplay = (String)values.get(0);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Notification
    extends Data
    implements Terminal {
        protected To to;
        protected List<Exception> exceptionRefs = new ArrayList<Exception>();
        protected List<Exception> exceptionList = new ArrayList<Exception>();

        public Notification(Node node) {
            super(node);
        }

        public To to() {
            return this.to;
        }

        public List<Exception> exceptionRefs() {
            return this.exceptionRefs;
        }

        public Exception exceptionRefs(int index) {
            return this.exceptionRefs.get(index);
        }

        public List<Exception> exceptionRefs(Predicate<Exception> predicate) {
            return this.exceptionRefs().stream().filter(predicate).collect(Collectors.toList());
        }

        public Notification to(To value) {
            this.to = value;
            return this;
        }

        public List<Exception> exceptionList() {
            return Collections.unmodifiableList(this.exceptionList);
        }

        public Exception exception(int index) {
            return this.exceptionList.get(index);
        }

        public List<Exception> exceptionList(Predicate<Exception> predicate) {
            return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
        }

        @Override
        public IntegerData asInteger() {
            Layer as = this.a$(IntegerData.class);
            return as != null ? (IntegerData)as : (IntegerData)this.core$().addFacet(IntegerData.class);
        }

        @Override
        public boolean isInteger() {
            return this.core$().is(IntegerData.class);
        }

        @Override
        public TypeData asType() {
            return (TypeData)this.a$(TypeData.class);
        }

        @Override
        public TypeData asType(Expression<String> type) {
            TypeData newElement = (TypeData)this.core$().addFacet(TypeData.class);
            newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        @Override
        public boolean isType() {
            return this.core$().is(TypeData.class);
        }

        @Override
        public void removeType() {
            this.core$().removeFacet(TypeData.class);
        }

        @Override
        public BoolData asBool() {
            Layer as = this.a$(BoolData.class);
            return as != null ? (BoolData)as : (BoolData)this.core$().addFacet(BoolData.class);
        }

        @Override
        public boolean isBool() {
            return this.core$().is(BoolData.class);
        }

        @Override
        public RealData asReal() {
            Layer as = this.a$(RealData.class);
            return as != null ? (RealData)as : (RealData)this.core$().addFacet(RealData.class);
        }

        @Override
        public boolean isReal() {
            return this.core$().is(RealData.class);
        }

        @Override
        public LongIntegerData asLongInteger() {
            Layer as = this.a$(LongIntegerData.class);
            return as != null ? (LongIntegerData)as : (LongIntegerData)this.core$().addFacet(LongIntegerData.class);
        }

        @Override
        public boolean isLongInteger() {
            return this.core$().is(LongIntegerData.class);
        }

        @Override
        public TextData asText() {
            Layer as = this.a$(TextData.class);
            return as != null ? (TextData)as : (TextData)this.core$().addFacet(TextData.class);
        }

        @Override
        public boolean isText() {
            return this.core$().is(TextData.class);
        }

        @Override
        public ObjectData asObject() {
            return (ObjectData)this.a$(ObjectData.class);
        }

        @Override
        public ObjectData asObject(Schema schema) {
            ObjectData newElement = (ObjectData)this.core$().addFacet(ObjectData.class);
            newElement.core$().set((Layer)newElement, "schema", Collections.singletonList(schema));
            return newElement;
        }

        @Override
        public boolean isObject() {
            return this.core$().is(ObjectData.class);
        }

        @Override
        public void removeObject() {
            this.core$().removeFacet(ObjectData.class);
        }

        @Override
        public ListData asList() {
            Layer as = this.a$(ListData.class);
            return as != null ? (ListData)as : (ListData)this.core$().addFacet(ListData.class);
        }

        @Override
        public boolean isList() {
            return this.core$().is(ListData.class);
        }

        @Override
        public FileData asFile() {
            Layer as = this.a$(FileData.class);
            return as != null ? (FileData)as : (FileData)this.core$().addFacet(FileData.class);
        }

        @Override
        public boolean isFile() {
            return this.core$().is(FileData.class);
        }

        @Override
        public DateData asDate() {
            Layer as = this.a$(DateData.class);
            return as != null ? (DateData)as : (DateData)this.core$().addFacet(DateData.class);
        }

        @Override
        public boolean isDate() {
            return this.core$().is(DateData.class);
        }

        @Override
        public DateTimeData asDateTime() {
            Layer as = this.a$(DateTimeData.class);
            return as != null ? (DateTimeData)as : (DateTimeData)this.core$().addFacet(DateTimeData.class);
        }

        @Override
        public boolean isDateTime() {
            return this.core$().is(DateTimeData.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Exception>(this.exceptionList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("to", new ArrayList<To>(Collections.singletonList(this.to)));
            map.put("exceptionRefs", this.exceptionRefs);
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Exception")) {
                this.exceptionList.add((Exception)node.as(Exception.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Exception")) {
                this.exceptionList.remove(node.as(Exception.class));
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("to")) {
                this.to = (To)((Object)WordLoader.load(values, To.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = NodeLoader.load(values, Exception.class, (Layer)this);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("to")) {
                this.to = (To)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = values.stream().map(s -> (Exception)this.graph().core$().load(((Layer)s).core$().id()).as(Exception.class)).collect(Collectors.toList());
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(Notification.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create
        extends Data.Create {
            public Create(String name) {
                super(name);
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)Notification.this.core$().graph().concept(Exception.class).createNode(this.name, Notification.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }

        public static enum To {
            All,
            Client,
            Display;

        }
    }

    public static class Request
    extends Data
    implements Terminal {
        protected ResponseType responseType;
        protected List<Exception> exceptionRefs = new ArrayList<Exception>();
        protected RegisterPath registerPath;
        protected List<Exception> exceptionList = new ArrayList<Exception>();

        public Request(Node node) {
            super(node);
        }

        public ResponseType responseType() {
            return this.responseType;
        }

        public List<Exception> exceptionRefs() {
            return this.exceptionRefs;
        }

        public Exception exceptionRefs(int index) {
            return this.exceptionRefs.get(index);
        }

        public List<Exception> exceptionRefs(Predicate<Exception> predicate) {
            return this.exceptionRefs().stream().filter(predicate).collect(Collectors.toList());
        }

        public Request responseType(ResponseType value) {
            this.responseType = value;
            return this;
        }

        public RegisterPath registerPath() {
            return this.registerPath;
        }

        public List<Exception> exceptionList() {
            return Collections.unmodifiableList(this.exceptionList);
        }

        public Exception exception(int index) {
            return this.exceptionList.get(index);
        }

        public List<Exception> exceptionList(Predicate<Exception> predicate) {
            return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Request registerPath(RegisterPath value) {
            this.registerPath = value;
            return this;
        }

        @Override
        public IntegerData asInteger() {
            Layer as = this.a$(IntegerData.class);
            return as != null ? (IntegerData)as : (IntegerData)this.core$().addFacet(IntegerData.class);
        }

        @Override
        public boolean isInteger() {
            return this.core$().is(IntegerData.class);
        }

        @Override
        public TypeData asType() {
            return (TypeData)this.a$(TypeData.class);
        }

        @Override
        public TypeData asType(Expression<String> type) {
            TypeData newElement = (TypeData)this.core$().addFacet(TypeData.class);
            newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        @Override
        public boolean isType() {
            return this.core$().is(TypeData.class);
        }

        @Override
        public void removeType() {
            this.core$().removeFacet(TypeData.class);
        }

        @Override
        public BoolData asBool() {
            Layer as = this.a$(BoolData.class);
            return as != null ? (BoolData)as : (BoolData)this.core$().addFacet(BoolData.class);
        }

        @Override
        public boolean isBool() {
            return this.core$().is(BoolData.class);
        }

        @Override
        public RealData asReal() {
            Layer as = this.a$(RealData.class);
            return as != null ? (RealData)as : (RealData)this.core$().addFacet(RealData.class);
        }

        @Override
        public boolean isReal() {
            return this.core$().is(RealData.class);
        }

        @Override
        public LongIntegerData asLongInteger() {
            Layer as = this.a$(LongIntegerData.class);
            return as != null ? (LongIntegerData)as : (LongIntegerData)this.core$().addFacet(LongIntegerData.class);
        }

        @Override
        public boolean isLongInteger() {
            return this.core$().is(LongIntegerData.class);
        }

        @Override
        public TextData asText() {
            Layer as = this.a$(TextData.class);
            return as != null ? (TextData)as : (TextData)this.core$().addFacet(TextData.class);
        }

        @Override
        public boolean isText() {
            return this.core$().is(TextData.class);
        }

        @Override
        public ObjectData asObject() {
            return (ObjectData)this.a$(ObjectData.class);
        }

        @Override
        public ObjectData asObject(Schema schema) {
            ObjectData newElement = (ObjectData)this.core$().addFacet(ObjectData.class);
            newElement.core$().set((Layer)newElement, "schema", Collections.singletonList(schema));
            return newElement;
        }

        @Override
        public boolean isObject() {
            return this.core$().is(ObjectData.class);
        }

        @Override
        public void removeObject() {
            this.core$().removeFacet(ObjectData.class);
        }

        @Override
        public ListData asList() {
            Layer as = this.a$(ListData.class);
            return as != null ? (ListData)as : (ListData)this.core$().addFacet(ListData.class);
        }

        @Override
        public boolean isList() {
            return this.core$().is(ListData.class);
        }

        @Override
        public FileData asFile() {
            Layer as = this.a$(FileData.class);
            return as != null ? (FileData)as : (FileData)this.core$().addFacet(FileData.class);
        }

        @Override
        public boolean isFile() {
            return this.core$().is(FileData.class);
        }

        @Override
        public DateData asDate() {
            Layer as = this.a$(DateData.class);
            return as != null ? (DateData)as : (DateData)this.core$().addFacet(DateData.class);
        }

        @Override
        public boolean isDate() {
            return this.core$().is(DateData.class);
        }

        @Override
        public DateTimeData asDateTime() {
            Layer as = this.a$(DateTimeData.class);
            return as != null ? (DateTimeData)as : (DateTimeData)this.core$().addFacet(DateTimeData.class);
        }

        @Override
        public boolean isDateTime() {
            return this.core$().is(DateTimeData.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.registerPath != null) {
                components.add(this.registerPath.core$());
            }
            new ArrayList<Exception>(this.exceptionList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("responseType", new ArrayList<ResponseType>(Collections.singletonList(this.responseType)));
            map.put("exceptionRefs", this.exceptionRefs);
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Display$Request$RegisterPath")) {
                this.registerPath = (RegisterPath)node.as(RegisterPath.class);
            }
            if (node.is("Exception")) {
                this.exceptionList.add((Exception)node.as(Exception.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Display$Request$RegisterPath")) {
                this.registerPath = null;
            }
            if (node.is("Exception")) {
                this.exceptionList.remove(node.as(Exception.class));
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("responseType")) {
                this.responseType = (ResponseType)((Object)WordLoader.load(values, ResponseType.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = NodeLoader.load(values, Exception.class, (Layer)this);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("responseType")) {
                this.responseType = (ResponseType)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = values.stream().map(s -> (Exception)this.graph().core$().load(((Layer)s).core$().id()).as(Exception.class)).collect(Collectors.toList());
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class RegisterPath
        extends Layer
        implements Terminal {
            protected Activity.Page page;

            public RegisterPath(Node node) {
                super(node);
            }

            public Activity.Page page() {
                return this.page;
            }

            public RegisterPath page(Activity.Page value) {
                this.page = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("page", this.page != null ? new ArrayList<Activity.Page>(Collections.singletonList(this.page)) : Collections.emptyList());
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("page")) {
                    this.page = (Activity.Page)((Object)NodeLoader.load(values, Activity.Page.class, (Layer)this).get(0));
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("page")) {
                    this.page = values.get(0) != null ? (Activity.Page)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Activity.Page.class) : null;
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public class Clear {
            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(Request.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create
        extends Data.Create {
            public Create(String name) {
                super(name);
            }

            public RegisterPath registerPath(Activity.Page page) {
                RegisterPath newElement = (RegisterPath)Request.this.core$().graph().concept(RegisterPath.class).createNode(this.name, Request.this.core$()).as(RegisterPath.class);
                newElement.core$().set((Layer)newElement, "page", Collections.singletonList(page));
                return newElement;
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)Request.this.core$().graph().concept(Exception.class).createNode(this.name, Request.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }

        public static enum ResponseType {
            Asset,
            Void;

        }
    }

    public class Clear {
        public void request(Predicate<Request> filter) {
            new ArrayList<Request>(Display.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void notification(Predicate<Notification> filter) {
            new ArrayList<Notification>(Display.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Component.Create {
        public Create(String name) {
            super(name);
        }

        public Request request() {
            Request newElement = (Request)Display.this.core$().graph().concept(Request.class).createNode(this.name, Display.this.core$()).as(Request.class);
            return newElement;
        }

        public Notification notification() {
            Notification newElement = (Notification)Display.this.core$().graph().concept(Notification.class).createNode(this.name, Display.this.core$()).as(Notification.class);
            return newElement;
        }
    }
}

