/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display.prototypes.updaters;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.LayoutRenderer;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.LayoutTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.PrototypeRenderer;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.updaters.Updater;
import io.intino.konos.model.graph.ElementOption;
import io.intino.konos.model.graph.Group;
import io.intino.konos.model.graph.Layout;
import java.io.File;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.siani.itrules.Template;

public class LayoutUpdater
extends Updater {
    private final LayoutRenderer layoutRenderer;
    private final Template template;
    private Layout layout;
    private PsiClass psiClass;

    public LayoutUpdater(File sourceFile, Layout layout, Project project, String packageName, String box) {
        super(sourceFile, project, packageName, box);
        this.layout = layout;
        this.layoutRenderer = new LayoutRenderer(project, layout, null, null, packageName, box);
        this.template = PrototypeRenderer.customize(LayoutTemplate.create());
        if (this.file != null && this.file instanceof PsiJavaFile && ((PsiJavaFile)this.file).getClasses().length != 0) {
            this.psiClass = ((PsiJavaFile)this.file).getClasses()[0];
        }
    }

    @Override
    public void update() {
        if (this.psiClass == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
            WriteCommandAction.runWriteCommandAction((Project)this.project, this::updateLayout);
        } else {
            this.updateLayout();
        }
    }

    private void updateLayout() {
        this.update(this.layout.elementOptionList());
    }

    private void update(List<? extends ElementOption> elementOptions) {
        for (ElementOption elementOption : elementOptions) {
            if (this.classOf(elementOption) == null) {
                this.update(elementOption);
            }
            if (!elementOption.i$(Group.class)) continue;
            this.update(((Group)elementOption.a$(Group.class)).optionsList());
        }
    }

    private void update(ElementOption option) {
        String text = this.classFor(option);
        PsiClass parentClass = this.parentClass(option);
        if (!text.isEmpty()) {
            parentClass.addAfter((PsiElement)this.createClass(text, parentClass), parentClass == this.psiClass ? this.psiClass.getConstructors()[0].getNextSibling() : parentClass.getLBrace());
        }
    }

    private PsiClass classOf(ElementOption elementOption) {
        PsiClass parent = this.psiClass;
        Stack<String> identifiers = this.qn(elementOption);
        while (!identifiers.empty()) {
            PsiClass child = this.innerClass(parent, identifiers.pop());
            if (child == null) {
                return null;
            }
            parent = child;
        }
        return parent;
    }

    private PsiClass parentClass(ElementOption elementOption) {
        PsiClass parent = this.psiClass;
        Stack<String> identifiers = this.qn(elementOption);
        while (!identifiers.empty()) {
            String id = identifiers.pop();
            if (identifiers.isEmpty()) {
                return parent;
            }
            parent = this.innerClass(parent, id);
        }
        return parent;
    }

    @NotNull
    private Stack<String> qn(ElementOption option) {
        Stack<String> identifiers = new Stack<String>();
        identifiers.push(Formatters.firstUpperCase(option.name$()));
        while (option.core$().owner().is(ElementOption.class)) {
            identifiers.push(Formatters.firstUpperCase(option.core$().owner().name()));
            option = (ElementOption)option.core$().ownerAs(ElementOption.class);
        }
        Stack<String> stack = identifiers;
        if (stack == null) {
            LayoutUpdater.$$$reportNull$$$0(0);
        }
        return stack;
    }

    private String classFor(ElementOption elementOption) {
        return this.template.format((Object)this.layoutRenderer.frameOf(elementOption));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/services/activity/display/prototypes/updaters/LayoutUpdater", "qn"));
    }
}

