/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display.prototypes;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.AbstractLayoutTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.LayoutTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.PrototypeRenderer;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.updaters.LayoutUpdater;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.ElementOption;
import io.intino.konos.model.graph.ElementRenderer;
import io.intino.konos.model.graph.Group;
import io.intino.konos.model.graph.Layout;
import io.intino.konos.model.graph.Option;
import io.intino.konos.model.graph.Options;
import io.intino.konos.model.graph.RenderCatalogs;
import io.intino.konos.model.graph.RenderDisplay;
import io.intino.konos.model.graph.RenderObjects;
import io.intino.konos.model.graph.RenderPanels;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.engine.formatters.StringFormatter;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class LayoutRenderer
extends PrototypeRenderer {
    private final Project project;

    public LayoutRenderer(Project project, Layout layout, File src, File gen, String packageName, String boxName) {
        super(layout, boxName, packageName, src, gen);
        this.project = project;
    }

    public void render() {
        Frame frame = this.createFrame();
        this.writeSrc(frame);
        this.writeAbstract(frame.addTypes(new String[]{"gen"}));
    }

    @Override
    protected Frame createFrame() {
        Layout layout = (Layout)this.display.a$(Layout.class);
        Frame frame = super.createFrame();
        frame.addSlot("mode", new String[]{layout.mode().name()});
        frame.addSlot("elementOption", (AbstractFrame[])this.frameOf(layout.elementOptionList()));
        return frame;
    }

    private Frame[] frameOf(List<ElementOption> elementOptions) {
        return (Frame[])elementOptions.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    public Frame frameOf(ElementOption element) {
        if (element.i$(Group.class)) {
            return this.frameOf((Group)element.a$(Group.class));
        }
        if (element.i$(Options.class)) {
            return this.frameOf((Options)element.a$(Options.class));
        }
        return this.frameOf((Option)element.a$(Option.class));
    }

    private Frame frameOf(Options options) {
        Frame frame = new Frame(new String[]{"elementOption", "options"}).addSlot("box", new String[]{this.box}).addSlot("layout", new String[]{((Layout)this.display.a$(Layout.class)).name$()}).addSlot("name", new String[]{options.name$()}).addSlot("path", new String[]{this.pathOf(options.core$())}).addSlot("modelClass", new String[]{options.modelClass()});
        this.render(options.elementRenderer(), frame);
        return frame;
    }

    private Frame frameOf(Group group) {
        Frame frame = new Frame(new String[]{"elementOption", "group"}).addSlot("box", new String[]{this.box}).addSlot("label", new String[]{group.label()}).addSlot("name", new String[]{group.name$()}).addSlot("mode", new Object[]{group.mode()});
        if (!group.optionList().isEmpty()) {
            frame.addSlot("elementOption", (AbstractFrame[])group.optionList().stream().map(this::frameOf).toArray(Frame[]::new));
        }
        if (!group.optionsList().isEmpty()) {
            frame.addSlot("elementOption", (AbstractFrame[])group.optionsList().stream().map(this::frameOf).toArray(Frame[]::new));
        }
        return frame;
    }

    private Frame frameOf(Option option) {
        Frame frame = new Frame(new String[]{"option", "elementOption"}).addSlot("name", new String[]{option.name$()}).addSlot("box", new String[]{this.box});
        ElementRenderer renderer = option.elementRenderer();
        frame.addTypes(new String[]{renderer instanceof RenderCatalogs ? "catalogs" : "panels"}).addSlot("label", new String[]{option.label()});
        this.render(renderer, frame);
        return frame;
    }

    private void render(ElementRenderer renderer, Frame frame) {
        if (renderer instanceof RenderCatalogs) {
            frame.addSlot("render", new AbstractFrame[]{this.renderCatalogs((RenderCatalogs)renderer.a$(RenderCatalogs.class))});
        } else if (renderer instanceof RenderPanels) {
            frame.addSlot("render", new AbstractFrame[]{this.renderPanels((RenderPanels)renderer.a$(RenderPanels.class))});
        } else if (renderer instanceof RenderObjects) {
            frame.addSlot("render", new AbstractFrame[]{this.renderObjects((RenderObjects)renderer.a$(RenderObjects.class))});
        } else if (renderer instanceof RenderDisplay) {
            frame.addSlot("render", new AbstractFrame[]{this.renderDisplay((RenderDisplay)renderer.a$(RenderDisplay.class))});
        }
    }

    private Frame renderCatalogs(RenderCatalogs render) {
        Frame renderFrame = new Frame(new String[]{"render", "catalogs"}).addSlot("box", new String[]{this.box}).addSlot("catalog", (String[])render.catalogs().stream().map(Layer::name$).toArray(String[]::new));
        if (render.filtered()) {
            renderFrame.addSlot("filtered", new String[]{""});
            renderFrame.addSlot("layout", new String[]{((Layout)this.display.a$(Layout.class)).name$()}).addSlot("path", new String[]{this.pathOf(render.core$().owner())});
        }
        return renderFrame;
    }

    private Frame renderPanels(RenderPanels render) {
        Frame renderFrame = new Frame(new String[]{"render", "panels"}).addSlot("box", new String[]{this.box}).addSlot("panel", (String[])render.panels().stream().map(Layer::name$).toArray(String[]::new));
        if (render.withObject().equals((Object)RenderPanels.WithObject.withObject)) {
            renderFrame.addSlot("layout", new String[]{((Layout)this.display.a$(Layout.class)).name$()}).addSlot("path", new String[]{this.pathOf(render.core$().owner())});
        }
        return renderFrame;
    }

    private Frame renderObjects(RenderObjects render) {
        Frame frame = new Frame(new String[]{"render", "objects"}).addSlot("box", new String[]{this.box}).addSlot("panel", new String[]{render.panel().name$()});
        frame.addSlot("layout", new String[]{((Layout)this.display.a$(Layout.class)).name$()}).addSlot("path", new String[]{this.pathOf(render.core$().owner())});
        return frame;
    }

    private Frame renderDisplay(RenderDisplay render) {
        return new Frame(new String[]{"render", "display"}).addSlot("box", new String[]{this.box}).addSlot("layout", new String[]{((Layout)this.display.a$(Layout.class)).name$()}).addSlot("path", new String[]{this.pathOf(render.core$().owner())}).addSlot("display", new String[]{render.display()});
    }

    private String pathOf(Node node) {
        String qn = "";
        Node parent = node;
        while (!parent.equals(this.display.core$())) {
            qn = StringFormatter.firstUpperCase().format((Object)parent.name()).toString() + (qn.isEmpty() ? "" : ".") + qn;
            parent = parent.owner();
        }
        return qn;
    }

    @Override
    protected Template template() {
        return LayoutRenderer.customize(AbstractLayoutTemplate.create());
    }

    @Override
    protected Template srcTemplate() {
        return LayoutRenderer.customize(LayoutTemplate.create());
    }

    @Override
    void writeSrc(Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)this.display.name$());
        File sourceFile = Commons.javaFile(new File(this.src, "displays"), newDisplay);
        if (!sourceFile.exists()) {
            Commons.writeFrame(new File(this.src, "displays"), newDisplay, this.srcTemplate().format((Object)frame));
        } else {
            new LayoutUpdater(sourceFile, (Layout)this.display.a$(Layout.class), this.project, this.packageName, this.box).update();
        }
    }
}

