/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui;

import com.intellij.openapi.module.Module;
import com.intellij.util.io.ZipUtil;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.ui.ArtifactTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.PageTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.WidgetsTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.mold.MoldFrameBuilder;
import io.intino.konos.builder.codegeneration.accessor.ui.mold.MoldLayoutTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.mold.MoldTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.widget.DialogWidgetTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.widget.WidgetNotifierTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.widget.WidgetPathsTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.widget.WidgetRequesterTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.widget.WidgetTemplate;
import io.intino.konos.model.graph.Activity;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Layout;
import io.intino.konos.model.graph.Mold;
import io.intino.konos.model.graph.TemporalCatalog;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.magritte.Layer;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;
import org.slf4j.LoggerFactory;
import sun.net.www.protocol.file.FileURLConnection;

public class ActivityAccessorRenderer {
    private static final String SRC_DIRECTORY = "src";
    private static final String ARTIFACT_LEGIO = "artifact.legio";
    private Module appModule;
    private final File genDirectory;
    private final Activity activity;
    private String parent;

    ActivityAccessorRenderer(Module appModule, Module webModule, Activity activity, String parent) {
        this.appModule = appModule;
        this.genDirectory = this.rootDirectory(webModule);
        this.activity = activity;
        this.parent = parent;
    }

    public ActivityAccessorRenderer(File rootDirectory, Activity activity) {
        this.genDirectory = rootDirectory;
        this.activity = activity;
    }

    boolean createConfigurationFile() {
        Configuration configuration = TaraUtil.configurationOf((Module)this.appModule);
        Frame frame = new Frame(new String[0]);
        frame.addTypes(new String[]{"artifact", "legio"});
        frame.addSlot("groupID", new String[]{configuration.groupId()});
        frame.addSlot("artifactID", new String[]{configuration.artifactId()});
        frame.addSlot("version", new String[]{configuration.version()});
        Map<String, List<String>> repositories = this.reduce(configuration.releaseRepositories());
        for (String id : repositories.keySet()) {
            Frame repoFrame = new Frame(new String[0]).addTypes(new String[]{"repository", "release"}).addSlot("id", new String[]{id});
            for (String url : repositories.get(id)) {
                repoFrame.addSlot("url", new String[]{url});
            }
            frame.addSlot("repository", new AbstractFrame[]{repoFrame});
        }
        File file = new File(this.genDirectory, ARTIFACT_LEGIO);
        if (!file.exists()) {
            try {
                return Files.write(file.toPath(), ArtifactTemplate.create().format((Object)frame).getBytes(), new OpenOption[0]).toFile().exists();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private Map<String, List<String>> reduce(Map<String, String> map) {
        HashMap<String, List<String>> reduced = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!reduced.containsKey(entry.getValue())) {
                reduced.put(entry.getValue(), new ArrayList());
            }
            ((List)reduced.get(entry.getValue())).add(entry.getKey());
        }
        return reduced;
    }

    public void execute() {
        try {
            this.createStaticFiles();
            this.createWidgets();
            this.createPages();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createPages() throws IOException {
        for (Activity.AbstractPage page : this.activity.abstractPageList()) {
            Path pagePath = new File(this.genDirectory, SRC_DIRECTORY + File.separator + page.name$() + ".html").toPath();
            if (Files.exists(pagePath, new LinkOption[0])) continue;
            Files.write(pagePath, PageTemplate.create().format((Object)this.pageFrame(page)).getBytes(), new OpenOption[0]);
        }
    }

    private Frame pageFrame(Activity.AbstractPage page) {
        String usesDisplay = Formatters.firstUpperCase(page.uses().name$()) + (page.uses().i$(Dialog.class) ? Dialog.class.getSimpleName() : Display.class.getSimpleName());
        return new Frame(new String[0]).addTypes(new String[]{"page"}).addSlot("usesDisplay", new String[]{usesDisplay}).addSlot("uses", new String[]{page.uses().name$()}).addSlot("name", new String[]{page.name$()});
    }

    private void createWidgets() throws IOException {
        Frame widgets = new Frame(new String[0]).addTypes(new String[]{"widgets"});
        for (Component component : KonosGraph.componentsOf(this.activity)) {
            if (component.i$(Mold.class)) {
                this.createMold((Mold)component.a$(Mold.class));
            }
            if (component.i$(Display.class) && !component.i$(Mold.class)) {
                this.createDisplay((Display)component.a$(Display.class));
            }
            if (component.i$(Dialog.class)) {
                this.createDialog((Dialog)component.a$(Dialog.class));
            }
            widgets.addSlot("widget", new String[]{component.name$()});
        }
        Files.write(new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + "widgets.html").toPath(), Formatters.customize(WidgetsTemplate.create()).format((Object)widgets).getBytes(), new OpenOption[0]);
    }

    private void createDisplay(Display component) throws IOException {
        this.createNotifier(component);
        this.createRequester(component);
        this.createDisplayWidget(component);
    }

    private void createMold(Mold mold) throws IOException {
        Frame frame = this.frameOf(mold);
        this.createMoldLayout(mold.name$(), frame);
        this.createMold(mold.name$(), frame);
    }

    private Frame frameOf(Mold mold) {
        return new MoldFrameBuilder(this.activity, mold).build();
    }

    private void createMoldLayout(String name, Frame frame) throws IOException {
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + name.toLowerCase() + File.separator + Formatters.camelCaseToSnakeCase().format((Object)name) + "-layout.html");
        file.getParentFile().mkdirs();
        Files.write(file.toPath(), Formatters.customize(MoldLayoutTemplate.create()).format((Object)frame).getBytes(), new OpenOption[0]);
    }

    private void createMold(String name, Frame frame) throws IOException {
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + Formatters.camelCaseToSnakeCase().format((Object)name) + ".html");
        if (!file.exists()) {
            Files.write(file.toPath(), Formatters.customize(MoldTemplate.create()).format((Object)frame).getBytes(), new OpenOption[0]);
        }
    }

    private void createDisplayWidget(Display display) throws IOException {
        List<Display.Request> requests;
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"widget"}).addSlot("name", new String[]{display.name$()}).addSlot("innerDisplay", (String[])display.displays().stream().map(Layer::name$).toArray(String[]::new));
        if (display.parentDisplay() != null) {
            frame.addSlot("parent", new AbstractFrame[]{new Frame(new String[0]).addSlot("value", new String[]{display.parentDisplay()}).addSlot("dsl", new String[]{this.parent.substring(this.parent.lastIndexOf(".") + 1)})});
        }
        boolean prototype = this.isPrototype(display);
        String type = this.typeOf(display);
        frame.addSlot("attached", new AbstractFrame[]{new Frame(new String[]{prototype ? "prototype" : "display"}).addSlot("widget", new String[]{display.name$()}).addSlot("type", new String[]{type})});
        if (prototype) {
            frame.addSlot("imports", new AbstractFrame[]{new Frame(new String[0]).addSlot("type", new String[]{type})});
            frame.addSlot("type", new String[]{type});
        }
        if (!(requests = display.requestList().stream().filter(r -> r.registerPath() != null).collect(Collectors.toList())).isEmpty()) {
            frame.addSlot("path", new AbstractFrame[]{new Frame(new String[]{"path"}).addSlot("name", new String[]{display.name$()})});
            this.writeWidgetPaths(display, requests);
        }
        this.writeWidget(display, frame);
    }

    private String typeOf(Display display) {
        String type = ((Object)((Object)display)).getClass().getSimpleName();
        if (type.equalsIgnoreCase("layout")) {
            return this.layoutType(display);
        }
        if (type.equalsIgnoreCase("temporalCatalog")) {
            return "temporal" + ((TemporalCatalog)display.a$(TemporalCatalog.class)).type().name() + "Catalog";
        }
        return type;
    }

    @NotNull
    private String layoutType(Display display) {
        String string = ((Layout)display.a$(Layout.class)).mode().name() + "-layout";
        if (string == null) {
            ActivityAccessorRenderer.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void writeWidgetPaths(Display display, List<Display.Request> requests) throws IOException {
        Frame frame = new Frame(new String[]{"paths"}).addSlot("name", new String[]{display.name$()});
        for (Display.Request request : requests) {
            frame.addSlot("path", new AbstractFrame[]{this.pathFrame(request)});
        }
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + display.name$().toLowerCase() + File.separator + StringHelper.camelCaseToSnakeCase((String)display.name$()).toLowerCase() + "-paths.html");
        if (!file.exists()) {
            Files.write(file.toPath(), Formatters.customize(WidgetPathsTemplate.create()).format((Object)frame).getBytes(), new OpenOption[0]);
        }
    }

    private Frame pathFrame(Display.Request r) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"path"}).addSlot("request", new String[]{r.name$()});
        if (r.isType()) {
            frame.addTypes(new String[]{"parameter"});
        }
        frame.addSlot("path", new String[]{r.registerPath().page().paths().get(0)});
        return frame;
    }

    private void writeWidget(Display display, Frame frame) throws IOException {
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + StringHelper.camelCaseToSnakeCase((String)display.name$()).toLowerCase() + ".html");
        if (!file.exists()) {
            Files.write(file.toPath(), Formatters.customize(WidgetTemplate.create()).format((Object)frame).getBytes(), new OpenOption[0]);
        }
    }

    private boolean isPrototype(Display display) {
        return !((Object)((Object)display)).getClass().getSimpleName().equals(Display.class.getSimpleName());
    }

    private void createDialog(Dialog dialog) throws IOException {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"dialog"}).addSlot("name", new String[]{dialog.name$()});
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + StringHelper.camelCaseToSnakeCase((String)dialog.name$()).toLowerCase() + ".html");
        if (!file.exists()) {
            Files.write(file.toPath(), Formatters.customize(DialogWidgetTemplate.create()).format((Object)frame).getBytes(), new OpenOption[0]);
        }
    }

    private void createRequester(Display display) throws IOException {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"widget"}).addSlot("name", new String[]{display.name$()}).addSlot("request", (AbstractFrame[])((Frame[])display.requestList().stream().map(this::frameOf).toArray(Frame[]::new)));
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + display.name$().toLowerCase() + File.separator + "requester.js");
        file.getParentFile().mkdirs();
        Files.write(file.toPath(), Formatters.customize(WidgetRequesterTemplate.create()).format((Object)frame).getBytes(), new OpenOption[0]);
    }

    private void createNotifier(Display display) throws IOException {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"widget"}).addSlot("name", new String[]{display.name$()}).addSlot("notification", (AbstractFrame[])((Frame[])display.notificationList().stream().map(this::frameOf).toArray(Frame[]::new)));
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + display.name$().toLowerCase() + File.separator + "notifier-listener.js");
        file.getParentFile().mkdirs();
        Files.write(file.toPath(), Formatters.customize(WidgetNotifierTemplate.create()).format((Object)frame).getBytes(), new OpenOption[0]);
    }

    private Frame frameOf(Display.Notification n) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"notification"}).addSlot("name", new String[]{n.name$()}).addSlot("to", new String[]{n.to().name()});
        if (n.asType() != null) {
            frame.addSlot("parameter", new String[]{""});
        }
        return frame;
    }

    private Frame frameOf(Display.Request r) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"request"}).addSlot("name", new String[]{r.name$()}).addSlot("widget", new String[]{r.core$().owner().name()});
        if (r.isType()) {
            frame.addTypes(new String[]{"parameter"});
        }
        if (r.registerPath() != null) {
            frame.addTypes(new String[]{"registerPath"});
        }
        frame.addSlot("method", new String[]{r.responseType().name()});
        return frame;
    }

    private void createStaticFiles() throws IOException {
        File src = new File(this.genDirectory, SRC_DIRECTORY);
        src.mkdirs();
        File file = new File(src, "ui.zip");
        this.copyResourcesRecursively(this.getClass().getResource("/ui/ui.zip"), file);
        ZipUtil.extract((File)file, (File)src, null, (boolean)false);
        file.delete();
        new File(src, "images").mkdirs();
        new File(src, "widgets").mkdirs();
    }

    private File rootDirectory(Module webModule) {
        return new File(webModule.getModuleFilePath()).getParentFile();
    }

    private void copyResourcesRecursively(URL originUrl, File destination) {
        block4: {
            try {
                URLConnection urlConnection = originUrl.openConnection();
                if (urlConnection instanceof JarURLConnection) {
                    this.copyJarResourcesRecursively(destination, (JarURLConnection)urlConnection);
                    break block4;
                }
                if (urlConnection instanceof FileURLConnection) {
                    FileUtils.copyFile((File)new File(originUrl.getPath()), (File)destination);
                    break block4;
                }
                throw new Exception("URLConnection[" + urlConnection.getClass().getSimpleName() + "] is not a recognized/implemented connection type.");
            }
            catch (Exception e) {
                LoggerFactory.getLogger((String)"ROOT").error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void copyJarResourcesRecursively(File destination, JarURLConnection jarConnection) throws IOException {
        JarFile jarFile = jarConnection.getJarFile();
        Enumeration<JarEntry> list = jarFile.entries();
        while (list.hasMoreElements()) {
            JarEntry entry = list.nextElement();
            if (!entry.getName().startsWith(jarConnection.getEntryName())) continue;
            String fileName = StringUtils.removeStart((String)entry.getName(), (String)jarConnection.getEntryName());
            if (!entry.isDirectory()) {
                InputStream entryInputStream = jarFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileUtils.copyInputStreamToFile((InputStream)entryInputStream, (File)new File(destination, fileName));
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (entryInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            entryInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    entryInputStream.close();
                    continue;
                }
            }
            new File(destination, fileName).exists();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/accessor/ui/ActivityAccessorRenderer", "layoutType"));
    }
}

