/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.CatalogView;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.DisplayView;
import io.intino.konos.model.graph.GridView;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.ListView;
import io.intino.konos.model.graph.MagazineView;
import io.intino.konos.model.graph.MapView;
import io.intino.konos.model.graph.Mold;
import io.intino.konos.model.graph.Panel;
import io.intino.konos.model.graph.Toolbar;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Catalog
extends Display
implements Terminal {
    protected String modelClass;
    protected Toolbar toolbar;
    protected Events events;
    protected Views views;
    protected Arrangement arrangement;

    public Catalog(Node node) {
        super(node);
    }

    public String modelClass() {
        return this.modelClass;
    }

    public Catalog modelClass(String value) {
        this.modelClass = value;
        return this;
    }

    public Toolbar toolbar() {
        return this.toolbar;
    }

    public Events events() {
        return this.events;
    }

    public Views views() {
        return this.views;
    }

    public Arrangement arrangement() {
        return this.arrangement;
    }

    public Catalog toolbar(Toolbar value) {
        this.toolbar = value;
        return this;
    }

    public Catalog events(Events value) {
        this.events = value;
        return this;
    }

    public Catalog views(Views value) {
        this.views = value;
        return this;
    }

    public Catalog arrangement(Arrangement value) {
        this.arrangement = value;
        return this;
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.toolbar != null) {
            components.add(this.toolbar.core$());
        }
        if (this.events != null) {
            components.add(this.events.core$());
        }
        if (this.views != null) {
            components.add(this.views.core$());
        }
        if (this.arrangement != null) {
            components.add(this.arrangement.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("modelClass", new ArrayList<String>(Collections.singletonList(this.modelClass)));
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Toolbar")) {
            this.toolbar = (Toolbar)node.as(Toolbar.class);
        }
        if (node.is("Catalog$Events")) {
            this.events = (Events)node.as(Events.class);
        }
        if (node.is("Catalog$Views")) {
            this.views = (Views)node.as(Views.class);
        }
        if (node.is("Catalog$Arrangement")) {
            this.arrangement = (Arrangement)node.as(Arrangement.class);
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Toolbar")) {
            this.toolbar = null;
        }
        if (node.is("Catalog$Events")) {
            this.events = null;
        }
        if (node.is("Catalog$Views")) {
            this.views = null;
        }
        if (node.is("Catalog$Arrangement")) {
            this.arrangement = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("modelClass")) {
            this.modelClass = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("modelClass")) {
            this.modelClass = (String)values.get(0);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Arrangement
    extends Layer
    implements Terminal {
        protected Histograms histograms;
        protected List<Grouping> groupingList = new ArrayList<Grouping>();
        protected List<Sorting> sortingList = new ArrayList<Sorting>();

        public Arrangement(Node node) {
            super(node);
        }

        public Histograms histograms() {
            return this.histograms;
        }

        public Arrangement histograms(Histograms value) {
            this.histograms = value;
            return this;
        }

        public List<Grouping> groupingList() {
            return Collections.unmodifiableList(this.groupingList);
        }

        public Grouping grouping(int index) {
            return this.groupingList.get(index);
        }

        public List<Grouping> groupingList(Predicate<Grouping> predicate) {
            return this.groupingList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Sorting> sortingList() {
            return Collections.unmodifiableList(this.sortingList);
        }

        public Sorting sorting(int index) {
            return this.sortingList.get(index);
        }

        public List<Sorting> sortingList(Predicate<Sorting> predicate) {
            return this.sortingList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Grouping>(this.groupingList).forEach(c -> components.add(c.core$()));
            new ArrayList<Sorting>(this.sortingList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("histograms", new ArrayList<Histograms>(Collections.singletonList(this.histograms)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Catalog$Arrangement$Grouping")) {
                this.groupingList.add((Grouping)node.as(Grouping.class));
            }
            if (node.is("Catalog$Arrangement$Sorting")) {
                this.sortingList.add((Sorting)node.as(Sorting.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Catalog$Arrangement$Grouping")) {
                this.groupingList.remove(node.as(Grouping.class));
            }
            if (node.is("Catalog$Arrangement$Sorting")) {
                this.sortingList.remove(node.as(Sorting.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("histograms")) {
                this.histograms = (Histograms)((Object)WordLoader.load(values, Histograms.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("histograms")) {
                this.histograms = (Histograms)((Object)values.get(0));
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Sorting
        extends Layer
        implements Terminal {
            protected String label;
            protected boolean visible;

            public Sorting(Node node) {
                super(node);
            }

            public String label() {
                return this.label;
            }

            public boolean visible() {
                return this.visible;
            }

            public Sorting label(String value) {
                this.label = value;
                return this;
            }

            public Sorting visible(boolean value) {
                this.visible = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
                map.put("visible", new ArrayList<Boolean>(Collections.singletonList(this.visible)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("visible")) {
                    this.visible = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)values.get(0);
                } else if (name.equalsIgnoreCase("visible")) {
                    this.visible = (Boolean)values.get(0);
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Grouping
        extends Layer
        implements Terminal {
            protected String label;
            protected Histogram histogram;

            public Grouping(Node node) {
                super(node);
            }

            public String label() {
                return this.label;
            }

            public Histogram histogram() {
                return this.histogram;
            }

            public Grouping label(String value) {
                this.label = value;
                return this;
            }

            public Grouping histogram(Histogram value) {
                this.histogram = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
                map.put("histogram", new ArrayList<Histogram>(Collections.singletonList(this.histogram)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("histogram")) {
                    this.histogram = (Histogram)((Object)WordLoader.load(values, Histogram.class, (Layer)this).get(0));
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)values.get(0);
                } else if (name.equalsIgnoreCase("histogram")) {
                    this.histogram = (Histogram)((Object)values.get(0));
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static enum Histogram {
                Percentage,
                Absolute;

            }
        }

        public class Clear {
            public void grouping(Predicate<Grouping> filter) {
                new ArrayList<Grouping>(Arrangement.this.groupingList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void sorting(Predicate<Sorting> filter) {
                new ArrayList<Sorting>(Arrangement.this.sortingList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Grouping grouping(String label) {
                Grouping newElement = (Grouping)Arrangement.this.core$().graph().concept(Grouping.class).createNode(this.name, Arrangement.this.core$()).as(Grouping.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public Sorting sorting(String label) {
                Sorting newElement = (Sorting)Arrangement.this.core$().graph().concept(Sorting.class).createNode(this.name, Arrangement.this.core$()).as(Sorting.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }
        }

        public static enum Histograms {
            EnabledAndVisible,
            EnabledButHidden,
            Disabled;

        }
    }

    public static class Views
    extends Layer
    implements Terminal {
        protected List<CatalogView> catalogViewList = new ArrayList<CatalogView>();
        protected DisplayView displayView;

        public Views(Node node) {
            super(node);
        }

        public List<CatalogView> catalogViewList() {
            return Collections.unmodifiableList(this.catalogViewList);
        }

        public CatalogView catalogView(int index) {
            return this.catalogViewList.get(index);
        }

        public List<CatalogView> catalogViewList(Predicate<CatalogView> predicate) {
            return this.catalogViewList().stream().filter(predicate).collect(Collectors.toList());
        }

        public DisplayView displayView() {
            return this.displayView;
        }

        public Views displayView(DisplayView value) {
            this.displayView = value;
            return this;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            new ArrayList<CatalogView>(this.catalogViewList).forEach(c -> components.add(c.core$()));
            if (this.displayView != null) {
                components.add(this.displayView.core$());
            }
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("CatalogView")) {
                this.catalogViewList.add((CatalogView)node.as(CatalogView.class));
            }
            if (node.is("DisplayView")) {
                this.displayView = (DisplayView)node.as(DisplayView.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("CatalogView")) {
                this.catalogViewList.remove(node.as(CatalogView.class));
            }
            if (node.is("DisplayView")) {
                this.displayView = null;
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public DisplayView displayView(String label, String display) {
                DisplayView newElement = (DisplayView)Views.this.core$().graph().concept(DisplayView.class).createNode(this.name, Views.this.core$()).as(DisplayView.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                newElement.core$().set((Layer)newElement, "display", Collections.singletonList(display));
                return newElement;
            }

            public MapView mapView(String label, Mold mold) {
                MapView newElement = (MapView)Views.this.core$().graph().concept(MapView.class).createNode(this.name, Views.this.core$()).as(MapView.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
                return newElement;
            }

            public ListView listView(String label, Mold mold) {
                ListView newElement = (ListView)Views.this.core$().graph().concept(ListView.class).createNode(this.name, Views.this.core$()).as(ListView.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
                return newElement;
            }

            public GridView gridView(String label, Mold mold) {
                GridView newElement = (GridView)Views.this.core$().graph().concept(GridView.class).createNode(this.name, Views.this.core$()).as(GridView.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
                return newElement;
            }

            public MagazineView magazineView(String label, Mold mold) {
                MagazineView newElement = (MagazineView)Views.this.core$().graph().concept(MagazineView.class).createNode(this.name, Views.this.core$()).as(MagazineView.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
                return newElement;
            }
        }
    }

    public static class Events
    extends Layer
    implements Terminal {
        protected OnClickRecord onClickRecord;

        public Events(Node node) {
            super(node);
        }

        public OnClickRecord onClickRecord() {
            return this.onClickRecord;
        }

        public Events onClickRecord(OnClickRecord value) {
            this.onClickRecord = value;
            return this;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.onClickRecord != null) {
                components.add(this.onClickRecord.core$());
            }
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Catalog$Events$OnClickRecord")) {
                this.onClickRecord = (OnClickRecord)node.as(OnClickRecord.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Catalog$Events$OnClickRecord")) {
                this.onClickRecord = null;
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class OnClickRecord
        extends Layer
        implements Terminal {
            protected CatalogEvent catalogEvent;
            protected OpenDialog openDialog;
            protected OpenPanel openPanel;
            protected OpenCatalog openCatalog;

            public OnClickRecord(Node node) {
                super(node);
            }

            public CatalogEvent catalogEvent() {
                return this.catalogEvent;
            }

            public OpenDialog openDialog() {
                return this.openDialog;
            }

            public OpenPanel openPanel() {
                return this.openPanel;
            }

            public OpenCatalog openCatalog() {
                return this.openCatalog;
            }

            public OnClickRecord catalogEvent(CatalogEvent value) {
                this.catalogEvent = value;
                return this;
            }

            public OnClickRecord openDialog(OpenDialog value) {
                this.openDialog = value;
                return this;
            }

            public OnClickRecord openPanel(OpenPanel value) {
                this.openPanel = value;
                return this;
            }

            public OnClickRecord openCatalog(OpenCatalog value) {
                this.openCatalog = value;
                return this;
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                if (this.catalogEvent != null) {
                    components.add(this.catalogEvent.core$());
                }
                if (this.openDialog != null) {
                    components.add(this.openDialog.core$());
                }
                if (this.openPanel != null) {
                    components.add(this.openPanel.core$());
                }
                if (this.openCatalog != null) {
                    components.add(this.openCatalog.core$());
                }
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Catalog$Events$OnClickRecord$CatalogEvent")) {
                    this.catalogEvent = (CatalogEvent)node.as(CatalogEvent.class);
                }
                if (node.is("Catalog$Events$OnClickRecord$OpenDialog")) {
                    this.openDialog = (OpenDialog)node.as(OpenDialog.class);
                }
                if (node.is("Catalog$Events$OnClickRecord$OpenPanel")) {
                    this.openPanel = (OpenPanel)node.as(OpenPanel.class);
                }
                if (node.is("Catalog$Events$OnClickRecord$OpenCatalog")) {
                    this.openCatalog = (OpenCatalog)node.as(OpenCatalog.class);
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Catalog$Events$OnClickRecord$CatalogEvent")) {
                    this.catalogEvent = null;
                }
                if (node.is("Catalog$Events$OnClickRecord$OpenDialog")) {
                    this.openDialog = null;
                }
                if (node.is("Catalog$Events$OnClickRecord$OpenPanel")) {
                    this.openPanel = null;
                }
                if (node.is("Catalog$Events$OnClickRecord$OpenCatalog")) {
                    this.openCatalog = null;
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class OpenCatalog
            extends CatalogEvent
            implements Terminal {
                protected Catalog catalog;
                protected boolean filtered;
                protected boolean openItem;

                public OpenCatalog(Node node) {
                    super(node);
                }

                public Catalog catalog() {
                    return this.catalog;
                }

                public boolean filtered() {
                    return this.filtered;
                }

                public boolean openItem() {
                    return this.openItem;
                }

                public OpenCatalog catalog(Catalog value) {
                    this.catalog = value;
                    return this;
                }

                public OpenCatalog filtered(boolean value) {
                    this.filtered = value;
                    return this;
                }

                public OpenCatalog openItem(boolean value) {
                    this.openItem = value;
                    return this;
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap(super.variables$());
                    map.put("catalog", this.catalog != null ? new ArrayList<Catalog>(Collections.singletonList(this.catalog)) : Collections.emptyList());
                    map.put("filtered", new ArrayList<Boolean>(Collections.singletonList(this.filtered)));
                    map.put("openItem", new ArrayList<Boolean>(Collections.singletonList(this.openItem)));
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("catalog")) {
                        this.catalog = (Catalog)((Object)NodeLoader.load(values, Catalog.class, (Layer)this).get(0));
                    } else if (name.equalsIgnoreCase("filtered")) {
                        this.filtered = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("openItem")) {
                        this.openItem = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                    }
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("catalog")) {
                        this.catalog = values.get(0) != null ? (Catalog)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Catalog.class) : null;
                    } else if (name.equalsIgnoreCase("filtered")) {
                        this.filtered = (Boolean)values.get(0);
                    } else if (name.equalsIgnoreCase("openItem")) {
                        this.openItem = (Boolean)values.get(0);
                    }
                }

                @Override
                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public static class OpenPanel
            extends CatalogEvent
            implements Terminal {
                protected Panel panel;
                protected boolean hasBreadcrumbs;

                public OpenPanel(Node node) {
                    super(node);
                }

                public Panel panel() {
                    return this.panel;
                }

                public boolean hasBreadcrumbs() {
                    return this.hasBreadcrumbs;
                }

                public OpenPanel panel(Panel value) {
                    this.panel = value;
                    return this;
                }

                public OpenPanel hasBreadcrumbs(boolean value) {
                    this.hasBreadcrumbs = value;
                    return this;
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap(super.variables$());
                    map.put("panel", this.panel != null ? new ArrayList<Panel>(Collections.singletonList(this.panel)) : Collections.emptyList());
                    map.put("hasBreadcrumbs", new ArrayList<Boolean>(Collections.singletonList(this.hasBreadcrumbs)));
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("panel")) {
                        this.panel = (Panel)((Object)NodeLoader.load(values, Panel.class, (Layer)this).get(0));
                    } else if (name.equalsIgnoreCase("hasBreadcrumbs")) {
                        this.hasBreadcrumbs = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                    }
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("panel")) {
                        this.panel = values.get(0) != null ? (Panel)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Panel.class) : null;
                    } else if (name.equalsIgnoreCase("hasBreadcrumbs")) {
                        this.hasBreadcrumbs = (Boolean)values.get(0);
                    }
                }

                @Override
                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public static class OpenDialog
            extends CatalogEvent
            implements Terminal {
                protected Dialog dialog;
                protected int width;
                protected int height;

                public OpenDialog(Node node) {
                    super(node);
                }

                public Dialog dialog() {
                    return this.dialog;
                }

                public int width() {
                    return this.width;
                }

                public int height() {
                    return this.height;
                }

                public OpenDialog dialog(Dialog value) {
                    this.dialog = value;
                    return this;
                }

                public OpenDialog width(int value) {
                    this.width = value;
                    return this;
                }

                public OpenDialog height(int value) {
                    this.height = value;
                    return this;
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap(super.variables$());
                    map.put("dialog", this.dialog != null ? new ArrayList<Dialog>(Collections.singletonList(this.dialog)) : Collections.emptyList());
                    map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
                    map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("dialog")) {
                        this.dialog = (Dialog)((Object)NodeLoader.load(values, Dialog.class, (Layer)this).get(0));
                    } else if (name.equalsIgnoreCase("width")) {
                        this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("height")) {
                        this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                    }
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("dialog")) {
                        this.dialog = values.get(0) != null ? (Dialog)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Dialog.class) : null;
                    } else if (name.equalsIgnoreCase("width")) {
                        this.width = (Integer)values.get(0);
                    } else if (name.equalsIgnoreCase("height")) {
                        this.height = (Integer)values.get(0);
                    }
                }

                @Override
                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public static abstract class CatalogEvent
            extends Layer
            implements Terminal {
                public CatalogEvent(Node node) {
                    super(node);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }
                }
            }

            public class Clear {
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public OpenDialog openDialog(Dialog dialog) {
                    OpenDialog newElement = (OpenDialog)OnClickRecord.this.core$().graph().concept(OpenDialog.class).createNode(this.name, OnClickRecord.this.core$()).as(OpenDialog.class);
                    newElement.core$().set((Layer)newElement, "dialog", Collections.singletonList(dialog));
                    return newElement;
                }

                public OpenPanel openPanel(Panel panel) {
                    OpenPanel newElement = (OpenPanel)OnClickRecord.this.core$().graph().concept(OpenPanel.class).createNode(this.name, OnClickRecord.this.core$()).as(OpenPanel.class);
                    newElement.core$().set((Layer)newElement, "panel", Collections.singletonList(panel));
                    return newElement;
                }

                public OpenCatalog openCatalog(Catalog catalog) {
                    OpenCatalog newElement = (OpenCatalog)OnClickRecord.this.core$().graph().concept(OpenCatalog.class).createNode(this.name, OnClickRecord.this.core$()).as(OpenCatalog.class);
                    newElement.core$().set((Layer)newElement, "catalog", Collections.singletonList(catalog));
                    return newElement;
                }
            }
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public OnClickRecord onClickRecord() {
                OnClickRecord newElement = (OnClickRecord)Events.this.core$().graph().concept(OnClickRecord.class).createNode(this.name, Events.this.core$()).as(OnClickRecord.class);
                return newElement;
            }
        }
    }

    public class Clear
    extends Display.Clear {
    }

    public class Create
    extends Display.Create {
        public Create(String name) {
            super(name);
        }

        public Toolbar toolbar() {
            Toolbar newElement = (Toolbar)Catalog.this.core$().graph().concept(Toolbar.class).createNode(this.name, Catalog.this.core$()).as(Toolbar.class);
            return newElement;
        }

        public Events events() {
            Events newElement = (Events)Catalog.this.core$().graph().concept(Events.class).createNode(this.name, Catalog.this.core$()).as(Events.class);
            return newElement;
        }

        public Views views() {
            Views newElement = (Views)Catalog.this.core$().graph().concept(Views.class).createNode(this.name, Catalog.this.core$()).as(Views.class);
            return newElement;
        }

        public Arrangement arrangement() {
            Arrangement newElement = (Arrangement)Catalog.this.core$().graph().concept(Arrangement.class).createNode(this.name, Catalog.this.core$()).as(Arrangement.class);
            return newElement;
        }
    }
}

