/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DataLake
extends Layer
implements Terminal {
    protected String domain;
    protected String clientID;
    protected List<Tank> tankList = new ArrayList<Tank>();

    public DataLake(Node node) {
        super(node);
    }

    public String domain() {
        return this.domain;
    }

    public String clientID() {
        return this.clientID;
    }

    public DataLake domain(String value) {
        this.domain = value;
        return this;
    }

    public DataLake clientID(String value) {
        this.clientID = value;
        return this;
    }

    public List<Tank> tankList() {
        return Collections.unmodifiableList(this.tankList);
    }

    public Tank tank(int index) {
        return this.tankList.get(index);
    }

    public List<Tank> tankList(Predicate<Tank> predicate) {
        return this.tankList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Tank>(this.tankList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("domain", new ArrayList<String>(Collections.singletonList(this.domain)));
        map.put("clientID", new ArrayList<String>(Collections.singletonList(this.clientID)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("DataLake$Tank")) {
            this.tankList.add((Tank)node.as(Tank.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("DataLake$Tank")) {
            this.tankList.remove(node.as(Tank.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("domain")) {
            this.domain = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("clientID")) {
            this.clientID = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("domain")) {
            this.domain = (String)values.get(0);
        } else if (name.equalsIgnoreCase("clientID")) {
            this.clientID = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Tank
    extends Layer
    implements Terminal {
        protected String topic;

        public Tank(Node node) {
            super(node);
        }

        public String topic() {
            return this.topic;
        }

        public Tank topic(String value) {
            this.topic = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("topic", new ArrayList<String>(Collections.singletonList(this.topic)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("topic")) {
                this.topic = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("topic")) {
                this.topic = (String)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
        public void tank(Predicate<Tank> filter) {
            new ArrayList<Tank>(DataLake.this.tankList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Tank tank(String topic) {
            Tank newElement = (Tank)DataLake.this.core$().graph().concept(Tank.class).createNode(this.name, DataLake.this.core$()).as(Tank.class);
            newElement.core$().set((Layer)newElement, "topic", Collections.singletonList(topic));
            return newElement;
        }
    }
}

