/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.slackbot;

import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.rules.ExceptionCodes;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SlackBotService
extends Layer
implements Terminal {
    protected List<Notification> notificationList = new ArrayList<Notification>();
    protected List<Request> requestList = new ArrayList<Request>();
    protected Service _service;

    public SlackBotService(Node node) {
        super(node);
    }

    public List<Notification> notificationList() {
        return Collections.unmodifiableList(this.notificationList);
    }

    public Notification notification(int index) {
        return this.notificationList.get(index);
    }

    public List<Notification> notificationList(Predicate<Notification> predicate) {
        return this.notificationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Request> requestList() {
        return Collections.unmodifiableList(this.requestList);
    }

    public Request request(int index) {
        return this.requestList.get(index);
    }

    public List<Request> requestList(Predicate<Request> predicate) {
        return this.requestList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Schema> schemaList() {
        return this._service.schemaList();
    }

    public Schema schemaList(int index) {
        return this._service.schemaList().get(index);
    }

    public List<Exception> exceptionList() {
        return this._service.exceptionList();
    }

    public Exception exceptionList(int index) {
        return this._service.exceptionList().get(index);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Notification>(this.notificationList).forEach(c -> components.add(c.core$()));
        new ArrayList<Request>(this.requestList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("SlackBot#Service$Notification")) {
            this.notificationList.add((Notification)node.as(Notification.class));
        }
        if (node.is("SlackBot#Service$Request")) {
            this.requestList.add((Request)node.as(Request.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("SlackBot#Service$Notification")) {
            this.notificationList.remove(node.as(Notification.class));
        }
        if (node.is("SlackBot#Service$Request")) {
            this.requestList.remove(node.as(Request.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    protected void sync$(Layer layer) {
        super.sync$(layer);
        if (layer instanceof Service) {
            this._service = (Service)layer;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Request
    extends Layer
    implements Terminal {
        protected String description;
        protected ResponseType responseType;
        protected List<Parameter> parameterList = new ArrayList<Parameter>();
        protected List<Request> requestList = new ArrayList<Request>();

        public Request(Node node) {
            super(node);
        }

        public String description() {
            return this.description;
        }

        public ResponseType responseType() {
            return this.responseType;
        }

        public Request description(String value) {
            this.description = value;
            return this;
        }

        public Request responseType(ResponseType value) {
            this.responseType = value;
            return this;
        }

        public List<Parameter> parameterList() {
            return Collections.unmodifiableList(this.parameterList);
        }

        public Parameter parameter(int index) {
            return this.parameterList.get(index);
        }

        public List<Parameter> parameterList(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Request> requestList() {
            return Collections.unmodifiableList(this.requestList);
        }

        public Request request(int index) {
            return this.requestList.get(index);
        }

        public List<Request> requestList(Predicate<Request> predicate) {
            return this.requestList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
            new ArrayList<Request>(this.requestList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
            map.put("responseType", new ArrayList<ResponseType>(Collections.singletonList(this.responseType)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("SlackBot#Service$Request$Parameter")) {
                this.parameterList.add((Parameter)node.as(Parameter.class));
            }
            if (node.is("SlackBot#Service$Request")) {
                this.requestList.add((Request)node.as(Request.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("SlackBot#Service$Request$Parameter")) {
                this.parameterList.remove(node.as(Parameter.class));
            }
            if (node.is("SlackBot#Service$Request")) {
                this.requestList.remove(node.as(Request.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("description")) {
                this.description = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("responseType")) {
                this.responseType = (ResponseType)((Object)WordLoader.load(values, ResponseType.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("description")) {
                this.description = (String)values.get(0);
            } else if (name.equalsIgnoreCase("responseType")) {
                this.responseType = (ResponseType)((Object)values.get(0));
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Parameter
        extends Layer
        implements Terminal {
            protected Type type;
            protected boolean multiple;

            public Parameter(Node node) {
                super(node);
            }

            public Type type() {
                return this.type;
            }

            public boolean multiple() {
                return this.multiple;
            }

            public Parameter type(Type value) {
                this.type = value;
                return this;
            }

            public Parameter multiple(boolean value) {
                this.multiple = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
                map.put("multiple", new ArrayList<Boolean>(Collections.singletonList(this.multiple)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("type")) {
                    this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("multiple")) {
                    this.multiple = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("type")) {
                    this.type = (Type)((Object)values.get(0));
                } else if (name.equalsIgnoreCase("multiple")) {
                    this.multiple = (Boolean)values.get(0);
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static enum Type {
                Boolean,
                String,
                Double,
                Integer;

            }
        }

        public class Clear {
            public void parameter(Predicate<Parameter> filter) {
                new ArrayList<Parameter>(Request.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<Request> filter) {
                new ArrayList<Request>(Request.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Parameter parameter(Parameter.Type type) {
                Parameter newElement = (Parameter)Request.this.core$().graph().concept(Parameter.class).createNode(this.name, Request.this.core$()).as(Parameter.class);
                newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
                return newElement;
            }

            public Request request(String description) {
                Request newElement = (Request)Request.this.core$().graph().concept(Request.class).createNode(this.name, Request.this.core$()).as(Request.class);
                newElement.core$().set((Layer)newElement, "description", Collections.singletonList(description));
                return newElement;
            }
        }

        public static enum ResponseType {
            Text,
            Attachment;

        }
    }

    public static class Notification
    extends Layer
    implements Terminal {
        protected String channel;

        public Notification(Node node) {
            super(node);
        }

        public String channel() {
            return this.channel;
        }

        public Notification channel(String value) {
            this.channel = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("channel", new ArrayList<String>(Collections.singletonList(this.channel)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("channel")) {
                this.channel = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("channel")) {
                this.channel = (String)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
        public void notification(Predicate<Notification> filter) {
            new ArrayList<Notification>(SlackBotService.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void request(Predicate<Request> filter) {
            new ArrayList<Request>(SlackBotService.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void schema(Predicate<Schema> filter) {
            new ArrayList<Schema>(SlackBotService.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void exception(Predicate<Exception> filter) {
            new ArrayList<Exception>(SlackBotService.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Notification notification(String channel) {
            Notification newElement = (Notification)SlackBotService.this.core$().graph().concept(Notification.class).createNode(this.name, SlackBotService.this.core$()).as(Notification.class);
            newElement.core$().set((Layer)newElement, "channel", Collections.singletonList(channel));
            return newElement;
        }

        public Request request(String description) {
            Request newElement = (Request)SlackBotService.this.core$().graph().concept(Request.class).createNode(this.name, SlackBotService.this.core$()).as(Request.class);
            newElement.core$().set((Layer)newElement, "description", Collections.singletonList(description));
            return newElement;
        }

        public Schema schema() {
            Schema newElement = (Schema)SlackBotService.this.core$().graph().concept(Schema.class).createNode(this.name, SlackBotService.this.core$()).as(Schema.class);
            return newElement;
        }

        public Exception exception(ExceptionCodes code) {
            Exception newElement = (Exception)SlackBotService.this.core$().graph().concept(Exception.class).createNode(this.name, SlackBotService.this.core$()).as(Exception.class);
            newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
            return newElement;
        }
    }
}

