/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.ElementOption;
import io.intino.konos.model.graph.Group;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Option;
import io.intino.konos.model.graph.Options;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Layout
extends Display
implements Terminal {
    protected Mode mode;
    protected List<ElementOption> elementOptionList = new ArrayList<ElementOption>();

    public Layout(Node node) {
        super(node);
    }

    public Mode mode() {
        return this.mode;
    }

    public Layout mode(Mode value) {
        this.mode = value;
        return this;
    }

    public List<ElementOption> elementOptionList() {
        return Collections.unmodifiableList(this.elementOptionList);
    }

    public ElementOption elementOption(int index) {
        return this.elementOptionList.get(index);
    }

    public List<ElementOption> elementOptionList(Predicate<ElementOption> predicate) {
        return this.elementOptionList().stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<ElementOption>(this.elementOptionList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("ElementOption")) {
            this.elementOptionList.add((ElementOption)node.as(ElementOption.class));
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("ElementOption")) {
            this.elementOptionList.remove(node.as(ElementOption.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("mode")) {
            this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("mode")) {
            this.mode = (Mode)((Object)values.get(0));
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public class Clear
    extends Display.Clear {
        public void elementOption(Predicate<ElementOption> filter) {
            new ArrayList<ElementOption>(Layout.this.elementOptionList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Display.Create {
        public Create(String name) {
            super(name);
        }

        public ElementOption elementOption() {
            ElementOption newElement = (ElementOption)Layout.this.core$().graph().concept(ElementOption.class).createNode(this.name, Layout.this.core$()).as(ElementOption.class);
            return newElement;
        }

        public Options options(String modelClass) {
            Options newElement = (Options)Layout.this.core$().graph().concept(Options.class).createNode(this.name, Layout.this.core$()).as(Options.class);
            newElement.core$().set((Layer)newElement, "modelClass", Collections.singletonList(modelClass));
            return newElement;
        }

        public Option option(String label) {
            Option newElement = (Option)Layout.this.core$().graph().concept(Option.class).createNode(this.name, Layout.this.core$()).as(Option.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Group group(String label, Group.Mode mode) {
            Group newElement = (Group)Layout.this.core$().graph().concept(Group.class).createNode(this.name, Layout.this.core$()).as(Group.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "mode", Collections.singletonList(mode));
            return newElement;
        }
    }

    public static enum Mode {
        Menu,
        Tab;

    }
}

