/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.resource;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.action.UIActionRenderer;
import io.intino.konos.builder.codegeneration.services.activity.resource.ResourceTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Activity;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class ResourceRenderer {
    private static final String RESOURCES = "resources";
    private final Project project;
    private final File src;
    private final File gen;
    private final String packageName;
    private final String boxName;
    private final List<Activity.AbstractPage> pages;

    public ResourceRenderer(Project project, KonosGraph graph, File src, File gen, String packageName, String boxName) {
        this.project = project;
        this.src = src;
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
        this.pages = graph.core$().find(Activity.AbstractPage.class);
    }

    public void execute() {
        this.pages.forEach(this::processPage);
    }

    private void processPage(Activity.AbstractPage page) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"page"});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("name", new String[]{page.name$()});
        frame.addSlot("box", new String[]{this.boxName});
        frame.addSlot("parameter", (AbstractFrame[])this.parameters(page));
        if (((Activity)page.core$().ownerAs(Activity.class)).googleApiKey() != null) {
            frame.addSlot("googleApiKey", new String[]{((Activity)page.core$().ownerAs(Activity.class)).googleApiKey()});
        }
        if (page.isRestricted()) {
            frame.addSlot("restrict", new String[]{""});
        }
        Commons.writeFrame(new File(this.gen, RESOURCES), StringHelper.snakeCaseToCamelCase((String)(page.name$() + "Resource")), this.template().format((Object)frame));
        this.createCorrespondingAction(page);
    }

    private void createCorrespondingAction(Activity.AbstractPage page) {
        new UIActionRenderer(this.project, page, this.src, this.gen, this.packageName, this.boxName).execute();
    }

    private Template template() {
        Template template = ResourceTemplate.create();
        this.addFormats(template);
        return template;
    }

    private void addFormats(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
    }

    private Frame[] parameters(Activity.AbstractPage page) {
        List parameters = page.paths().stream().filter(path -> path.contains(":")).map(Commons::extractUrlPathParameters).flatMap(Collection::stream).collect(Collectors.toList());
        return parameters.stream().map(parameter -> new Frame(new String[0]).addTypes(new String[]{"parameter"}).addSlot("name", new String[]{parameter})).collect(Collectors.toList()).toArray(new Frame[0]);
    }
}

