/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.dialog;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.activity.dialog.DialogsTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class DialogsRenderer {
    private static final String DIALOGS = "dialogs";
    private final File gen;
    private final String packageName;
    private final String boxName;
    private final List<Dialog> dialogs;

    public DialogsRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        this.gen = gen;
        this.packageName = packageName;
        this.dialogs = graph.dialogList();
        this.boxName = boxName;
    }

    public void execute() {
        if (this.dialogs.isEmpty()) {
            return;
        }
        Frame frame = this.createFrame();
        for (Dialog dialog : this.dialogs) {
            frame.addSlot("dialog", new AbstractFrame[]{this.dialogFrame(dialog)});
        }
        this.write(frame);
    }

    private Frame dialogFrame(Dialog dialog) {
        return new Frame(new String[]{"dialog"}).addSlot("name", new String[]{dialog.name$()}).addSlot("type", new String[]{((Object)((Object)dialog)).getClass().getSimpleName()});
    }

    private void write(Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)"Dialogs");
        Commons.writeFrame(new File(this.gen, DIALOGS), newDisplay, this.template().format((Object)frame));
    }

    private Template template() {
        return this.customize(DialogsTemplate.create());
    }

    private Template customize(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
        return template;
    }

    private Frame createFrame() {
        return new Frame(new String[]{DIALOGS}).addSlot("box", new String[]{this.boxName}).addSlot("package", new String[]{this.packageName});
    }
}

