/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.ElementRenderer;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Mold;
import io.intino.konos.model.graph.Operation;
import io.intino.konos.model.graph.RenderCatalogs;
import io.intino.konos.model.graph.RenderDisplay;
import io.intino.konos.model.graph.RenderMold;
import io.intino.konos.model.graph.RenderObjects;
import io.intino.konos.model.graph.RenderPanels;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Panel
extends Display
implements Terminal {
    protected Toolbar toolbar;
    protected Views views;

    public Panel(Node node) {
        super(node);
    }

    public Toolbar toolbar() {
        return this.toolbar;
    }

    public Views views() {
        return this.views;
    }

    public Panel toolbar(Toolbar value) {
        this.toolbar = value;
        return this;
    }

    public Panel views(Views value) {
        this.views = value;
        return this;
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.toolbar != null) {
            components.add(this.toolbar.core$());
        }
        if (this.views != null) {
            components.add(this.views.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Panel$Toolbar")) {
            this.toolbar = (Toolbar)node.as(Toolbar.class);
        }
        if (node.is("Panel$Views")) {
            this.views = (Views)node.as(Views.class);
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Panel$Toolbar")) {
            this.toolbar = null;
        }
        if (node.is("Panel$Views")) {
            this.views = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Views
    extends Layer
    implements Terminal {
        protected List<View> viewList = new ArrayList<View>();

        public Views(Node node) {
            super(node);
        }

        public List<View> viewList() {
            return Collections.unmodifiableList(this.viewList);
        }

        public View view(int index) {
            return this.viewList.get(index);
        }

        public List<View> viewList(Predicate<View> predicate) {
            return this.viewList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<View>(this.viewList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Panel$Views$View")) {
                this.viewList.add((View)node.as(View.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Panel$Views$View")) {
                this.viewList.remove(node.as(View.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class View
        extends Layer
        implements Terminal {
            protected String label;
            protected Layout layout;
            protected Hidden hidden;
            protected ElementRenderer elementRenderer;

            public View(Node node) {
                super(node);
            }

            public String label() {
                return this.label;
            }

            public Layout layout() {
                return this.layout;
            }

            public Hidden hidden() {
                return this.hidden;
            }

            public View label(String value) {
                this.label = value;
                return this;
            }

            public View layout(Layout value) {
                this.layout = value;
                return this;
            }

            public View hidden(Hidden value) {
                this.hidden = value;
                return this;
            }

            public ElementRenderer elementRenderer() {
                return this.elementRenderer;
            }

            public View elementRenderer(ElementRenderer value) {
                this.elementRenderer = value;
                return this;
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                if (this.elementRenderer != null) {
                    components.add(this.elementRenderer.core$());
                }
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
                map.put("layout", new ArrayList<Layout>(Collections.singletonList(this.layout)));
                map.put("hidden", new ArrayList<Hidden>(Collections.singletonList(this.hidden)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("ElementRenderer")) {
                    this.elementRenderer = (ElementRenderer)node.as(ElementRenderer.class);
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("ElementRenderer")) {
                    this.elementRenderer = null;
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("layout")) {
                    this.layout = (Layout)((Object)WordLoader.load(values, Layout.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("hidden")) {
                    this.hidden = (Hidden)((Object)WordLoader.load(values, Hidden.class, (Layer)this).get(0));
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)values.get(0);
                } else if (name.equalsIgnoreCase("layout")) {
                    this.layout = (Layout)((Object)values.get(0));
                } else if (name.equalsIgnoreCase("hidden")) {
                    this.hidden = (Hidden)((Object)values.get(0));
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public RenderMold renderMold(Mold mold) {
                    RenderMold newElement = (RenderMold)View.this.core$().graph().concept(RenderMold.class).createNode(this.name, View.this.core$()).as(RenderMold.class);
                    newElement.core$().set((Layer)newElement, "mold", Collections.singletonList(mold));
                    return newElement;
                }

                public RenderCatalogs renderCatalogs(List<Catalog> catalogs) {
                    RenderCatalogs newElement = (RenderCatalogs)View.this.core$().graph().concept(RenderCatalogs.class).createNode(this.name, View.this.core$()).as(RenderCatalogs.class);
                    newElement.core$().set((Layer)newElement, "catalogs", catalogs);
                    return newElement;
                }

                public RenderDisplay renderDisplay(String display) {
                    RenderDisplay newElement = (RenderDisplay)View.this.core$().graph().concept(RenderDisplay.class).createNode(this.name, View.this.core$()).as(RenderDisplay.class);
                    newElement.core$().set((Layer)newElement, "display", Collections.singletonList(display));
                    return newElement;
                }

                public RenderPanels renderPanels(List<Panel> panels) {
                    RenderPanels newElement = (RenderPanels)View.this.core$().graph().concept(RenderPanels.class).createNode(this.name, View.this.core$()).as(RenderPanels.class);
                    newElement.core$().set((Layer)newElement, "panels", panels);
                    return newElement;
                }

                public RenderObjects renderObjects(Panel panel) {
                    RenderObjects newElement = (RenderObjects)View.this.core$().graph().concept(RenderObjects.class).createNode(this.name, View.this.core$()).as(RenderObjects.class);
                    newElement.core$().set((Layer)newElement, "panel", Collections.singletonList(panel));
                    return newElement;
                }
            }

            public static enum Hidden {
                HiddenEnabled,
                HiddenDisabled;

            }

            public static enum Layout {
                Tab,
                LeftFixed,
                RightFixed;

            }
        }

        public class Clear {
            public void view(Predicate<View> filter) {
                new ArrayList<View>(Views.this.viewList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public View view(String label) {
                View newElement = (View)Views.this.core$().graph().concept(View.class).createNode(this.name, Views.this.core$()).as(View.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }
        }
    }

    public static class Toolbar
    extends Layer
    implements Terminal {
        protected boolean canSearch;
        protected OpenDialog openDialog;
        protected Export export;
        protected Task task;
        protected Download download;

        public Toolbar(Node node) {
            super(node);
        }

        public boolean canSearch() {
            return this.canSearch;
        }

        public Toolbar canSearch(boolean value) {
            this.canSearch = value;
            return this;
        }

        public OpenDialog openDialog() {
            return this.openDialog;
        }

        public Export export() {
            return this.export;
        }

        public Task task() {
            return this.task;
        }

        public Download download() {
            return this.download;
        }

        public Toolbar openDialog(OpenDialog value) {
            this.openDialog = value;
            return this;
        }

        public Toolbar export(Export value) {
            this.export = value;
            return this;
        }

        public Toolbar task(Task value) {
            this.task = value;
            return this;
        }

        public Toolbar download(Download value) {
            this.download = value;
            return this;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.openDialog != null) {
                components.add(this.openDialog.core$());
            }
            if (this.export != null) {
                components.add(this.export.core$());
            }
            if (this.task != null) {
                components.add(this.task.core$());
            }
            if (this.download != null) {
                components.add(this.download.core$());
            }
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("canSearch", new ArrayList<Boolean>(Collections.singletonList(this.canSearch)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Panel$Toolbar$OpenDialog")) {
                this.openDialog = (OpenDialog)node.as(OpenDialog.class);
            }
            if (node.is("Panel$Toolbar$Export")) {
                this.export = (Export)node.as(Export.class);
            }
            if (node.is("Panel$Toolbar$Task")) {
                this.task = (Task)node.as(Task.class);
            }
            if (node.is("Panel$Toolbar$Download")) {
                this.download = (Download)node.as(Download.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Panel$Toolbar$OpenDialog")) {
                this.openDialog = null;
            }
            if (node.is("Panel$Toolbar$Export")) {
                this.export = null;
            }
            if (node.is("Panel$Toolbar$Task")) {
                this.task = null;
            }
            if (node.is("Panel$Toolbar$Download")) {
                this.download = null;
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("canSearch")) {
                this.canSearch = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("canSearch")) {
                this.canSearch = (Boolean)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Download
        extends Operation
        implements Component,
        Terminal {
            public Download(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Task
        extends Operation
        implements Component,
        Terminal {
            public Task(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Export
        extends Operation
        implements Component,
        Terminal {
            public Export(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class OpenDialog
        extends Operation
        implements Component,
        Terminal {
            protected Dialog dialog;

            public OpenDialog(Node node) {
                super(node);
            }

            public Dialog dialog() {
                return this.dialog;
            }

            public OpenDialog dialog(Dialog value) {
                this.dialog = value;
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("dialog", this.dialog != null ? new ArrayList<Dialog>(Collections.singletonList(this.dialog)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("dialog")) {
                    this.dialog = (Dialog)((Object)NodeLoader.load(values, Dialog.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("dialog")) {
                    this.dialog = values.get(0) != null ? (Dialog)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Dialog.class) : null;
                }
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public OpenDialog openDialog(String title, Dialog dialog) {
                OpenDialog newElement = (OpenDialog)Toolbar.this.core$().graph().concept(OpenDialog.class).createNode(this.name, Toolbar.this.core$()).as(OpenDialog.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                newElement.core$().set((Layer)newElement, "dialog", Collections.singletonList(dialog));
                return newElement;
            }

            public Export export(String title) {
                Export newElement = (Export)Toolbar.this.core$().graph().concept(Export.class).createNode(this.name, Toolbar.this.core$()).as(Export.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                return newElement;
            }

            public Task task(String title) {
                Task newElement = (Task)Toolbar.this.core$().graph().concept(Task.class).createNode(this.name, Toolbar.this.core$()).as(Task.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                return newElement;
            }

            public Download download(String title) {
                Download newElement = (Download)Toolbar.this.core$().graph().concept(Download.class).createNode(this.name, Toolbar.this.core$()).as(Download.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                return newElement;
            }
        }
    }

    public class Clear
    extends Display.Clear {
        public Clear() {
            super(Panel.this);
        }
    }

    public class Create
    extends Display.Create {
        public Create(String name) {
            super(Panel.this, name);
        }

        public Toolbar toolbar() {
            Toolbar newElement = (Toolbar)Panel.this.core$().graph().concept(Toolbar.class).createNode(this.name, Panel.this.core$()).as(Toolbar.class);
            return newElement;
        }

        public Views views() {
            Views newElement = (Views)Panel.this.core$().graph().concept(Views.class).createNode(this.name, Panel.this.core$()).as(Views.class);
            return newElement;
        }
    }
}

