/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display.prototypes;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.AbstractPanelTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.PanelTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.PrototypeRenderer;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.updaters.PanelUpdater;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.ElementRenderer;
import io.intino.konos.model.graph.Mold;
import io.intino.konos.model.graph.Operation;
import io.intino.konos.model.graph.Panel;
import io.intino.konos.model.graph.RenderCatalogs;
import io.intino.konos.model.graph.RenderDisplay;
import io.intino.konos.model.graph.RenderMold;
import io.intino.tara.magritte.Layer;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class PanelRenderer
extends PrototypeRenderer {
    private final Project project;

    public PanelRenderer(Project project, Panel panel, File src, File gen, String packageName, String boxName) {
        super(panel, boxName, packageName, src, gen);
        this.project = project;
    }

    public void render() {
        Frame frame = this.createFrame();
        this.writeSrc(frame);
        this.writeAbstract(frame.addTypes(new String[]{"gen"}));
    }

    @Override
    protected Frame createFrame() {
        Panel panel = (Panel)this.display.a$(Panel.class);
        Frame frame = super.createFrame();
        if (panel.label() != null) {
            frame.addSlot("label", new String[]{panel.label()});
        }
        if (panel.toolbar() != null) {
            frame.addSlot("toolbar", new AbstractFrame[]{this.frameOf(panel.toolbar())});
        }
        for (Panel.Views.View view : panel.views().viewList()) {
            frame.addSlot("view", new AbstractFrame[]{PanelRenderer.frameOf(view, panel, this.box)});
        }
        return frame;
    }

    public static Frame frameOf(Panel.Views.View view, Panel panel, String box) {
        ElementRenderer renderer;
        Frame frame = new Frame(new String[]{"view"}).addSlot("owner", new String[]{panel.name$()}).addSlot("name", new String[]{view.name$()}).addSlot("label", new String[]{view.label()}).addSlot("box", new String[]{box}).addSlot("layout", new String[]{view.layout().name()});
        if (view.hidden() == Panel.Views.View.Hidden.HiddenEnabled) {
            frame.addSlot("hidden", new AbstractFrame[]{PanelRenderer.hidden(panel, view, box)});
        }
        if ((renderer = view.elementRenderer()).i$(RenderDisplay.class)) {
            frame.addTypes(new String[]{"display"});
            frame.addSlot("display", new String[]{((RenderDisplay)renderer.a$(RenderDisplay.class)).display()});
        }
        if (renderer.i$(RenderMold.class)) {
            frame.addTypes(new String[]{"mold"});
            Mold mold = ((RenderMold)renderer.a$(RenderMold.class)).mold();
            frame.addSlot("mold", new String[]{mold.name$()});
        }
        if (renderer.i$(RenderCatalogs.class)) {
            frame.addTypes(new String[]{"catalogs"});
            RenderCatalogs renderCatalogs = (RenderCatalogs)renderer.a$(RenderCatalogs.class);
            frame.addSlot("catalog", (String[])renderCatalogs.catalogs().stream().map(Layer::name$).toArray(String[]::new));
            frame.addSlot("displayLoader", new String[]{""});
            if (renderCatalogs.filtered()) {
                frame.addSlot("filter", new AbstractFrame[]{PanelRenderer.filterFrame(view, panel, box)});
            }
        }
        return frame;
    }

    private static Frame hidden(Panel panel, Panel.Views.View view, String box) {
        return new Frame(new String[0]).addSlot("panel", new String[]{panel.name$()}).addSlot("view", new String[]{view.name$()}).addSlot("box", new String[]{box});
    }

    private Frame frameOf(Panel.Toolbar toolbar) {
        Frame frame = new Frame(new String[]{"toolbar"});
        frame.addSlot("box", new String[]{this.box}).addSlot("canSearch", new Boolean[]{toolbar.canSearch()});
        if (toolbar.download() != null) {
            frame.addSlot("operation", new AbstractFrame[]{PanelRenderer.frameOf(toolbar.download(), (Panel)this.display.a$(Panel.class), this.packageName)});
        }
        if (toolbar.export() != null) {
            frame.addSlot("operation", new AbstractFrame[]{PanelRenderer.frameOf(toolbar.export(), (Panel)this.display.a$(Panel.class), this.packageName)});
        }
        if (toolbar.openDialog() != null) {
            frame.addSlot("operation", new AbstractFrame[]{PanelRenderer.frameOf(toolbar.openDialog(), (Panel)this.display.a$(Panel.class), this.packageName)});
        }
        if (toolbar.task() != null) {
            frame.addSlot("operation", new AbstractFrame[]{PanelRenderer.frameOf(toolbar.task(), (Panel)this.display.a$(Panel.class), this.packageName)});
        }
        return frame;
    }

    public static Frame frameOf(Operation operation, Panel panel, String packageName) {
        Frame frame = new Frame(new String[]{"operation", ((Object)((Object)operation)).getClass().getSimpleName()}).addSlot("name", new String[]{operation.name$()}).addSlot("title", new String[]{operation.title()}).addSlot("panel", new String[]{panel.name$()}).addSlot("package", new String[]{packageName});
        if (operation.polymerIcon() != null) {
            frame.addSlot("icon", new String[]{operation.polymerIcon()});
        }
        if (operation.i$(Panel.Toolbar.OpenDialog.class)) {
            frame.addSlot("dialog", new String[]{((Panel.Toolbar.OpenDialog)operation.a$(Panel.Toolbar.OpenDialog.class)).dialog().name$()});
        }
        return frame;
    }

    private static Frame filterFrame(Panel.Views.View view, Panel panel, String box) {
        String modelClass = ((RenderCatalogs)view.elementRenderer().a$(RenderCatalogs.class)).catalogs().get(0).modelClass();
        return new Frame(new String[]{"filter"}).addSlot("panel", new String[]{panel.name$()}).addSlot("view", new String[]{view.name$()}).addSlot("box", new String[]{box}).addSlot("modelClass", new String[]{modelClass});
    }

    @Override
    protected Template template() {
        return PanelRenderer.customize(AbstractPanelTemplate.create());
    }

    @Override
    protected Template srcTemplate() {
        return PanelRenderer.customize(PanelTemplate.create());
    }

    @Override
    void writeSrc(Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)this.display.name$());
        File sourceFile = Commons.javaFile(new File(this.src, "displays"), newDisplay);
        if (!sourceFile.exists()) {
            Commons.writeFrame(new File(this.src, "displays"), newDisplay, this.srcTemplate().format((Object)frame));
        } else {
            new PanelUpdater(sourceFile, (Panel)this.display.a$(Panel.class), this.project, this.packageName, this.box).update();
        }
    }
}

