/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display.prototypes;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.AbstractCatalogTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.CatalogTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.PrototypeRenderer;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.updaters.CatalogUpdater;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.AbstractToolbar;
import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.CatalogView;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.DisplayView;
import io.intino.konos.model.graph.MagazineView;
import io.intino.konos.model.graph.MapView;
import io.intino.konos.model.graph.Operation;
import io.intino.konos.model.graph.TemporalCatalog;
import io.intino.konos.model.graph.Toolbar;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class CatalogRenderer
extends PrototypeRenderer {
    private final Project project;
    private final String modelClass;

    public CatalogRenderer(Project project, Catalog catalog, File src, File gen, String packageName, String box) {
        super(catalog, box, packageName, src, gen);
        this.project = project;
        this.modelClass = catalog.modelClass();
    }

    public void render() {
        Frame frame = this.createFrame();
        this.writeSrc(frame);
        this.writeAbstract(frame.addTypes(new String[]{"gen"}));
    }

    @Override
    protected Frame createFrame() {
        Catalog catalog = (Catalog)this.display.a$(Catalog.class);
        Frame frame = super.createFrame().addTypes(new String[]{"catalog"}).addSlot("type", new String[]{this.modelClass});
        if (catalog.i$(TemporalCatalog.class)) {
            TemporalCatalog temporalCatalog = (TemporalCatalog)catalog.a$(TemporalCatalog.class);
            frame.addSlot("mode", new String[]{temporalCatalog.type().name()});
            frame.addSlot("scale", temporalCatalog.scales().stream().map(Enum::name).toArray());
            frame.addSlot("range", new AbstractFrame[]{new Frame(new String[0]).addSlot("catalog", new String[]{catalog.name$()}).addSlot("box", new String[]{this.box}).addSlot("type", new String[]{this.modelClass})});
            if (temporalCatalog.temporalFilter() != null) {
                TemporalCatalog.TemporalFilter filter = temporalCatalog.temporalFilter();
                frame.addSlot("temporalFilter", new AbstractFrame[]{new Frame(new String[0]).addSlot("visible", new Boolean[]{filter.visible()}).addSlot("enabled", new Boolean[]{filter.enabled()})});
            }
        }
        if (catalog.label() != null) {
            frame.addSlot("label", new String[]{catalog.label()});
        }
        this.events(catalog, frame);
        this.toolbar(catalog, frame);
        this.views(catalog, frame);
        this.arrangements(catalog, frame);
        return frame;
    }

    private void events(Catalog catalog, Frame frame) {
        if (catalog.events() != null) {
            frame.addSlot("event", new AbstractFrame[]{this.frameOf(catalog.events().onClickRecord())});
        }
    }

    private Frame frameOf(Catalog.Events.OnClickRecord onClickRecord) {
        Catalog.Events.OnClickRecord.CatalogEvent catalogEvent = onClickRecord.catalogEvent();
        if (catalogEvent.i$(Catalog.Events.OnClickRecord.OpenPanel.class)) {
            return CatalogRenderer.frameOf((Catalog.Events.OnClickRecord.OpenPanel)catalogEvent.a$(Catalog.Events.OnClickRecord.OpenPanel.class), (Catalog)this.display.a$(Catalog.class), this.box, this.modelClass);
        }
        if (catalogEvent.i$(Catalog.Events.OnClickRecord.OpenCatalog.class)) {
            return CatalogRenderer.frameOf((Catalog.Events.OnClickRecord.OpenCatalog)catalogEvent.a$(Catalog.Events.OnClickRecord.OpenCatalog.class), (Catalog)this.display.a$(Catalog.class), this.box, this.modelClass);
        }
        return CatalogRenderer.frameOf((Catalog.Events.OnClickRecord.OpenDialog)catalogEvent.a$(Catalog.Events.OnClickRecord.OpenDialog.class), this.display).addSlot("box", new String[]{this.box}).addSlot("package", new String[]{this.packageName});
    }

    public static Frame frameOf(Catalog.Events.OnClickRecord.OpenDialog openDialog, Display catalog) {
        Frame frame = new Frame(new String[]{"event", ((Object)((Object)openDialog)).getClass().getSimpleName()});
        if (openDialog.height() >= 0) {
            frame.addSlot("height", new Integer[]{openDialog.height()});
        }
        if (openDialog.width() >= 0) {
            frame.addSlot("width", new Integer[]{openDialog.width()});
        }
        frame.addSlot("dialog", new String[]{openDialog.dialog().name$()});
        frame.addSlot("catalog", new String[]{catalog.name$()});
        return frame;
    }

    public static Frame frameOf(Catalog.Events.OnClickRecord.OpenPanel openPanel, Catalog catalog, String box, String modelClass) {
        Frame frame = new Frame(new String[]{"event", ((Object)((Object)openPanel)).getClass().getSimpleName()});
        frame.addSlot("panel", new String[]{openPanel.panel().name$()});
        if (openPanel.hasBreadcrumbs()) {
            frame.addSlot("breadcrumbs", new AbstractFrame[]{new Frame(new String[]{"breadCrumbs"}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("box", new String[]{box}).addSlot("type", new String[]{modelClass})});
        }
        return frame;
    }

    public static Frame frameOf(Catalog.Events.OnClickRecord.OpenCatalog openCatalog, Catalog catalog, String box, String modelClass) {
        Frame frame = new Frame(new String[]{"event", ((Object)((Object)openCatalog)).getClass().getSimpleName()});
        frame.addSlot("catalog", new String[]{openCatalog.catalog().name$()});
        if (openCatalog.openItem()) {
            frame.addSlot("openCatalogLoader", new AbstractFrame[]{new Frame(new String[]{"openCatalogLoader"}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("box", new String[]{box}).addSlot("type", new String[]{modelClass})});
        }
        if (openCatalog.filtered()) {
            frame.addSlot("openCatalogFilter", new AbstractFrame[]{new Frame(new String[]{"openCatalogFilter"}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("box", new String[]{box}).addSlot("type", new String[]{modelClass})});
        }
        return frame;
    }

    private void toolbar(Catalog catalog, Frame frame) {
        if (catalog.toolbar() != null) {
            frame.addSlot("toolbar", new AbstractFrame[]{this.frameOf(catalog.toolbar())});
        }
    }

    private void views(Catalog catalog, Frame frame) {
        if (catalog.views().catalogViewList().stream().anyMatch(v -> v.i$(MagazineView.class))) {
            Frame hasMagazineFrame = this.baseFrame().addSlot("type", new String[]{catalog.modelClass()});
            if (catalog.i$(TemporalCatalog.class)) {
                TemporalCatalog temporalCatalog = (TemporalCatalog)catalog.a$(TemporalCatalog.class);
                hasMagazineFrame.addSlot("mode", new String[]{temporalCatalog.type().name()});
                hasMagazineFrame.addSlot("scale", temporalCatalog.scales().stream().map(Enum::name).toArray());
            }
            frame.addSlot("hasMagazineView", new AbstractFrame[]{hasMagazineFrame});
        }
        for (CatalogView view : catalog.views().catalogViewList()) {
            frame.addSlot("view", new AbstractFrame[]{this.frameOf(view, catalog)});
        }
        if (catalog.views().displayView() != null) {
            frame.addSlot("view", new AbstractFrame[]{CatalogRenderer.frameOf(catalog.views().displayView(), catalog, this.box, this.packageName)});
        }
    }

    private void arrangements(Catalog catalog, Frame frame) {
        if (catalog.arrangement() == null) {
            return;
        }
        frame.addSlot("hasArrangements", new AbstractFrame[]{this.baseFrame()});
        for (Catalog.Arrangement.Grouping grouping : catalog.arrangement().groupingList()) {
            frame.addSlot("arrangement", new AbstractFrame[]{CatalogRenderer.frameOf(grouping, catalog, this.box, this.modelClass)});
        }
        for (Catalog.Arrangement.Sorting sorting : catalog.arrangement().sortingList()) {
            frame.addSlot("arrangement", new AbstractFrame[]{CatalogRenderer.frameOf(sorting, catalog, this.box, this.modelClass)});
        }
    }

    private Frame baseFrame() {
        return new Frame(new String[0]).addSlot("box", new String[]{this.box}).addSlot("name", new String[]{this.display.name$()});
    }

    public static Frame frameOf(Catalog.Arrangement.Sorting sorting, Catalog catalog, String box, String modelClass) {
        return new Frame(new String[]{"arrangement", ((Object)((Object)sorting)).getClass().getSimpleName().toLowerCase()}).addSlot("box", new String[]{box}).addSlot("name", new String[]{sorting.name$()}).addSlot("label", new String[]{sorting.label()}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("type", new String[]{modelClass});
    }

    public static Frame frameOf(Catalog.Arrangement.Grouping grouping, Catalog catalog, String box, String modelClass) {
        return new Frame(new String[]{"arrangement", ((Object)((Object)grouping)).getClass().getSimpleName().toLowerCase()}).addSlot("box", new String[]{box}).addSlot("name", new String[]{grouping.name$()}).addSlot("label", new String[]{grouping.label()}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("type", new String[]{modelClass}).addSlot("histogram", new Object[]{grouping.histogram()});
    }

    private Frame frameOf(CatalogView view, Catalog catalog) {
        Frame frame = new Frame(new String[]{"view", ((Object)((Object)view)).getClass().getSimpleName()}).addSlot("label", new String[]{view.label()}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{view.name$()}).addSlot("mold", new String[]{view.mold().name$()}).addSlot("width", new Integer[]{view.width()});
        if (view.noRecordMessage() != null) {
            frame.addSlot("noRecordMessage", new String[]{view.noRecordMessage()});
        }
        if (view.i$(MapView.class)) {
            MapView mapView = (MapView)view.a$(MapView.class);
            if (mapView.center() != null) {
                frame.addSlot("latitude", new Double[]{mapView.center().latitude()}).addSlot("longitude", new Double[]{mapView.center().longitude()});
            }
            frame.addSlot("zoom", new AbstractFrame[]{new Frame(new String[]{"zoom"}).addSlot("default", new Integer[]{mapView.zoom().defaultZoom()}).addSlot("min", new Integer[]{mapView.zoom().min()}).addSlot("max", new Integer[]{mapView.zoom().max()})});
        }
        return frame;
    }

    public static Frame frameOf(DisplayView view, Catalog catalog, String box, String packageName) {
        return new Frame(new String[]{"view", ((Object)((Object)view)).getClass().getSimpleName()}).addSlot("box", new String[]{box}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("name", new String[]{view.name$()}).addSlot("package", new String[]{packageName}).addSlot("hideNavigator", new Boolean[]{view.hideNavigator()}).addSlot("display", new String[]{view.display()});
    }

    private Frame frameOf(Toolbar toolbar) {
        Frame frame = new Frame(new String[]{"toolbar"});
        Catalog owner = (Catalog)toolbar.core$().ownerAs(Catalog.class);
        frame.addSlot("box", new String[]{this.box}).addSlot("type", new String[]{this.modelClass}).addSlot("canSearch", new Boolean[]{toolbar.canSearch()});
        for (Operation operation : toolbar.operations()) {
            if (operation.i$(AbstractToolbar.Download.class)) {
                frame.addSlot("operation", new AbstractFrame[]{CatalogRenderer.frameOf(toolbar.download(), owner, this.box, this.modelClass, this.packageName)});
            }
            if (operation.i$(AbstractToolbar.Export.class)) {
                frame.addSlot("operation", new AbstractFrame[]{CatalogRenderer.frameOf(toolbar.export(), owner, this.box, this.modelClass, this.packageName)});
            }
            if (operation.i$(AbstractToolbar.OpenDialog.class)) {
                frame.addSlot("operation", new AbstractFrame[]{CatalogRenderer.frameOf(toolbar.openDialog(), owner, this.box, this.modelClass, this.packageName)});
            }
            if (operation.i$(AbstractToolbar.Task.class)) {
                frame.addSlot("operation", new AbstractFrame[]{CatalogRenderer.frameOf(toolbar.task(), owner, this.box, this.modelClass, this.packageName)});
            }
            if (operation.i$(AbstractToolbar.TaskSelection.class)) {
                frame.addSlot("operation", new AbstractFrame[]{CatalogRenderer.frameOf(toolbar.taskSelection(), owner, this.box, this.modelClass, this.packageName)});
            }
            if (operation.i$(AbstractToolbar.ExportSelection.class)) {
                frame.addSlot("operation", new AbstractFrame[]{CatalogRenderer.frameOf(toolbar.exportSelection(), owner, this.box, this.modelClass, this.packageName)});
            }
            if (!operation.i$(AbstractToolbar.DownloadSelection.class)) continue;
            frame.addSlot("operation", new AbstractFrame[]{CatalogRenderer.frameOf(toolbar.downloadSelection(), owner, this.box, this.modelClass, this.packageName)});
        }
        return frame;
    }

    public static Frame frameOf(Operation operation, Catalog catalog, String box, String modelClass, String packageName) {
        Frame frame = new Frame(new String[]{"operation", ((Object)((Object)operation)).getClass().getSimpleName().toLowerCase()}).addSlot("name", new String[]{operation.name$()}).addSlot("box", new String[]{box}).addSlot("type", new String[]{modelClass}).addSlot("title", new String[]{operation.title()}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("package", new String[]{packageName});
        if (operation.polymerIcon() != null) {
            frame.addSlot("icon", new String[]{operation.polymerIcon()});
        }
        if (operation.i$(Catalog.Events.OnClickRecord.OpenDialog.class)) {
            frame.addSlot("dialog", new String[]{((Catalog.Events.OnClickRecord.OpenDialog)operation.a$(Catalog.Events.OnClickRecord.OpenDialog.class)).dialog().name$()});
        }
        return frame;
    }

    @Override
    protected Template template() {
        return CatalogRenderer.customize(AbstractCatalogTemplate.create());
    }

    @Override
    protected Template srcTemplate() {
        return CatalogRenderer.customize(CatalogTemplate.create());
    }

    @Override
    void writeSrc(Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)this.display.name$());
        File sourceFile = Commons.javaFile(new File(this.src, "displays"), newDisplay);
        if (!sourceFile.exists()) {
            Commons.writeFrame(new File(this.src, "displays"), newDisplay, this.srcTemplate().format((Object)frame));
        } else {
            new CatalogUpdater(sourceFile, (Catalog)this.display.a$(Catalog.class), this.project, this.packageName, this.box).update();
        }
    }
}

