/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display.prototypes.updaters;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.CatalogRenderer;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.CatalogTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.PrototypeRenderer;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.updaters.Updater;
import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.DisplayView;
import io.intino.konos.model.graph.Operation;
import io.intino.konos.model.graph.TemporalCatalog;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.siani.itrules.Template;

public class CatalogUpdater
extends Updater {
    private Catalog catalog;
    private final Template template;

    public CatalogUpdater(File sourceFile, Catalog catalog, Project project, String packageName, String box) {
        super(sourceFile, project, packageName, box);
        this.catalog = catalog;
        this.template = PrototypeRenderer.customize(CatalogTemplate.create());
    }

    @Override
    public void update() {
        if (this.file == null || !(this.file instanceof PsiJavaFile) || ((PsiJavaFile)this.file).getClasses()[0] == null) {
            return;
        }
        PsiClass psiClass = ((PsiJavaFile)this.file).getClasses()[0];
        if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
            WriteCommandAction.runWriteCommandAction((Project)this.project, () -> this.update(psiClass));
        } else {
            this.update(psiClass);
        }
    }

    private void update(PsiClass psiClass) {
        if (this.catalog.i$(TemporalCatalog.class)) {
            this.updateTemporalMethods(psiClass);
        }
        this.updateOperationMethods(psiClass);
        this.updateArrangementMethods(psiClass);
        this.updateViewMethods(psiClass);
        this.updateEventMethods(psiClass);
    }

    private void updateTemporalMethods(PsiClass psiClass) {
        String createdMethod;
        PsiClass source = this.innerClass(psiClass, "Source");
        PsiClass temporal = this.innerClass(psiClass, "Temporal");
        if (temporal == null) {
            psiClass.addAfter((PsiElement)this.createClass(this.temporalClass(), psiClass), this.constructorOf(psiClass));
        }
        if (source.findMethodsByName(createdMethod = Formatters.firstLowerCase(PrototypeRenderer.shortType(this.catalog.modelClass())) + "Created", false).length == 0) {
            source.addAfter((PsiElement)this.createMethod(createdMethod, "java.time.Instant"), this.constructorOf(psiClass));
        }
    }

    private void updateOperationMethods(PsiClass psiClass) {
        if (this.catalog.toolbar() == null) {
            return;
        }
        PsiClass toolbar = this.innerClass(psiClass, "Toolbar");
        if (toolbar == null) {
            toolbar = (PsiClass)psiClass.addBefore((PsiElement)this.createInnerClass("Toolbar"), this.innerClass(psiClass, "Source").getPrevSibling());
        }
        for (Operation operation : this.catalog.toolbar().operations()) {
            String text;
            String operationType = ((Object)((Object)operation)).getClass().getSimpleName();
            PsiMethod[] methods = toolbar.findMethodsByName(Formatters.firstLowerCase(operationType), false);
            if (methods.length != 0 || (text = this.operationMethodText(operation)) == null || text.isEmpty()) continue;
            toolbar.add((PsiElement)this.createMethodFromText(text));
        }
    }

    private void updateArrangementMethods(PsiClass psiClass) {
        if (this.catalog.arrangement() == null) {
            return;
        }
        PsiClass arrangements = this.innerClass(psiClass, "Arrangements");
        if (arrangements == null) {
            arrangements = (PsiClass)psiClass.addAfter((PsiElement)this.createInnerClass("Arrangements"), this.innerClass(psiClass, "Source").getNextSibling());
        }
        this.updateGroupings(arrangements);
        this.updateSortings(arrangements);
    }

    private void updateGroupings(PsiClass arrangements) {
        for (Catalog.Arrangement.Grouping grouping : this.catalog.arrangement().groupingList()) {
            String text;
            if (arrangements.findMethodsByName(Formatters.firstLowerCase(grouping.name$()), false).length != 0 || (text = this.groupingMethodText(grouping)) == null || text.isEmpty()) continue;
            arrangements.add((PsiElement)this.createMethodFromText(text));
        }
    }

    private void updateSortings(PsiClass arrangements) {
        for (Catalog.Arrangement.Sorting sorting : this.catalog.arrangement().sortingList()) {
            String text;
            if (arrangements.findMethodsByName(Formatters.firstLowerCase(sorting.name$()) + "Comparator", false).length != 0 || (text = this.sortingMethodText(sorting)) == null || text.isEmpty()) continue;
            arrangements.add((PsiElement)this.createMethodFromText(text));
        }
    }

    private void updateEventMethods(PsiClass psiClass) {
        if (this.catalog.events() == null) {
            return;
        }
        Catalog.Events.OnClickRecord.CatalogEvent event = this.catalog.events().onClickRecord().catalogEvent();
        PsiClass events = this.innerClass(psiClass, "Events");
        if (events == null) {
            events = (PsiClass)psiClass.addAfter((PsiElement)this.createInnerClass("Events"), this.innerClass(psiClass, "Source").getNextSibling());
        }
        if (event.i$(Catalog.Events.OnClickRecord.OpenPanel.class)) {
            this.processPanel(event, events);
        } else {
            this.processDialog(event, events);
        }
    }

    private void processDialog(Catalog.Events.OnClickRecord.CatalogEvent event, PsiClass events) {
        String text;
        if (events.findMethodsByName("onOpenDialogPath", false).length == 0 && (text = this.openDialogMethodText((Catalog.Events.OnClickRecord.OpenDialog)event.a$(Catalog.Events.OnClickRecord.OpenDialog.class))) != null && !text.isEmpty()) {
            events.add((PsiElement)this.createMethodFromText(text));
        }
    }

    private void processPanel(Catalog.Events.OnClickRecord.CatalogEvent event, PsiClass events) {
        String text;
        if (!((Catalog.Events.OnClickRecord.OpenPanel)event.a$(Catalog.Events.OnClickRecord.OpenPanel.class)).hasBreadcrumbs()) {
            return;
        }
        if (events.findMethodsByName("onOpenPanelBreadcrumbs", false).length == 0 && (text = this.openPanelMethodText((Catalog.Events.OnClickRecord.OpenPanel)event.a$(Catalog.Events.OnClickRecord.OpenPanel.class))) != null && !text.isEmpty()) {
            events.add((PsiElement)this.createMethodFromText(text));
        }
    }

    private void updateViewMethods(PsiClass psiClass) {
        DisplayView displayView = this.catalog.views().displayView();
        if (this.catalog.views() == null || displayView == null) {
            return;
        }
        PsiClass views = this.innerClass(psiClass, "Views");
        if (views == null) {
            psiClass.addAfter((PsiElement)this.createClass(this.viewsClass(displayView), psiClass), this.innerClass(psiClass, "Source").getNextSibling());
        } else {
            List<PsiMethod> methods = Arrays.asList(views.getMethods());
            if (!methods.isEmpty() && (methods.get(0).getName().equalsIgnoreCase(displayView.display()) || methods.get(0).getName().equalsIgnoreCase(displayView.display() + "Scope"))) {
                return;
            }
            for (PsiMethod method : methods) {
                this.renameViewMethod(method, displayView.display());
            }
        }
    }

    private void renameViewMethod(PsiMethod method, String display) {
        method.getNameIdentifier().replace((PsiElement)this.factory.createIdentifier(display + (method.getName().endsWith("Scope") ? "Scope" : "")));
    }

    private String viewsClass(DisplayView displayView) {
        return this.template.format((Object)CatalogRenderer.frameOf(displayView, this.catalog, this.box, this.packageName));
    }

    private String openPanelMethodText(Catalog.Events.OnClickRecord.OpenPanel event) {
        return this.template.format((Object)CatalogRenderer.frameOf(event, this.catalog, this.box, this.catalog.modelClass()));
    }

    private String openDialogMethodText(Catalog.Events.OnClickRecord.OpenDialog event) {
        return this.template.format((Object)CatalogRenderer.frameOf(event, this.catalog));
    }

    private String operationMethodText(Operation operation) {
        return this.template.format((Object)CatalogRenderer.frameOf(operation, this.catalog, this.box, this.catalog.modelClass(), this.packageName));
    }

    private String sortingMethodText(Catalog.Arrangement.Sorting sorting) {
        return this.template.format((Object)CatalogRenderer.frameOf(sorting, this.catalog, this.box, this.catalog.modelClass()));
    }

    private String groupingMethodText(Catalog.Arrangement.Grouping grouping) {
        return this.template.format((Object)CatalogRenderer.frameOf(grouping, this.catalog, this.box, this.catalog.modelClass()));
    }

    private PsiElement constructorOf(PsiClass psiClass) {
        return psiClass.getConstructors()[psiClass.getConstructors().length - 1].getNextSibling();
    }

    private String temporalClass() {
        return "public static class Temporal {\npublic static io.intino.konos.alexandria.activity.model.TimeRange range (" + Formatters.firstUpperCase(this.box) + "Box box, String username){\nreturn null;\n}\n}";
    }
}

