/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display.prototypes;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.AbstractMoldTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.MoldTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.PrototypeRenderer;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.updaters.MoldUpdater;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Mold;
import io.intino.tara.magritte.Layer;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class MoldRenderer
extends PrototypeRenderer {
    private final Project project;
    private final Mold mold;

    public MoldRenderer(Project project, Mold mold, File src, File gen, String packageName, String boxName) {
        super(mold, boxName, packageName, src, gen);
        this.project = project;
        this.mold = mold;
    }

    public void render() {
        Frame frame = this.createFrame();
        frame.addSlot("moldClass", new String[]{this.moldClass()});
        for (Mold.Block block : this.mold.blockList()) {
            frame.addSlot("block", new AbstractFrame[]{this.frameOf(block)});
        }
        this.writeSrc(frame);
        this.writeAbstract(frame);
    }

    private Frame frameOf(Mold.Block block) {
        Frame frame = new Frame(new String[]{"block"}).addSlot("name", new String[]{this.clean(block.name$())}).addSlot("expanded", new Boolean[]{block.mode().equals((Object)Mold.Block.Mode.Expanded)}).addSlot("layout", (String[])block.layout().stream().map(Enum::name).toArray(String[]::new)).addSlot("hiddenIfMobile", new Boolean[]{block.hiddenIfMobile()});
        if (block.hidden().equals((Object)Mold.Block.Hidden.HiddenEnabled)) {
            frame.addSlot("hidden", new AbstractFrame[]{this.baseFrame(block)});
        }
        if (!block.style().isEmpty()) {
            frame.addSlot("blockStyle", new String[]{block.style()});
        }
        if (block.height() >= 0) {
            frame.addSlot("height", new Integer[]{block.height()});
        }
        if (block.width() >= 0) {
            frame.addSlot("width", new Integer[]{block.width()});
        }
        for (Mold.Block.Stamp stamp : block.stampList()) {
            frame.addSlot("stamp", new AbstractFrame[]{this.frameOf(stamp)});
        }
        for (Mold.Block inner : block.blockList()) {
            frame.addSlot("block", new AbstractFrame[]{this.frameOf(inner)});
        }
        return frame;
    }

    public Frame frameOf(Mold.Block.Stamp stamp) {
        Frame frame = this.baseFrame(stamp).addTypes(new String[]{"stamp"}).addSlot("type", new String[]{((Object)((Object)stamp)).getClass().getSimpleName()}).addSlot("common", new AbstractFrame[]{this.common(stamp)});
        if (stamp.i$(Mold.Block.Picture.class)) {
            this.frameOf(frame, (Mold.Block.Picture)stamp.a$(Mold.Block.Picture.class));
        } else if (stamp.i$(Mold.Block.Rating.class)) {
            this.frameOf(frame, (Mold.Block.Rating)stamp.a$(Mold.Block.Rating.class));
        } else if (stamp.i$(Mold.Block.Breadcrumbs.class)) {
            this.frameOf(frame, (Mold.Block.Breadcrumbs)stamp.a$(Mold.Block.Breadcrumbs.class));
        } else if (stamp.i$(Mold.Block.Location.class)) {
            this.frameOf(frame, (Mold.Block.Location)stamp.a$(Mold.Block.Location.class));
        } else if (stamp.i$(Mold.Block.Operation.class)) {
            this.frameOf(frame, (Mold.Block.Operation)stamp.a$(Mold.Block.Operation.class));
        } else if (stamp.i$(Mold.Block.CatalogLink.class)) {
            this.frameOf(frame, (Mold.Block.CatalogLink)stamp.a$(Mold.Block.CatalogLink.class));
        } else if (stamp.i$(Mold.Block.EmbeddedDisplay.class)) {
            this.frameOf(frame, (Mold.Block.EmbeddedDisplay)stamp.a$(Mold.Block.EmbeddedDisplay.class));
        } else if (stamp.i$(Mold.Block.EmbeddedDialog.class)) {
            this.frameOf(frame, (Mold.Block.EmbeddedDialog)stamp.a$(Mold.Block.EmbeddedDialog.class));
        } else if (stamp.i$(Mold.Block.EmbeddedCatalog.class)) {
            this.frameOf(frame, (Mold.Block.EmbeddedCatalog)stamp.a$(Mold.Block.EmbeddedCatalog.class));
        } else if (stamp.i$(Mold.Block.Icon.class)) {
            this.frameOf(frame, (Mold.Block.Icon)stamp.a$(Mold.Block.Icon.class));
        } else if (stamp.i$(Mold.Block.ItemLinks.class)) {
            this.frameOf(frame, (Mold.Block.ItemLinks)stamp.a$(Mold.Block.ItemLinks.class));
        } else if (stamp.i$(Mold.Block.CardWallet.class)) {
            this.frameOf(frame, (Mold.Block.CardWallet)stamp.a$(Mold.Block.CardWallet.class));
        } else if (stamp.i$(Mold.Block.Map.class)) {
            this.frameOf(frame, (Mold.Block.Map)stamp.a$(Mold.Block.Map.class));
        }
        return frame;
    }

    @NotNull
    private Frame common(Mold.Block.Stamp stamp) {
        Frame frame = this.baseFrame(stamp).addTypes(new String[]{"common"});
        if (!stamp.defaultStyle().isEmpty()) {
            frame.addSlot("defaultStyle", new String[]{stamp.defaultStyle()});
        }
        if (stamp.hasCustomStyle()) {
            frame.addSlot("style", new AbstractFrame[]{this.baseFrame(stamp)});
        }
        if (stamp.editable()) {
            frame.addSlot("editable", new AbstractFrame[]{this.baseFrame(stamp)});
        }
        if (stamp.height() >= 0) {
            frame.addSlot("height", new Integer[]{stamp.height()});
        }
        if (!stamp.label().isEmpty()) {
            frame.addSlot("label", new String[]{stamp.label()});
        }
        if (!stamp.suffix().isEmpty()) {
            frame.addSlot("suffix", new String[]{stamp.suffix()});
        }
        this.addValueMethod(stamp, frame);
        Frame frame2 = frame;
        if (frame2 == null) {
            MoldRenderer.$$$reportNull$$$0(0);
        }
        return frame2;
    }

    private void addValueMethod(Mold.Block.Stamp stamp, Frame frame) {
        if (stamp.i$(Mold.Block.EmbeddedDisplay.class) || stamp.i$(Mold.Block.EmbeddedCatalog.class) || stamp.i$(Mold.Block.Operation.class) || stamp.i$(Mold.Block.Page.class)) {
            return;
        }
        frame.addSlot("valueMethod", new AbstractFrame[]{this.baseFrame(stamp).addTypes(new String[]{"valueMethod"}).addSlot("valueType", new String[]{stamp.i$(Mold.Block.Icon.class) && ((Mold.Block.Icon)stamp.a$(Mold.Block.Icon.class)).source().equals((Object)Mold.Block.Icon.Source.Resource) ? Mold.Block.Icon.Source.Resource.name().toLowerCase() : ((Object)((Object)stamp)).getClass().getSimpleName()})});
    }

    private void frameOf(Frame frame, Mold.Block.Picture stamp) {
        if (stamp.defaultPicture() != null) {
            frame.addSlot("defaultPicture", new String[]{stamp.defaultPicture()});
        }
    }

    private void frameOf(Frame frame, Mold.Block.Rating stamp) {
        frame.addSlot("ratingIcon", new String[]{stamp.polymerIcon()});
    }

    private void frameOf(Frame frame, Mold.Block.EmbeddedCatalog stamp) {
        if (stamp.filtered()) {
            frame.addSlot("embeddedCatalogFilter", new AbstractFrame[]{this.baseFrame(stamp)});
        }
        frame.addSlot("catalog", new String[]{stamp.catalog().name$()});
        frame.addSlot("view", (String[])stamp.views().stream().map(Layer::name$).toArray(String[]::new));
    }

    private void frameOf(Frame frame, Mold.Block.EmbeddedDisplay stamp) {
        frame.addSlot("displayBuilder", new AbstractFrame[]{this.baseFrame(stamp).addTypes(new String[]{"displayBuilder"})});
        frame.addSlot("displayType", new String[]{stamp.display().name$()});
    }

    private void frameOf(Frame frame, Mold.Block.EmbeddedDialog stamp) {
        frame.addSlot("embeddedDialogBuilder", new AbstractFrame[]{this.baseFrame(stamp).addSlot("dialog", new String[]{stamp.dialog().name$()}).addSlot("package", new String[]{this.packageName})});
        frame.addSlot("dialogType", new String[]{stamp.dialog().name$()});
    }

    private void frameOf(Frame frame, Mold.Block.CatalogLink stamp) {
        frame.addSlot("catalog", new String[]{stamp.catalog().name$()});
        if (stamp.filtered()) {
            frame.addSlot("filter", new AbstractFrame[]{this.baseFrame(stamp).addTypes(new String[]{"filter"})});
        }
    }

    private void frameOf(Frame frame, Mold.Block.ItemLinks stamp) {
        frame.addSlot("title", new AbstractFrame[]{this.baseFrame(stamp)});
    }

    private void frameOf(Frame frame, Mold.Block.CardWallet stamp) {
        frame.addSlot("title", new AbstractFrame[]{this.baseFrame(stamp)});
    }

    private void frameOf(Frame frame, Mold.Block.Icon stamp) {
        frame.addTypes(new String[]{stamp.source().name() + "Icon"});
        frame.addSlot("title", new AbstractFrame[]{this.baseFrame(stamp)});
    }

    private void frameOf(Frame frame, Mold.Block.Breadcrumbs stamp) {
        if (stamp.root() != null) {
            frame.addSlot("root", new String[]{stamp.root().name$()});
        }
        this.frameOf(frame, stamp.treeItemList());
    }

    private void frameOf(Frame frame, Mold.Block.Location stamp) {
        frame.addSlot("icon", new AbstractFrame[]{this.baseFrame(stamp)});
        frame.addSlot("drawingColor", new AbstractFrame[]{this.baseFrame(stamp)});
    }

    private void frameOf(Frame frame, Mold.Block.Map stamp) {
        frame.addSlot("zoom", new Integer[]{stamp.zoom()});
        frame.addSlot("latitude", new Double[]{stamp.latitude()});
        frame.addSlot("longitude", new Double[]{stamp.longitude()});
    }

    private void frameOf(Frame frame, Mold.Block.Operation operation) {
        frame.addTypes(new String[]{((Object)((Object)operation)).getClass().getSimpleName()});
        if (operation.i$(Mold.Block.OpenDialogOperation.class)) {
            Mold.Block.OpenDialogOperation openDialogOperation = (Mold.Block.OpenDialogOperation)operation.a$(Mold.Block.OpenDialogOperation.class);
            frame.addSlot("width", new Integer[]{openDialogOperation.width()}).addSlot("dialogType", new String[]{openDialogOperation.dialog().name$()}).addSlot("dialogBuilder", new AbstractFrame[]{this.frame(openDialogOperation)});
        } else if (operation.i$(Mold.Block.DownloadOperation.class)) {
            frame.addSlot("options", ((Mold.Block.DownloadOperation)operation.a$(Mold.Block.DownloadOperation.class)).options().toArray(new String[0]));
            frame.addSlot("downloadExecution", new AbstractFrame[]{this.baseFrame(operation)});
        } else if (operation.i$(Mold.Block.ExportOperation.class)) {
            Mold.Block.ExportOperation export = (Mold.Block.ExportOperation)operation.a$(Mold.Block.ExportOperation.class);
            if (!export.options().isEmpty()) {
                frame.addSlot("options", export.options().toArray(new String[0]));
            }
            frame.addSlot("exportExecution", new AbstractFrame[]{this.baseFrame(operation)});
            if (export.from() != null) {
                frame.addSlot("from", new Long[]{export.from().toEpochMilli()});
            }
            if (export.to() != null) {
                frame.addSlot("to", new Long[]{export.to().toEpochMilli()});
            }
        } else if (operation.i$(Mold.Block.PreviewOperation.class)) {
            frame.addSlot("previewExecution", new AbstractFrame[]{this.baseFrame(operation)});
        } else if (operation.i$(Mold.Block.TaskOperation.class)) {
            frame.addSlot("taskExecution", new AbstractFrame[]{this.baseFrame(operation)});
        }
    }

    private void frameOf(Frame frame, List<Mold.Block.Breadcrumbs.TreeItem> treeItems) {
        for (Mold.Block.Breadcrumbs.TreeItem item : treeItems) {
            Frame sub = new Frame(new String[]{"treeItem"}).addSlot("label", new String[]{item.label()});
            if (!item.treeItemList().isEmpty()) {
                this.frameOf(sub, item.treeItemList());
            }
            frame.addSlot("treeItem", new AbstractFrame[]{sub});
        }
    }

    private Frame frame(Mold.Block.OpenDialogOperation operation) {
        return new Frame(new String[]{((Object)((Object)operation)).getClass().getSimpleName()}).addSlot("dialog", new String[]{operation.dialog().name$()}).addSlot("package", new String[]{this.packageName});
    }

    private Frame baseFrame(Mold.Block.Stamp stamp) {
        return new Frame(new String[]{((Object)((Object)stamp)).getClass().getSimpleName()}).addSlot("mold", new String[]{this.mold.name$()}).addSlot("name", new String[]{stamp.name$()}).addSlot("moldClass", new String[]{this.moldClass()}).addSlot("box", new String[]{this.box});
    }

    private Frame baseFrame(Mold.Block block) {
        Frame frame = new Frame(new String[]{((Object)((Object)block)).getClass().getSimpleName()}).addSlot("mold", new String[]{this.mold.name$()}).addSlot("name", new String[]{block.name$()}).addSlot("moldClass", new String[]{this.moldClass()}).addSlot("box", new String[]{this.box});
        if (block.hidden() == Mold.Block.Hidden.HiddenEnabled) {
            frame.addSlot("HiddenEnabled", new String[]{"HiddenEnabled"});
        }
        return frame;
    }

    private String moldClass() {
        return this.mold.modelClass() == null || this.mold.modelClass().isEmpty() ? "java.lang.Object" : this.mold.modelClass();
    }

    @Override
    protected Template template() {
        return MoldRenderer.customize(AbstractMoldTemplate.create());
    }

    @Override
    void writeSrc(Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)this.display.name$());
        File sourceFile = Commons.javaFile(new File(this.src, "displays"), newDisplay);
        if (!sourceFile.exists()) {
            Commons.writeFrame(new File(this.src, "displays"), newDisplay, this.srcTemplate().format((Object)frame));
        } else {
            new MoldUpdater(sourceFile, (Mold)this.display.a$(Mold.class), this.project, this.packageName, this.box).update();
        }
    }

    @Override
    protected Template srcTemplate() {
        return MoldRenderer.customize(MoldTemplate.create());
    }

    private String clean(String name) {
        return name.replace("-", "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/services/activity/display/prototypes/MoldRenderer", "common"));
    }
}

