/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.NessTanksTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.DataLake;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class NessTanksRenderer {
    private final DataLake dataLake;
    private final File gen;
    private final String packageName;
    private final String boxName;

    public NessTanksRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        this.dataLake = graph.dataLake();
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"tanks"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{this.dataLake.name$()}).addSlot("box", new String[]{this.boxName}).addSlot("tank", (AbstractFrame[])this.dataLake.tankList().stream().map(this::frameOf).toArray(Frame[]::new));
        if (!this.dataLake.tankList().isEmpty()) {
            frame.addSlot("tankImport", new String[]{this.packageName});
        }
        Commons.writeFrame(new File(this.gen, "ness"), "NessTanks", this.template().format((Object)frame));
    }

    private Frame frameOf(DataLake.Tank handler) {
        return new Frame(new String[0]).addTypes(new String[]{"tank"}).addSlot("name", new String[]{handler.name$()}).addSlot("box", new String[]{this.boxName}).addSlot("messageType", new AbstractFrame[]{this.customize(handler.name$(), handler.topic())}).addSlot("simpleMessageType", new String[]{handler.topic()});
    }

    private Frame customize(String name, String topic) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"messageType"});
        frame.addSlot("name", new String[]{topic});
        for (String parameter : Commons.extractParameters(topic)) {
            frame.addSlot("custom", new AbstractFrame[]{this.custom(name, parameter)});
        }
        return frame;
    }

    private Frame custom(String name, String parameter) {
        return new Frame(new String[0]).addSlot("value", new String[]{parameter}).addSlot("conf", new String[]{name});
    }

    private Template template() {
        return Formatters.customize(NessTanksTemplate.create()).add("shortPath", value -> {
            String[] names = value.toString().split("\\.");
            return names[names.length - 1];
        });
    }
}

