/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display.prototypes.updaters;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.PanelRenderer;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.PanelTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.PrototypeRenderer;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.updaters.Updater;
import io.intino.konos.model.graph.Operation;
import io.intino.konos.model.graph.Panel;
import io.intino.konos.model.graph.RenderCatalogs;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.siani.itrules.Template;

public class PanelUpdater
extends Updater {
    private Panel panel;
    private final Template template;

    public PanelUpdater(File sourceFile, Panel panel, Project project, String packageName, String box) {
        super(sourceFile, project, packageName, box);
        this.panel = panel;
        this.template = PrototypeRenderer.customize(PanelTemplate.create());
    }

    @Override
    public void update() {
        if (this.file == null || !(this.file instanceof PsiJavaFile) || ((PsiJavaFile)this.file).getClasses()[0] == null) {
            return;
        }
        PsiClass psiClass = ((PsiJavaFile)this.file).getClasses()[0];
        if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
            WriteCommandAction.runWriteCommandAction((Project)this.project, () -> this.update(psiClass));
        } else {
            this.update(psiClass);
        }
    }

    private void update(PsiClass psiClass) {
        this.updateOperationMethods(psiClass);
        this.updateViewMethods(psiClass);
    }

    private void updateOperationMethods(PsiClass psiClass) {
        String text;
        if (this.panel.toolbar() == null) {
            return;
        }
        PsiClass toolbar = this.innerClass(psiClass, "Toolbar");
        if (this.panel.toolbar().download() != null && toolbar.findMethodsByName(this.panel.toolbar().download().name$(), false).length == 0 && !(text = this.methodFor(this.panel.toolbar().download())).isEmpty()) {
            toolbar.addAfter((PsiElement)this.createMethodFromText(text), toolbar.getLBrace().getNextSibling());
        }
        if (this.panel.toolbar().export() != null && toolbar.findMethodsByName(this.panel.toolbar().export().name$(), false).length == 0 && !(text = this.methodFor(this.panel.toolbar().export())).isEmpty()) {
            toolbar.addAfter((PsiElement)this.createMethodFromText(text), toolbar.getLBrace().getNextSibling());
        }
        if (this.panel.toolbar().openDialog() != null && toolbar.findMethodsByName(this.panel.toolbar().openDialog().name$(), false).length == 0 && !(text = this.methodFor(this.panel.toolbar().openDialog())).isEmpty()) {
            toolbar.addAfter((PsiElement)this.createMethodFromText(text), toolbar.getLBrace().getNextSibling());
        }
        if (this.panel.toolbar().task() != null && toolbar.findMethodsByName(this.panel.toolbar().task().name$(), false).length == 0 && !(text = this.methodFor(this.panel.toolbar().task())).isEmpty()) {
            toolbar.addAfter((PsiElement)this.createMethodFromText(text), toolbar.getLBrace().getNextSibling());
        }
    }

    private String methodFor(Operation operation) {
        return this.template.format((Object)PanelRenderer.frameOf(operation, this.panel));
    }

    private void updateViewMethods(PsiClass psiClass) {
        if (this.panel.views() == null) {
            return;
        }
        PsiClass views = this.innerClass(psiClass, "Views");
        ArrayList<Panel.Views.View> viewList = new ArrayList<Panel.Views.View>(this.panel.views().viewList());
        Collections.reverse(viewList);
        for (Panel.Views.View view : viewList) {
            String text;
            if (this.exists(views, view) || view.elementRenderer().i$(RenderCatalogs.class) && !((RenderCatalogs)view.elementRenderer().a$(RenderCatalogs.class)).filtered() || (text = this.classFor(view)).isEmpty()) continue;
            views.addAfter((PsiElement)this.createClass(text, psiClass), views.getLBrace().getNextSibling());
        }
    }

    private boolean exists(PsiClass views, Panel.Views.View view) {
        return this.innerClass(views, Formatters.firstUpperCase(view.name$())) != null;
    }

    private String classFor(Panel.Views.View view) {
        return this.template.format((Object)PanelRenderer.frameOf(view, this.panel, this.box));
    }
}

