/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.InstantLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.ResourceLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Mold
extends Display
implements Terminal {
    protected String modelClass;
    protected List<Block> blockList = new ArrayList<Block>();

    public Mold(Node node) {
        super(node);
    }

    public String modelClass() {
        return this.modelClass;
    }

    public Mold modelClass(String value) {
        this.modelClass = value;
        return this;
    }

    public List<Block> blockList() {
        return Collections.unmodifiableList(this.blockList);
    }

    public Block block(int index) {
        return this.blockList.get(index);
    }

    public List<Block> blockList(Predicate<Block> predicate) {
        return this.blockList().stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<Block>(this.blockList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("modelClass", new ArrayList<String>(Collections.singletonList(this.modelClass)));
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Mold$Block")) {
            this.blockList.add((Block)node.as(Block.class));
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Mold$Block")) {
            this.blockList.remove(node.as(Block.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("modelClass")) {
            this.modelClass = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("modelClass")) {
            this.modelClass = (String)values.get(0);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Block
    extends Layer
    implements Terminal {
        protected Mode mode;
        protected List<Layout> layout = new ArrayList<Layout>();
        protected int width;
        protected int height;
        protected boolean hidden;
        protected boolean hiddenIfMobile;
        protected String style;
        protected List<Block> blockList = new ArrayList<Block>();
        protected List<Stamp> stampList = new ArrayList<Stamp>();
        protected List<CatalogLink> catalogLinkList = new ArrayList<CatalogLink>();
        protected List<Description> descriptionList = new ArrayList<Description>();
        protected List<Display> displayList = new ArrayList<Display>();
        protected List<EmbeddedCatalog> embeddedCatalogList = new ArrayList<EmbeddedCatalog>();
        protected List<Highlight> highlightList = new ArrayList<Highlight>();
        protected List<Icon> iconList = new ArrayList<Icon>();
        protected List<CustomIcon> customIconList = new ArrayList<CustomIcon>();
        protected List<ItemLinks> itemLinksList = new ArrayList<ItemLinks>();
        protected List<Links> linksList = new ArrayList<Links>();
        protected List<Location> locationList = new ArrayList<Location>();
        protected List<Operation> operationList = new ArrayList<Operation>();
        protected List<OpenDialog> openDialogList = new ArrayList<OpenDialog>();
        protected List<Export> exportList = new ArrayList<Export>();
        protected List<Download> downloadList = new ArrayList<Download>();
        protected List<Task> taskList = new ArrayList<Task>();
        protected List<Page> pageList = new ArrayList<Page>();
        protected List<Picture> pictureList = new ArrayList<Picture>();
        protected List<Rating> ratingList = new ArrayList<Rating>();
        protected List<Snippet> snippetList = new ArrayList<Snippet>();
        protected List<Title> titleList = new ArrayList<Title>();
        protected List<Tree> treeList = new ArrayList<Tree>();
        protected List<Breadcrumbs> breadcrumbsList = new ArrayList<Breadcrumbs>();

        public Block(Node node) {
            super(node);
        }

        public Mode mode() {
            return this.mode;
        }

        public List<Layout> layout() {
            return this.layout;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public boolean hidden() {
            return this.hidden;
        }

        public boolean hiddenIfMobile() {
            return this.hiddenIfMobile;
        }

        public String style() {
            return this.style;
        }

        public Block mode(Mode value) {
            this.mode = value;
            return this;
        }

        public Block width(int value) {
            this.width = value;
            return this;
        }

        public Block height(int value) {
            this.height = value;
            return this;
        }

        public Block hidden(boolean value) {
            this.hidden = value;
            return this;
        }

        public Block hiddenIfMobile(boolean value) {
            this.hiddenIfMobile = value;
            return this;
        }

        public Block style(String value) {
            this.style = value;
            return this;
        }

        public List<Block> blockList() {
            return Collections.unmodifiableList(this.blockList);
        }

        public Block block(int index) {
            return this.blockList.get(index);
        }

        public List<Block> blockList(Predicate<Block> predicate) {
            return this.blockList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Stamp> stampList() {
            return Collections.unmodifiableList(this.stampList);
        }

        public Stamp stamp(int index) {
            return this.stampList.get(index);
        }

        public List<Stamp> stampList(Predicate<Stamp> predicate) {
            return this.stampList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<CatalogLink> catalogLinkList() {
            return Collections.unmodifiableList(this.catalogLinkList);
        }

        public CatalogLink catalogLink(int index) {
            return this.catalogLinkList.get(index);
        }

        public List<CatalogLink> catalogLinkList(Predicate<CatalogLink> predicate) {
            return this.catalogLinkList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Description> descriptionList() {
            return Collections.unmodifiableList(this.descriptionList);
        }

        public Description description(int index) {
            return this.descriptionList.get(index);
        }

        public List<Description> descriptionList(Predicate<Description> predicate) {
            return this.descriptionList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Display> displayList() {
            return Collections.unmodifiableList(this.displayList);
        }

        public Display display(int index) {
            return this.displayList.get(index);
        }

        public List<Display> displayList(Predicate<Display> predicate) {
            return this.displayList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<EmbeddedCatalog> embeddedCatalogList() {
            return Collections.unmodifiableList(this.embeddedCatalogList);
        }

        public EmbeddedCatalog embeddedCatalog(int index) {
            return this.embeddedCatalogList.get(index);
        }

        public List<EmbeddedCatalog> embeddedCatalogList(Predicate<EmbeddedCatalog> predicate) {
            return this.embeddedCatalogList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Highlight> highlightList() {
            return Collections.unmodifiableList(this.highlightList);
        }

        public Highlight highlight(int index) {
            return this.highlightList.get(index);
        }

        public List<Highlight> highlightList(Predicate<Highlight> predicate) {
            return this.highlightList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Icon> iconList() {
            return Collections.unmodifiableList(this.iconList);
        }

        public Icon icon(int index) {
            return this.iconList.get(index);
        }

        public List<Icon> iconList(Predicate<Icon> predicate) {
            return this.iconList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<CustomIcon> customIconList() {
            return Collections.unmodifiableList(this.customIconList);
        }

        public CustomIcon customIcon(int index) {
            return this.customIconList.get(index);
        }

        public List<CustomIcon> customIconList(Predicate<CustomIcon> predicate) {
            return this.customIconList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<ItemLinks> itemLinksList() {
            return Collections.unmodifiableList(this.itemLinksList);
        }

        public ItemLinks itemLinks(int index) {
            return this.itemLinksList.get(index);
        }

        public List<ItemLinks> itemLinksList(Predicate<ItemLinks> predicate) {
            return this.itemLinksList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Links> linksList() {
            return Collections.unmodifiableList(this.linksList);
        }

        public Links links(int index) {
            return this.linksList.get(index);
        }

        public List<Links> linksList(Predicate<Links> predicate) {
            return this.linksList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Location> locationList() {
            return Collections.unmodifiableList(this.locationList);
        }

        public Location location(int index) {
            return this.locationList.get(index);
        }

        public List<Location> locationList(Predicate<Location> predicate) {
            return this.locationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Operation> operationList() {
            return Collections.unmodifiableList(this.operationList);
        }

        public Operation operation(int index) {
            return this.operationList.get(index);
        }

        public List<Operation> operationList(Predicate<Operation> predicate) {
            return this.operationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<OpenDialog> openDialogList() {
            return Collections.unmodifiableList(this.openDialogList);
        }

        public OpenDialog openDialog(int index) {
            return this.openDialogList.get(index);
        }

        public List<OpenDialog> openDialogList(Predicate<OpenDialog> predicate) {
            return this.openDialogList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Export> exportList() {
            return Collections.unmodifiableList(this.exportList);
        }

        public Export export(int index) {
            return this.exportList.get(index);
        }

        public List<Export> exportList(Predicate<Export> predicate) {
            return this.exportList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Download> downloadList() {
            return Collections.unmodifiableList(this.downloadList);
        }

        public Download download(int index) {
            return this.downloadList.get(index);
        }

        public List<Download> downloadList(Predicate<Download> predicate) {
            return this.downloadList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Task> taskList() {
            return Collections.unmodifiableList(this.taskList);
        }

        public Task task(int index) {
            return this.taskList.get(index);
        }

        public List<Task> taskList(Predicate<Task> predicate) {
            return this.taskList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Page> pageList() {
            return Collections.unmodifiableList(this.pageList);
        }

        public Page page(int index) {
            return this.pageList.get(index);
        }

        public List<Page> pageList(Predicate<Page> predicate) {
            return this.pageList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Picture> pictureList() {
            return Collections.unmodifiableList(this.pictureList);
        }

        public Picture picture(int index) {
            return this.pictureList.get(index);
        }

        public List<Picture> pictureList(Predicate<Picture> predicate) {
            return this.pictureList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Rating> ratingList() {
            return Collections.unmodifiableList(this.ratingList);
        }

        public Rating rating(int index) {
            return this.ratingList.get(index);
        }

        public List<Rating> ratingList(Predicate<Rating> predicate) {
            return this.ratingList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Snippet> snippetList() {
            return Collections.unmodifiableList(this.snippetList);
        }

        public Snippet snippet(int index) {
            return this.snippetList.get(index);
        }

        public List<Snippet> snippetList(Predicate<Snippet> predicate) {
            return this.snippetList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Title> titleList() {
            return Collections.unmodifiableList(this.titleList);
        }

        public Title title(int index) {
            return this.titleList.get(index);
        }

        public List<Title> titleList(Predicate<Title> predicate) {
            return this.titleList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Tree> treeList() {
            return Collections.unmodifiableList(this.treeList);
        }

        public Tree tree(int index) {
            return this.treeList.get(index);
        }

        public List<Tree> treeList(Predicate<Tree> predicate) {
            return this.treeList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Breadcrumbs> breadcrumbsList() {
            return Collections.unmodifiableList(this.breadcrumbsList);
        }

        public Breadcrumbs breadcrumbs(int index) {
            return this.breadcrumbsList.get(index);
        }

        public List<Breadcrumbs> breadcrumbsList(Predicate<Breadcrumbs> predicate) {
            return this.breadcrumbsList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Block>(this.blockList).forEach(c -> components.add(c.core$()));
            new ArrayList<Stamp>(this.stampList).forEach(c -> components.add(c.core$()));
            new ArrayList<CatalogLink>(this.catalogLinkList).forEach(c -> components.add(c.core$()));
            new ArrayList<Description>(this.descriptionList).forEach(c -> components.add(c.core$()));
            new ArrayList<Display>(this.displayList).forEach(c -> components.add(c.core$()));
            new ArrayList<EmbeddedCatalog>(this.embeddedCatalogList).forEach(c -> components.add(c.core$()));
            new ArrayList<Highlight>(this.highlightList).forEach(c -> components.add(c.core$()));
            new ArrayList<Icon>(this.iconList).forEach(c -> components.add(c.core$()));
            new ArrayList<CustomIcon>(this.customIconList).forEach(c -> components.add(c.core$()));
            new ArrayList<ItemLinks>(this.itemLinksList).forEach(c -> components.add(c.core$()));
            new ArrayList<Links>(this.linksList).forEach(c -> components.add(c.core$()));
            new ArrayList<Location>(this.locationList).forEach(c -> components.add(c.core$()));
            new ArrayList<Operation>(this.operationList).forEach(c -> components.add(c.core$()));
            new ArrayList<OpenDialog>(this.openDialogList).forEach(c -> components.add(c.core$()));
            new ArrayList<Export>(this.exportList).forEach(c -> components.add(c.core$()));
            new ArrayList<Download>(this.downloadList).forEach(c -> components.add(c.core$()));
            new ArrayList<Task>(this.taskList).forEach(c -> components.add(c.core$()));
            new ArrayList<Page>(this.pageList).forEach(c -> components.add(c.core$()));
            new ArrayList<Picture>(this.pictureList).forEach(c -> components.add(c.core$()));
            new ArrayList<Rating>(this.ratingList).forEach(c -> components.add(c.core$()));
            new ArrayList<Snippet>(this.snippetList).forEach(c -> components.add(c.core$()));
            new ArrayList<Title>(this.titleList).forEach(c -> components.add(c.core$()));
            new ArrayList<Tree>(this.treeList).forEach(c -> components.add(c.core$()));
            new ArrayList<Breadcrumbs>(this.breadcrumbsList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
            map.put("layout", this.layout);
            map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
            map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
            map.put("hidden", new ArrayList<Boolean>(Collections.singletonList(this.hidden)));
            map.put("hiddenIfMobile", new ArrayList<Boolean>(Collections.singletonList(this.hiddenIfMobile)));
            map.put("style", new ArrayList<String>(Collections.singletonList(this.style)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Mold$Block")) {
                this.blockList.add((Block)node.as(Block.class));
            }
            if (node.is("Mold$Block$Stamp")) {
                this.stampList.add((Stamp)node.as(Stamp.class));
            }
            if (node.is("Mold$Block$CatalogLink")) {
                this.catalogLinkList.add((CatalogLink)node.as(CatalogLink.class));
            }
            if (node.is("Mold$Block$Description")) {
                this.descriptionList.add((Description)node.as(Description.class));
            }
            if (node.is("Mold$Block$Display")) {
                this.displayList.add((Display)node.as(Display.class));
            }
            if (node.is("Mold$Block$EmbeddedCatalog")) {
                this.embeddedCatalogList.add((EmbeddedCatalog)node.as(EmbeddedCatalog.class));
            }
            if (node.is("Mold$Block$Highlight")) {
                this.highlightList.add((Highlight)node.as(Highlight.class));
            }
            if (node.is("Mold$Block$Icon")) {
                this.iconList.add((Icon)node.as(Icon.class));
            }
            if (node.is("Mold$Block$CustomIcon")) {
                this.customIconList.add((CustomIcon)node.as(CustomIcon.class));
            }
            if (node.is("Mold$Block$ItemLinks")) {
                this.itemLinksList.add((ItemLinks)node.as(ItemLinks.class));
            }
            if (node.is("Mold$Block$Links")) {
                this.linksList.add((Links)node.as(Links.class));
            }
            if (node.is("Mold$Block$Location")) {
                this.locationList.add((Location)node.as(Location.class));
            }
            if (node.is("Mold$Block$Operation")) {
                this.operationList.add((Operation)node.as(Operation.class));
            }
            if (node.is("Mold$Block$OpenDialog")) {
                this.openDialogList.add((OpenDialog)node.as(OpenDialog.class));
            }
            if (node.is("Mold$Block$Export")) {
                this.exportList.add((Export)node.as(Export.class));
            }
            if (node.is("Mold$Block$Download")) {
                this.downloadList.add((Download)node.as(Download.class));
            }
            if (node.is("Mold$Block$Task")) {
                this.taskList.add((Task)node.as(Task.class));
            }
            if (node.is("Mold$Block$Page")) {
                this.pageList.add((Page)node.as(Page.class));
            }
            if (node.is("Mold$Block$Picture")) {
                this.pictureList.add((Picture)node.as(Picture.class));
            }
            if (node.is("Mold$Block$Rating")) {
                this.ratingList.add((Rating)node.as(Rating.class));
            }
            if (node.is("Mold$Block$Snippet")) {
                this.snippetList.add((Snippet)node.as(Snippet.class));
            }
            if (node.is("Mold$Block$Title")) {
                this.titleList.add((Title)node.as(Title.class));
            }
            if (node.is("Mold$Block$Tree")) {
                this.treeList.add((Tree)node.as(Tree.class));
            }
            if (node.is("Mold$Block$Breadcrumbs")) {
                this.breadcrumbsList.add((Breadcrumbs)node.as(Breadcrumbs.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Mold$Block")) {
                this.blockList.remove(node.as(Block.class));
            }
            if (node.is("Mold$Block$Stamp")) {
                this.stampList.remove(node.as(Stamp.class));
            }
            if (node.is("Mold$Block$CatalogLink")) {
                this.catalogLinkList.remove(node.as(CatalogLink.class));
            }
            if (node.is("Mold$Block$Description")) {
                this.descriptionList.remove(node.as(Description.class));
            }
            if (node.is("Mold$Block$Display")) {
                this.displayList.remove(node.as(Display.class));
            }
            if (node.is("Mold$Block$EmbeddedCatalog")) {
                this.embeddedCatalogList.remove(node.as(EmbeddedCatalog.class));
            }
            if (node.is("Mold$Block$Highlight")) {
                this.highlightList.remove(node.as(Highlight.class));
            }
            if (node.is("Mold$Block$Icon")) {
                this.iconList.remove(node.as(Icon.class));
            }
            if (node.is("Mold$Block$CustomIcon")) {
                this.customIconList.remove(node.as(CustomIcon.class));
            }
            if (node.is("Mold$Block$ItemLinks")) {
                this.itemLinksList.remove(node.as(ItemLinks.class));
            }
            if (node.is("Mold$Block$Links")) {
                this.linksList.remove(node.as(Links.class));
            }
            if (node.is("Mold$Block$Location")) {
                this.locationList.remove(node.as(Location.class));
            }
            if (node.is("Mold$Block$Operation")) {
                this.operationList.remove(node.as(Operation.class));
            }
            if (node.is("Mold$Block$OpenDialog")) {
                this.openDialogList.remove(node.as(OpenDialog.class));
            }
            if (node.is("Mold$Block$Export")) {
                this.exportList.remove(node.as(Export.class));
            }
            if (node.is("Mold$Block$Download")) {
                this.downloadList.remove(node.as(Download.class));
            }
            if (node.is("Mold$Block$Task")) {
                this.taskList.remove(node.as(Task.class));
            }
            if (node.is("Mold$Block$Page")) {
                this.pageList.remove(node.as(Page.class));
            }
            if (node.is("Mold$Block$Picture")) {
                this.pictureList.remove(node.as(Picture.class));
            }
            if (node.is("Mold$Block$Rating")) {
                this.ratingList.remove(node.as(Rating.class));
            }
            if (node.is("Mold$Block$Snippet")) {
                this.snippetList.remove(node.as(Snippet.class));
            }
            if (node.is("Mold$Block$Title")) {
                this.titleList.remove(node.as(Title.class));
            }
            if (node.is("Mold$Block$Tree")) {
                this.treeList.remove(node.as(Tree.class));
            }
            if (node.is("Mold$Block$Breadcrumbs")) {
                this.breadcrumbsList.remove(node.as(Breadcrumbs.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("layout")) {
                this.layout = WordLoader.load(values, Layout.class, (Layer)this);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("hidden")) {
                this.hidden = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("hiddenIfMobile")) {
                this.hiddenIfMobile = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("style")) {
                this.style = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("layout")) {
                this.layout = new ArrayList(values);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("hidden")) {
                this.hidden = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("hiddenIfMobile")) {
                this.hiddenIfMobile = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("style")) {
                this.style = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Breadcrumbs
        extends Tree
        implements Terminal {
            public Breadcrumbs(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Create
            extends Tree.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Tree.Root root(String label) {
                    Tree.Root newElement = (Tree.Root)Breadcrumbs.this.core$().graph().concept(Tree.Root.class).createNode(this.name, Breadcrumbs.this.core$()).as(Tree.Root.class);
                    newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }
            }
        }

        public static abstract class Tree
        extends Stamp
        implements Terminal {
            protected Root root;
            protected List<TreeItem> treeItemList = new ArrayList<TreeItem>();

            public Tree(Node node) {
                super(node);
            }

            public Root root() {
                return this.root;
            }

            public List<TreeItem> treeItemList() {
                return Collections.unmodifiableList(this.treeItemList);
            }

            public TreeItem treeItem(int index) {
                return this.treeItemList.get(index);
            }

            public List<TreeItem> treeItemList(Predicate<TreeItem> predicate) {
                return this.treeItemList().stream().filter(predicate).collect(Collectors.toList());
            }

            public Tree root(Root value) {
                this.root = value;
                return this;
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                if (this.root != null) {
                    components.add(this.root.core$());
                }
                new ArrayList<TreeItem>(this.treeItemList).forEach(c -> components.add(c.core$()));
                return new ArrayList<Node>(components);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Mold$Block$Tree$Root")) {
                    this.root = (Root)node.as(Root.class);
                }
                if (node.is("Mold$Block$Tree$TreeItem")) {
                    this.treeItemList.add((TreeItem)node.as(TreeItem.class));
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Mold$Block$Tree$Root")) {
                    this.root = null;
                }
                if (node.is("Mold$Block$Tree$TreeItem")) {
                    this.treeItemList.remove(node.as(TreeItem.class));
                }
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class TreeItem
            extends Layer
            implements Terminal {
                protected String label;
                protected List<TreeItem> treeItemList = new ArrayList<TreeItem>();

                public TreeItem(Node node) {
                    super(node);
                }

                public String label() {
                    return this.label;
                }

                public TreeItem label(String value) {
                    this.label = value;
                    return this;
                }

                public List<TreeItem> treeItemList() {
                    return Collections.unmodifiableList(this.treeItemList);
                }

                public TreeItem treeItem(int index) {
                    return this.treeItemList.get(index);
                }

                public List<TreeItem> treeItemList(Predicate<TreeItem> predicate) {
                    return this.treeItemList().stream().filter(predicate).collect(Collectors.toList());
                }

                protected List<Node> componentList$() {
                    LinkedHashSet components = new LinkedHashSet(super.componentList$());
                    new ArrayList<TreeItem>(this.treeItemList).forEach(c -> components.add(c.core$()));
                    return new ArrayList<Node>(components);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
                    return map;
                }

                protected void addNode$(Node node) {
                    super.addNode$(node);
                    if (node.is("Mold$Block$Tree$TreeItem")) {
                        this.treeItemList.add((TreeItem)node.as(TreeItem.class));
                    }
                }

                protected void removeNode$(Node node) {
                    super.removeNode$(node);
                    if (node.is("Mold$Block$Tree$TreeItem")) {
                        this.treeItemList.remove(node.as(TreeItem.class));
                    }
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("label")) {
                        this.label = (String)StringLoader.load(values, (Layer)this).get(0);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("label")) {
                        this.label = (String)values.get(0);
                    }
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Clear clear() {
                    return new Clear();
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public class Clear {
                    public void treeItem(Predicate<TreeItem> filter) {
                        new ArrayList<TreeItem>(TreeItem.this.treeItemList()).stream().filter(filter).forEach(Layer::delete$);
                    }
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public TreeItem treeItem(String label) {
                        TreeItem newElement = (TreeItem)TreeItem.this.core$().graph().concept(TreeItem.class).createNode(this.name, TreeItem.this.core$()).as(TreeItem.class);
                        newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                        return newElement;
                    }

                    public Root root(String label) {
                        Root newElement = (Root)TreeItem.this.core$().graph().concept(Root.class).createNode(this.name, TreeItem.this.core$()).as(Root.class);
                        newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                        return newElement;
                    }
                }
            }

            public static class Root
            extends TreeItem
            implements Terminal {
                public Root(Node node) {
                    super(node);
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap(super.variables$());
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                @Override
                public Create create() {
                    return new Create(null);
                }

                @Override
                public Create create(String name) {
                    return new Create(name);
                }

                @Override
                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public class Create
                extends TreeItem.Create {
                    public Create(String name) {
                        super(name);
                    }

                    @Override
                    public Root root(String label) {
                        Root newElement = (Root)Root.this.core$().graph().concept(Root.class).createNode(this.name, Root.this.core$()).as(Root.class);
                        newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                        return newElement;
                    }
                }
            }

            public class Clear {
                public void treeItem(Predicate<TreeItem> filter) {
                    new ArrayList<TreeItem>(Tree.this.treeItemList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Stamp.Create {
                public Create(String name) {
                    super(name);
                }

                public Root root(String label) {
                    Root newElement = (Root)Tree.this.core$().graph().concept(Root.class).createNode(this.name, Tree.this.core$()).as(Root.class);
                    newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public TreeItem treeItem(String label) {
                    TreeItem newElement = (TreeItem)Tree.this.core$().graph().concept(TreeItem.class).createNode(this.name, Tree.this.core$()).as(TreeItem.class);
                    newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }
            }
        }

        public static class Title
        extends Stamp
        implements Terminal {
            public Title(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Snippet
        extends Stamp
        implements Terminal {
            public Snippet(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Rating
        extends Stamp
        implements Terminal {
            public Rating(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Picture
        extends Stamp
        implements Terminal {
            protected URL defaultPicture;

            public Picture(Node node) {
                super(node);
            }

            public URL defaultPicture() {
                return this.defaultPicture;
            }

            public Picture defaultPicture(URL url, String destiny) {
                this.defaultPicture = this.graph().core$().save(url, destiny, this.defaultPicture, this.core$());
                return this;
            }

            public Picture defaultPicture(InputStream stream, String destiny) {
                this.defaultPicture = this.graph().core$().save(stream, destiny, this.defaultPicture, this.core$());
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("defaultPicture", new ArrayList<URL>(Collections.singletonList(this.defaultPicture)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("defaultPicture")) {
                    this.defaultPicture = (URL)ResourceLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("defaultPicture")) {
                    this.defaultPicture = (URL)values.get(0);
                }
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Page
        extends Stamp
        implements Terminal {
            public Page(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Task
        extends Operation
        implements Terminal {
            public Task(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Download
        extends Operation
        implements Terminal {
            protected List<String> options = new ArrayList<String>();

            public Download(Node node) {
                super(node);
            }

            public List<String> options() {
                return this.options;
            }

            public String options(int index) {
                return this.options.get(index);
            }

            public List<String> options(Predicate<String> predicate) {
                return this.options().stream().filter(predicate).collect(Collectors.toList());
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("options", this.options);
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("options")) {
                    this.options = StringLoader.load(values, (Layer)this);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("options")) {
                    this.options = new ArrayList(values);
                }
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Export
        extends Operation
        implements Terminal {
            protected List<String> options = new ArrayList<String>();
            protected Instant from;
            protected Instant to;

            public Export(Node node) {
                super(node);
            }

            public List<String> options() {
                return this.options;
            }

            public String options(int index) {
                return this.options.get(index);
            }

            public List<String> options(Predicate<String> predicate) {
                return this.options().stream().filter(predicate).collect(Collectors.toList());
            }

            public Instant from() {
                return this.from;
            }

            public Instant to() {
                return this.to;
            }

            public Export from(Instant value) {
                this.from = value;
                return this;
            }

            public Export to(Instant value) {
                this.to = value;
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("options", this.options);
                map.put("from", new ArrayList<Instant>(Collections.singletonList(this.from)));
                map.put("to", new ArrayList<Instant>(Collections.singletonList(this.to)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("options")) {
                    this.options = StringLoader.load(values, (Layer)this);
                } else if (name.equalsIgnoreCase("from")) {
                    this.from = (Instant)InstantLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("to")) {
                    this.to = (Instant)InstantLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("options")) {
                    this.options = new ArrayList(values);
                } else if (name.equalsIgnoreCase("from")) {
                    this.from = (Instant)values.get(0);
                } else if (name.equalsIgnoreCase("to")) {
                    this.to = (Instant)values.get(0);
                }
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class OpenDialog
        extends Operation
        implements Terminal {
            protected int width;

            public OpenDialog(Node node) {
                super(node);
            }

            public int width() {
                return this.width;
            }

            public OpenDialog width(int value) {
                this.width = value;
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("width")) {
                    this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("width")) {
                    this.width = (Integer)values.get(0);
                }
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static abstract class Operation
        extends Stamp
        implements Terminal {
            public Operation(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Create
            extends Stamp.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Location
        extends Stamp
        implements Terminal {
            public Location(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Links
        extends Stamp
        implements Terminal {
            public Links(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class ItemLinks
        extends Stamp
        implements Terminal {
            public ItemLinks(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class CustomIcon
        extends Stamp
        implements Terminal {
            public CustomIcon(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Icon
        extends Stamp
        implements Terminal {
            public Icon(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Highlight
        extends Stamp
        implements Terminal {
            public Highlight(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class EmbeddedCatalog
        extends Stamp
        implements Terminal {
            public EmbeddedCatalog(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Display
        extends Stamp
        implements Terminal {
            public Display(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Description
        extends Stamp
        implements Terminal {
            public Description(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class CatalogLink
        extends Stamp
        implements Terminal {
            protected Catalog catalog;

            public CatalogLink(Node node) {
                super(node);
            }

            public Catalog catalog() {
                return this.catalog;
            }

            public CatalogLink catalog(Catalog value) {
                this.catalog = value;
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("catalog", this.catalog != null ? new ArrayList<Catalog>(Collections.singletonList(this.catalog)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("catalog")) {
                    this.catalog = (Catalog)((Object)NodeLoader.load(values, Catalog.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("catalog")) {
                    this.catalog = values.get(0) != null ? (Catalog)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Catalog.class) : null;
                }
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static abstract class Stamp
        extends Layer
        implements Terminal {
            protected String label;
            protected Layout layout;
            protected int height;
            protected String suffix;
            protected String defaultStyle;
            protected boolean editable;

            public Stamp(Node node) {
                super(node);
            }

            public String label() {
                return this.label;
            }

            public Layout layout() {
                return this.layout;
            }

            public int height() {
                return this.height;
            }

            public String suffix() {
                return this.suffix;
            }

            public String defaultStyle() {
                return this.defaultStyle;
            }

            public boolean editable() {
                return this.editable;
            }

            public Stamp label(String value) {
                this.label = value;
                return this;
            }

            public Stamp layout(Layout value) {
                this.layout = value;
                return this;
            }

            public Stamp height(int value) {
                this.height = value;
                return this;
            }

            public Stamp suffix(String value) {
                this.suffix = value;
                return this;
            }

            public Stamp defaultStyle(String value) {
                this.defaultStyle = value;
                return this;
            }

            public Stamp editable(boolean value) {
                this.editable = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
                map.put("layout", new ArrayList<Layout>(Collections.singletonList(this.layout)));
                map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
                map.put("suffix", new ArrayList<String>(Collections.singletonList(this.suffix)));
                map.put("defaultStyle", new ArrayList<String>(Collections.singletonList(this.defaultStyle)));
                map.put("editable", new ArrayList<Boolean>(Collections.singletonList(this.editable)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("layout")) {
                    this.layout = (Layout)((Object)WordLoader.load(values, Layout.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("height")) {
                    this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("suffix")) {
                    this.suffix = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("defaultStyle")) {
                    this.defaultStyle = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("editable")) {
                    this.editable = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)values.get(0);
                } else if (name.equalsIgnoreCase("layout")) {
                    this.layout = (Layout)((Object)values.get(0));
                } else if (name.equalsIgnoreCase("height")) {
                    this.height = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("suffix")) {
                    this.suffix = (String)values.get(0);
                } else if (name.equalsIgnoreCase("defaultStyle")) {
                    this.defaultStyle = (String)values.get(0);
                } else if (name.equalsIgnoreCase("editable")) {
                    this.editable = (Boolean)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }

            public static enum Layout {
                Fixed,
                Flexible;

            }
        }

        public class Clear {
            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Block.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void catalogLink(Predicate<CatalogLink> filter) {
                new ArrayList<CatalogLink>(Block.this.catalogLinkList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void description(Predicate<Description> filter) {
                new ArrayList<Description>(Block.this.descriptionList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void display(Predicate<Display> filter) {
                new ArrayList<Display>(Block.this.displayList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void embeddedCatalog(Predicate<EmbeddedCatalog> filter) {
                new ArrayList<EmbeddedCatalog>(Block.this.embeddedCatalogList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void highlight(Predicate<Highlight> filter) {
                new ArrayList<Highlight>(Block.this.highlightList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void icon(Predicate<Icon> filter) {
                new ArrayList<Icon>(Block.this.iconList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void customIcon(Predicate<CustomIcon> filter) {
                new ArrayList<CustomIcon>(Block.this.customIconList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void itemLinks(Predicate<ItemLinks> filter) {
                new ArrayList<ItemLinks>(Block.this.itemLinksList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void links(Predicate<Links> filter) {
                new ArrayList<Links>(Block.this.linksList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void location(Predicate<Location> filter) {
                new ArrayList<Location>(Block.this.locationList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void openDialog(Predicate<OpenDialog> filter) {
                new ArrayList<OpenDialog>(Block.this.openDialogList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void export(Predicate<Export> filter) {
                new ArrayList<Export>(Block.this.exportList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void download(Predicate<Download> filter) {
                new ArrayList<Download>(Block.this.downloadList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void task(Predicate<Task> filter) {
                new ArrayList<Task>(Block.this.taskList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void page(Predicate<Page> filter) {
                new ArrayList<Page>(Block.this.pageList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void picture(Predicate<Picture> filter) {
                new ArrayList<Picture>(Block.this.pictureList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void rating(Predicate<Rating> filter) {
                new ArrayList<Rating>(Block.this.ratingList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void snippet(Predicate<Snippet> filter) {
                new ArrayList<Snippet>(Block.this.snippetList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void title(Predicate<Title> filter) {
                new ArrayList<Title>(Block.this.titleList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void breadcrumbs(Predicate<Breadcrumbs> filter) {
                new ArrayList<Breadcrumbs>(Block.this.breadcrumbsList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Block block() {
                Block newElement = (Block)Block.this.core$().graph().concept(Block.class).createNode(this.name, Block.this.core$()).as(Block.class);
                return newElement;
            }

            public CatalogLink catalogLink(Catalog catalog) {
                CatalogLink newElement = (CatalogLink)Block.this.core$().graph().concept(CatalogLink.class).createNode(this.name, Block.this.core$()).as(CatalogLink.class);
                newElement.core$().set((Layer)newElement, "catalog", Collections.singletonList(catalog));
                return newElement;
            }

            public Description description() {
                Description newElement = (Description)Block.this.core$().graph().concept(Description.class).createNode(this.name, Block.this.core$()).as(Description.class);
                return newElement;
            }

            public Display display() {
                Display newElement = (Display)Block.this.core$().graph().concept(Display.class).createNode(this.name, Block.this.core$()).as(Display.class);
                return newElement;
            }

            public EmbeddedCatalog embeddedCatalog() {
                EmbeddedCatalog newElement = (EmbeddedCatalog)Block.this.core$().graph().concept(EmbeddedCatalog.class).createNode(this.name, Block.this.core$()).as(EmbeddedCatalog.class);
                return newElement;
            }

            public Highlight highlight() {
                Highlight newElement = (Highlight)Block.this.core$().graph().concept(Highlight.class).createNode(this.name, Block.this.core$()).as(Highlight.class);
                return newElement;
            }

            public Icon icon() {
                Icon newElement = (Icon)Block.this.core$().graph().concept(Icon.class).createNode(this.name, Block.this.core$()).as(Icon.class);
                return newElement;
            }

            public CustomIcon customIcon() {
                CustomIcon newElement = (CustomIcon)Block.this.core$().graph().concept(CustomIcon.class).createNode(this.name, Block.this.core$()).as(CustomIcon.class);
                return newElement;
            }

            public ItemLinks itemLinks() {
                ItemLinks newElement = (ItemLinks)Block.this.core$().graph().concept(ItemLinks.class).createNode(this.name, Block.this.core$()).as(ItemLinks.class);
                return newElement;
            }

            public Links links() {
                Links newElement = (Links)Block.this.core$().graph().concept(Links.class).createNode(this.name, Block.this.core$()).as(Links.class);
                return newElement;
            }

            public Location location() {
                Location newElement = (Location)Block.this.core$().graph().concept(Location.class).createNode(this.name, Block.this.core$()).as(Location.class);
                return newElement;
            }

            public OpenDialog openDialog() {
                OpenDialog newElement = (OpenDialog)Block.this.core$().graph().concept(OpenDialog.class).createNode(this.name, Block.this.core$()).as(OpenDialog.class);
                return newElement;
            }

            public Export export(List<String> options) {
                Export newElement = (Export)Block.this.core$().graph().concept(Export.class).createNode(this.name, Block.this.core$()).as(Export.class);
                newElement.core$().set((Layer)newElement, "options", options);
                return newElement;
            }

            public Download download(List<String> options) {
                Download newElement = (Download)Block.this.core$().graph().concept(Download.class).createNode(this.name, Block.this.core$()).as(Download.class);
                newElement.core$().set((Layer)newElement, "options", options);
                return newElement;
            }

            public Task task() {
                Task newElement = (Task)Block.this.core$().graph().concept(Task.class).createNode(this.name, Block.this.core$()).as(Task.class);
                return newElement;
            }

            public Page page() {
                Page newElement = (Page)Block.this.core$().graph().concept(Page.class).createNode(this.name, Block.this.core$()).as(Page.class);
                return newElement;
            }

            public Picture picture() {
                Picture newElement = (Picture)Block.this.core$().graph().concept(Picture.class).createNode(this.name, Block.this.core$()).as(Picture.class);
                return newElement;
            }

            public Rating rating() {
                Rating newElement = (Rating)Block.this.core$().graph().concept(Rating.class).createNode(this.name, Block.this.core$()).as(Rating.class);
                return newElement;
            }

            public Snippet snippet() {
                Snippet newElement = (Snippet)Block.this.core$().graph().concept(Snippet.class).createNode(this.name, Block.this.core$()).as(Snippet.class);
                return newElement;
            }

            public Title title() {
                Title newElement = (Title)Block.this.core$().graph().concept(Title.class).createNode(this.name, Block.this.core$()).as(Title.class);
                return newElement;
            }

            public Breadcrumbs breadcrumbs() {
                Breadcrumbs newElement = (Breadcrumbs)Block.this.core$().graph().concept(Breadcrumbs.class).createNode(this.name, Block.this.core$()).as(Breadcrumbs.class);
                return newElement;
            }
        }

        public static enum Layout {
            Vertical,
            Horizontal,
            Fixed,
            Flexible,
            Wrap,
            Center,
            Justified,
            StartJustified,
            CenterJustified,
            EndJustified;

        }

        public static enum Mode {
            Expanded,
            Simple;

        }
    }

    public class Clear
    extends Display.Clear {
        public Clear() {
            super(Mold.this);
        }

        public void block(Predicate<Block> filter) {
            new ArrayList<Block>(Mold.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Display.Create {
        public Create(String name) {
            super(Mold.this, name);
        }

        public Block block() {
            Block newElement = (Block)Mold.this.core$().graph().concept(Block.class).createNode(this.name, Mold.this.core$()).as(Block.class);
            return newElement;
        }
    }
}

