/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.CatalogView;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.DoubleLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MapView
extends CatalogView
implements Terminal {
    protected List<Center> centerList = new ArrayList<Center>();
    protected List<Zoom> zoomList = new ArrayList<Zoom>();

    public MapView(Node node) {
        super(node);
    }

    public List<Center> centerList() {
        return Collections.unmodifiableList(this.centerList);
    }

    public Center center(int index) {
        return this.centerList.get(index);
    }

    public List<Center> centerList(Predicate<Center> predicate) {
        return this.centerList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Zoom> zoomList() {
        return Collections.unmodifiableList(this.zoomList);
    }

    public Zoom zoom(int index) {
        return this.zoomList.get(index);
    }

    public List<Zoom> zoomList(Predicate<Zoom> predicate) {
        return this.zoomList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Center>(this.centerList).forEach(c -> components.add(c.core$()));
        new ArrayList<Zoom>(this.zoomList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("MapView$Center")) {
            this.centerList.add((Center)node.as(Center.class));
        }
        if (node.is("MapView$Zoom")) {
            this.zoomList.add((Zoom)node.as(Zoom.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("MapView$Center")) {
            this.centerList.remove(node.as(Center.class));
        }
        if (node.is("MapView$Zoom")) {
            this.zoomList.remove(node.as(Zoom.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Zoom
    extends Layer
    implements Terminal {
        protected int defaultZoom;
        protected int min;
        protected int max;

        public Zoom(Node node) {
            super(node);
        }

        public int defaultZoom() {
            return this.defaultZoom;
        }

        public int min() {
            return this.min;
        }

        public int max() {
            return this.max;
        }

        public Zoom defaultZoom(int value) {
            this.defaultZoom = value;
            return this;
        }

        public Zoom min(int value) {
            this.min = value;
            return this;
        }

        public Zoom max(int value) {
            this.max = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("defaultZoom", new ArrayList<Integer>(Collections.singletonList(this.defaultZoom)));
            map.put("min", new ArrayList<Integer>(Collections.singletonList(this.min)));
            map.put("max", new ArrayList<Integer>(Collections.singletonList(this.max)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("defaultZoom")) {
                this.defaultZoom = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("min")) {
                this.min = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("max")) {
                this.max = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("defaultZoom")) {
                this.defaultZoom = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("min")) {
                this.min = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("max")) {
                this.max = (Integer)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Center
    extends Layer
    implements Terminal {
        protected double latitude;
        protected double longitude;

        public Center(Node node) {
            super(node);
        }

        public double latitude() {
            return this.latitude;
        }

        public double longitude() {
            return this.longitude;
        }

        public Center latitude(double value) {
            this.latitude = value;
            return this;
        }

        public Center longitude(double value) {
            this.longitude = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("latitude", new ArrayList<Double>(Collections.singletonList(this.latitude)));
            map.put("longitude", new ArrayList<Double>(Collections.singletonList(this.longitude)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("latitude")) {
                this.latitude = (Double)DoubleLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("longitude")) {
                this.longitude = (Double)DoubleLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("latitude")) {
                this.latitude = (Double)values.get(0);
            } else if (name.equalsIgnoreCase("longitude")) {
                this.longitude = (Double)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
        public void center(Predicate<Center> filter) {
            new ArrayList<Center>(MapView.this.centerList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void zoom(Predicate<Zoom> filter) {
            new ArrayList<Zoom>(MapView.this.zoomList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends CatalogView.Create {
        public Create(String name) {
            super(MapView.this, name);
        }

        public Center center(double latitude, double longitude) {
            Center newElement = (Center)MapView.this.core$().graph().concept(Center.class).createNode(this.name, MapView.this.core$()).as(Center.class);
            newElement.core$().set((Layer)newElement, "latitude", Collections.singletonList(latitude));
            newElement.core$().set((Layer)newElement, "longitude", Collections.singletonList(longitude));
            return newElement;
        }

        public Zoom zoom(int defaultZoom, int min, int max) {
            Zoom newElement = (Zoom)MapView.this.core$().graph().concept(Zoom.class).createNode(this.name, MapView.this.core$()).as(Zoom.class);
            newElement.core$().set((Layer)newElement, "defaultZoom", Collections.singletonList(defaultZoom));
            newElement.core$().set((Layer)newElement, "min", Collections.singletonList(min));
            newElement.core$().set((Layer)newElement, "max", Collections.singletonList(max));
            return newElement;
        }
    }
}

