/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Option;
import io.intino.konos.model.graph.Options;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Layout
extends Display
implements Terminal {
    protected Mode mode;
    protected List<Option> optionList = new ArrayList<Option>();
    protected List<Options> optionsList = new ArrayList<Options>();
    protected List<Group> groupList = new ArrayList<Group>();

    public Layout(Node node) {
        super(node);
    }

    public Mode mode() {
        return this.mode;
    }

    public Layout mode(Mode value) {
        this.mode = value;
        return this;
    }

    public List<Option> optionList() {
        return Collections.unmodifiableList(this.optionList);
    }

    public Option option(int index) {
        return this.optionList.get(index);
    }

    public List<Option> optionList(Predicate<Option> predicate) {
        return this.optionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Options> optionsList() {
        return Collections.unmodifiableList(this.optionsList);
    }

    public Options options(int index) {
        return this.optionsList.get(index);
    }

    public List<Options> optionsList(Predicate<Options> predicate) {
        return this.optionsList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Group> groupList() {
        return Collections.unmodifiableList(this.groupList);
    }

    public Group group(int index) {
        return this.groupList.get(index);
    }

    public List<Group> groupList(Predicate<Group> predicate) {
        return this.groupList().stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<Option>(this.optionList).forEach(c -> components.add(c.core$()));
        new ArrayList<Options>(this.optionsList).forEach(c -> components.add(c.core$()));
        new ArrayList<Group>(this.groupList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Option")) {
            this.optionList.add((Option)node.as(Option.class));
        }
        if (node.is("Options")) {
            this.optionsList.add((Options)node.as(Options.class));
        }
        if (node.is("Layout$Group")) {
            this.groupList.add((Group)node.as(Group.class));
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Option")) {
            this.optionList.remove(node.as(Option.class));
        }
        if (node.is("Options")) {
            this.optionsList.remove(node.as(Options.class));
        }
        if (node.is("Layout$Group")) {
            this.groupList.remove(node.as(Group.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("mode")) {
            this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("mode")) {
            this.mode = (Mode)((Object)values.get(0));
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Group
    extends Layer
    implements Terminal {
        protected String label;
        protected Mode mode;
        protected List<Option> optionList = new ArrayList<Option>();
        protected List<Options> optionsList = new ArrayList<Options>();

        public Group(Node node) {
            super(node);
        }

        public String label() {
            return this.label;
        }

        public Mode mode() {
            return this.mode;
        }

        public Group label(String value) {
            this.label = value;
            return this;
        }

        public Group mode(Mode value) {
            this.mode = value;
            return this;
        }

        public List<Option> optionList() {
            return Collections.unmodifiableList(this.optionList);
        }

        public Option option(int index) {
            return this.optionList.get(index);
        }

        public List<Option> optionList(Predicate<Option> predicate) {
            return this.optionList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Options> optionsList() {
            return Collections.unmodifiableList(this.optionsList);
        }

        public Options options(int index) {
            return this.optionsList.get(index);
        }

        public List<Options> optionsList(Predicate<Options> predicate) {
            return this.optionsList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Option>(this.optionList).forEach(c -> components.add(c.core$()));
            new ArrayList<Options>(this.optionsList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Option")) {
                this.optionList.add((Option)node.as(Option.class));
            }
            if (node.is("Options")) {
                this.optionsList.add((Options)node.as(Options.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Option")) {
                this.optionList.remove(node.as(Option.class));
            }
            if (node.is("Options")) {
                this.optionsList.remove(node.as(Options.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            } else if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)values.get(0));
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void option(Predicate<Option> filter) {
                new ArrayList<Option>(Group.this.optionList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void options(Predicate<Options> filter) {
                new ArrayList<Options>(Group.this.optionsList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Option option(String label) {
                Option newElement = (Option)Group.this.core$().graph().concept(Option.class).createNode(this.name, Group.this.core$()).as(Option.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public Options options() {
                Options newElement = (Options)Group.this.core$().graph().concept(Options.class).createNode(this.name, Group.this.core$()).as(Options.class);
                return newElement;
            }
        }

        public static enum Mode {
            Expanded,
            Collapsed;

        }
    }

    public class Clear
    extends Display.Clear {
        public void option(Predicate<Option> filter) {
            new ArrayList<Option>(Layout.this.optionList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void options(Predicate<Options> filter) {
            new ArrayList<Options>(Layout.this.optionsList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void group(Predicate<Group> filter) {
            new ArrayList<Group>(Layout.this.groupList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Display.Create {
        public Create(String name) {
            super(name);
        }

        public Option option(String label) {
            Option newElement = (Option)Layout.this.core$().graph().concept(Option.class).createNode(this.name, Layout.this.core$()).as(Option.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Options options() {
            Options newElement = (Options)Layout.this.core$().graph().concept(Options.class).createNode(this.name, Layout.this.core$()).as(Options.class);
            return newElement;
        }

        public Group group(String label, Group.Mode mode) {
            Group newElement = (Group)Layout.this.core$().graph().concept(Group.class).createNode(this.name, Layout.this.core$()).as(Group.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "mode", Collections.singletonList(mode));
            return newElement;
        }
    }

    public static enum Mode {
        Menu,
        Tab;

    }
}

