/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display.prototypes;

import cottons.utils.StringHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Display;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.Frame;

public abstract class PrototypeRenderer {
    static final String DISPLAYS = "displays";
    protected final Display display;
    protected final String box;
    protected final String packageName;
    protected final File src;
    private final File gen;

    PrototypeRenderer(Display display, String box, String packageName, File src, File gen) {
        this.display = display;
        this.box = box;
        this.packageName = packageName;
        this.src = src;
        this.gen = gen;
    }

    void writeAbstract(Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)("Abstract" + Commons.firstUpperCase(this.display.name$()) + ((Object)((Object)this.display)).getClass().getSimpleName()));
        Commons.writeFrame(new File(this.gen, DISPLAYS), newDisplay, this.template().format((Object)frame));
    }

    void writeSrc(Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)(this.display.name$() + ((Object)((Object)this.display)).getClass().getSimpleName()));
        if (!Commons.javaFile(new File(this.src, DISPLAYS), newDisplay).exists()) {
            Commons.writeFrame(new File(this.src, DISPLAYS), newDisplay, this.template().format((Object)frame));
        }
    }

    protected abstract Template template();

    protected Template customize(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
        return template;
    }

    protected Frame createFrame() {
        return new Frame(new String[]{((Object)((Object)this.display)).getClass().getSimpleName().toLowerCase()}).addSlot("box", new String[]{this.box}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{this.display.name$()});
    }
}

