/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display.prototypes;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.AbstractMoldTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.MoldTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.PrototypeRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Mold;
import io.intino.tara.magritte.Layer;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class MoldRenderer
extends PrototypeRenderer {
    private final Project project;
    private final Mold mold;

    public MoldRenderer(Project project, Mold mold, File src, File gen, String packageName, String boxName) {
        super(mold, boxName, packageName, src, gen);
        this.project = project;
        this.mold = mold;
    }

    public void render() {
        Frame frame = this.createFrame();
        frame.addSlot("moldType", new String[]{this.mold.modelClass()});
        for (Mold.Block block : this.mold.blockList()) {
            frame.addSlot("block", new AbstractFrame[]{this.frameOf(block)});
        }
        this.writeSrc(frame);
        this.writeAbstract(frame);
    }

    private Frame frameOf(Mold.Block block) {
        Frame frame = new Frame(new String[]{"block"}).addSlot("name", new String[]{this.clean(block.name$())}).addSlot("expanded", new Boolean[]{block.mode().equals((Object)Mold.Block.Mode.Expanded)}).addSlot("layout", (String[])block.layout().stream().map(Enum::name).toArray(String[]::new));
        if (!block.style().isEmpty()) {
            frame.addSlot("style", new String[]{block.style()});
        }
        if (block.height() >= 0) {
            frame.addSlot("height", new Integer[]{block.height()});
        }
        for (Mold.Block.Stamp stamp : block.stampList()) {
            frame.addSlot("stamp", new AbstractFrame[]{this.frameOf(stamp)});
        }
        for (Mold.Block inner : block.blockList()) {
            frame.addSlot("block", new AbstractFrame[]{this.frameOf(inner)});
        }
        return frame;
    }

    private <T extends Layer> Frame frameOf(Mold.Block.Stamp stamp) {
        Frame frame = new Frame(new String[]{"stamp", ((Object)((Object)stamp)).getClass().getSimpleName()});
        frame.addSlot("name", new String[]{stamp.name$()});
        frame.addSlot("type", new String[]{((Object)((Object)stamp)).getClass().getSimpleName()});
        frame.addSlot("common", new AbstractFrame[]{this.common(stamp)});
        frame.addSlot("mold", new String[]{this.mold.name$()});
        frame.addSlot("moldType", new String[]{this.mold.modelClass()});
        if (stamp.i$(Mold.Block.Picture.class)) {
            this.frameOf(frame, (Mold.Block.Picture)stamp.a$(Mold.Block.Picture.class));
        }
        if (stamp.i$(Mold.Block.Tree.class)) {
            this.frameOf(frame, (Mold.Block.Tree)stamp.a$(Mold.Block.Tree.class));
        }
        if (stamp.i$(Mold.Block.Location.class)) {
            this.frameOf(frame, (Mold.Block.Location)stamp.a$(Mold.Block.Location.class));
        }
        if (stamp.i$(Mold.Block.Operation.class)) {
            this.frameOf(frame, (Mold.Block.Operation)stamp.a$(Mold.Block.Operation.class));
        }
        return frame;
    }

    @NotNull
    private Frame common(Mold.Block.Stamp stamp) {
        Frame frame = this.baseFrame(stamp).addTypes(new String[]{"common"});
        if (!stamp.defaultStyle().isEmpty()) {
            frame.addSlot("defaultStyle", new AbstractFrame[]{this.baseFrame(stamp)});
        }
        frame.addSlot("editable", new Boolean[]{stamp.editable()});
        frame.addSlot("valueType", new String[]{"String"});
        if (stamp.height() >= 0) {
            frame.addSlot("height", new Integer[]{stamp.height()});
        }
        if (!stamp.label().isEmpty()) {
            frame.addSlot("label", new String[]{stamp.label()});
        }
        if (!stamp.suffix().isEmpty()) {
            frame.addSlot("suffix", new String[]{stamp.suffix()});
        }
        Frame frame2 = frame;
        if (frame2 == null) {
            MoldRenderer.$$$reportNull$$$0(0);
        }
        return frame2;
    }

    private void frameOf(Frame frame, Mold.Block.Picture stamp) {
        if (stamp.defaultPicture() != null) {
            frame.addSlot("defaultPicture", new String[]{stamp.defaultPicture().getPath()});
        }
    }

    private void frameOf(Frame frame, Mold.Block.Tree stamp) {
        if (stamp.root() != null) {
            frame.addSlot("root", new String[]{stamp.root().name$()});
        }
        this.frameOf(frame, stamp.treeItemList());
    }

    private void frameOf(Frame frame, Mold.Block.Location stamp) {
        frame.addSlot("icon", new AbstractFrame[]{this.baseFrame(stamp)});
    }

    private void frameOf(Frame frame, Mold.Block.Operation operation) {
        frame.addSlot("operationType", new String[]{((Object)((Object)operation)).getClass().getSimpleName()}).addTypes(new String[]{"operation"});
        if (operation.i$(Mold.Block.OpenDialog.class)) {
            frame.addSlot("width", new Integer[]{((Mold.Block.OpenDialog)operation.a$(Mold.Block.OpenDialog.class)).width()});
        }
        if (operation.i$(Mold.Block.Download.class)) {
            frame.addSlot("options", new Object[]{((Mold.Block.Download)operation.a$(Mold.Block.Download.class)).options()});
        }
        if (operation.i$(Mold.Block.Export.class)) {
            Mold.Block.Export export = (Mold.Block.Export)operation.a$(Mold.Block.Export.class);
            frame.addSlot("options", new Object[]{export.options()});
            if (export.from() != null) {
                frame.addSlot("from", new Long[]{export.from().toEpochMilli()});
            }
            if (export.to() != null) {
                frame.addSlot("to", new Object[]{export.to()});
            }
        }
    }

    private void frameOf(Frame frame, List<Mold.Block.Tree.TreeItem> treeItems) {
        for (Mold.Block.Tree.TreeItem item : treeItems) {
            Frame sub = new Frame(new String[]{"treeItem"}).addSlot("label", new String[]{item.label()});
            if (!item.treeItemList().isEmpty()) {
                this.frameOf(sub, item.treeItemList());
            }
            frame.addSlot("treeItem", new AbstractFrame[]{sub});
        }
    }

    private Frame baseFrame(Mold.Block.Stamp stamp) {
        return new Frame(new String[]{((Object)((Object)stamp)).getClass().getSimpleName()}).addSlot("mold", new String[]{this.mold.name$()}).addSlot("name", new String[]{stamp.name$()}).addSlot("moldType", new String[]{this.mold.modelClass()});
    }

    @Override
    protected Template template() {
        return this.customize(AbstractMoldTemplate.create());
    }

    @Override
    void writeSrc(Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)(this.display.name$() + ((Object)((Object)this.display)).getClass().getSimpleName()));
        if (!Commons.javaFile(new File(this.src, "displays"), newDisplay).exists()) {
            Commons.writeFrame(new File(this.src, "displays"), newDisplay, this.srcTemplate().format((Object)frame));
        }
    }

    private Template srcTemplate() {
        return this.customize(MoldTemplate.create());
    }

    private String clean(String name) {
        return name.replace("-", "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/services/activity/display/prototypes/MoldRenderer", "common"));
    }
}

