/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display.prototypes;

import com.intellij.openapi.project.Project;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.LayoutTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.PrototypeRenderer;
import io.intino.konos.model.graph.Layout;
import io.intino.konos.model.graph.Option;
import io.intino.konos.model.graph.RenderCatalog;
import io.intino.konos.model.graph.RenderPanel;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class LayoutRenderer
extends PrototypeRenderer {
    private final Project project;

    public LayoutRenderer(Project project, Layout layout, File src, File gen, String packageName, String boxName) {
        super(layout, boxName, packageName, src, gen);
        this.project = project;
    }

    public void render() {
        Frame frame = this.createFrame();
        this.writeSrc(frame);
        this.writeAbstract(frame.addTypes(new String[]{"gen"}));
    }

    @Override
    protected Frame createFrame() {
        Layout layout = (Layout)this.display.a$(Layout.class);
        Frame frame = super.createFrame();
        frame.addSlot("mode", new String[]{layout.mode().name()});
        frame.addSlot("group", (AbstractFrame[])this.framesOf(layout.groupList()));
        return frame;
    }

    private Frame[] framesOf(List<Layout.Group> groups) {
        return (Frame[])groups.stream().map(this::framesOf).toArray(Frame[]::new);
    }

    private Frame framesOf(Layout.Group group) {
        Frame frame = new Frame(new String[]{"group"}).addSlot("label", new String[]{group.label()}).addSlot("mode", new Object[]{group.mode()});
        if (!group.optionList().isEmpty()) {
            frame.addSlot("option", (AbstractFrame[])this.optionFramesOf(group.optionList()));
        }
        return frame;
    }

    private Frame[] optionFramesOf(List<Option> options) {
        return (Frame[])options.stream().map(this::framesOf).toArray(Frame[]::new);
    }

    private Frame framesOf(Option option) {
        Frame frame = new Frame(new String[]{"option", option.elementRenderer() instanceof RenderCatalog ? "catalog" : "panel"}).addSlot("label", new String[]{option.label()});
        if (option.elementRenderer() instanceof RenderCatalog) {
            frame.addSlot("catalog", new String[]{((RenderCatalog)option.elementRenderer().a$(RenderCatalog.class)).catalog().name$()});
        } else {
            frame.addSlot("panel", new String[]{((RenderPanel)option.elementRenderer().a$(RenderPanel.class)).panel().name$()});
        }
        return frame;
    }

    @Override
    protected Template template() {
        return this.customize(LayoutTemplate.create());
    }
}

