/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display.prototypes;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.AbstractCatalogTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.CatalogTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.prototypes.PrototypeRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.CatalogView;
import io.intino.konos.model.graph.DisplayView;
import io.intino.konos.model.graph.Operation;
import io.intino.tara.magritte.Node;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class CatalogRenderer
extends PrototypeRenderer {
    private final Project project;
    private final String modelClass;

    public CatalogRenderer(Project project, Catalog catalog, File src, File gen, String packageName, String box) {
        super(catalog, box, packageName, src, gen);
        this.project = project;
        this.modelClass = catalog.modelClass();
    }

    public void render() {
        Frame frame = this.createFrame();
        this.writeSrc(frame);
        this.writeAbstract(frame.addTypes(new String[]{"gen"}));
    }

    @Override
    protected Frame createFrame() {
        Catalog catalog = (Catalog)this.display.a$(Catalog.class);
        Frame frame = super.createFrame().addSlot("label", new String[]{catalog.label()}).addSlot("type", new String[]{this.modelClass});
        this.toolbar(catalog, frame);
        this.views(catalog, frame);
        this.arrangements(catalog, frame);
        return frame;
    }

    private void toolbar(Catalog catalog, Frame frame) {
        if (catalog.toolbar() != null) {
            frame.addSlot("toolbar", new AbstractFrame[]{this.frameOf(catalog.toolbar())});
            if (catalog.toolbar().groupingSelection() != null) {
                frame.addSlot("groupingselection", new String[]{""});
            }
        }
    }

    private void views(Catalog catalog, Frame frame) {
        for (CatalogView view : catalog.views().catalogViewList()) {
            frame.addSlot("view", new AbstractFrame[]{this.frameOf(view, catalog)});
        }
        if (catalog.views().displayView() != null) {
            frame.addSlot("view", new AbstractFrame[]{this.frameOf(catalog.views().displayView(), catalog)});
        }
    }

    private void arrangements(Catalog catalog, Frame frame) {
        if (catalog.arrangement() == null) {
            return;
        }
        for (Catalog.Arrangement.Grouping grouping : catalog.arrangement().groupingList()) {
            frame.addSlot("arrangement", new AbstractFrame[]{this.frameOf(grouping, catalog)});
        }
        for (Catalog.Arrangement.Sorting sorting : catalog.arrangement().sortingList()) {
            frame.addSlot("arrangement", new AbstractFrame[]{this.frameOf(sorting, catalog)});
        }
    }

    private Frame frameOf(Catalog.Arrangement.Sorting sorting, Catalog catalog) {
        return new Frame(new String[]{"arrangement", ((Object)((Object)sorting)).getClass().getSimpleName().toLowerCase()}).addSlot("box", new String[]{this.box}).addSlot("name", new String[]{sorting.name$()}).addSlot("label", new String[]{sorting.label()}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("type", new String[]{this.modelClass});
    }

    private Frame frameOf(Catalog.Arrangement.Grouping grouping, Catalog catalog) {
        return new Frame(new String[]{"arrangement", ((Object)((Object)grouping)).getClass().getSimpleName().toLowerCase()}).addSlot("box", new String[]{this.box}).addSlot("name", new String[]{grouping.name$()}).addSlot("label", new String[]{grouping.label()}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("type", new String[]{this.modelClass}).addSlot("histogram", new Object[]{grouping.histogram()});
    }

    private Frame frameOf(CatalogView view, Catalog catalog) {
        return new Frame(new String[]{"view", ((Object)((Object)view)).getClass().getSimpleName()}).addSlot("label", new String[]{view.label()}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{view.name$()});
    }

    private Frame frameOf(DisplayView view, Catalog catalog) {
        return new Frame(new String[]{"view", ((Object)((Object)view)).getClass().getSimpleName()}).addSlot("box", new String[]{this.box}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("name", new String[]{view.name$()}).addSlot("package", new String[]{this.packageName}).addSlot("display", new String[]{view.display()});
    }

    private Frame frameOf(Catalog.Toolbar toolbar) {
        Frame frame = new Frame(new String[]{"toolbar"});
        Node owner = toolbar.core$().owner();
        frame.addSlot("box", new String[]{this.box}).addSlot("type", new String[]{this.modelClass}).addSlot("canSearch", new Boolean[]{toolbar.canSearch()});
        if (toolbar.download() != null) {
            frame.addSlot("operation", new AbstractFrame[]{this.frameOf(toolbar.download(), owner)});
        }
        if (toolbar.export() != null) {
            frame.addSlot("operation", new AbstractFrame[]{this.frameOf(toolbar.export(), owner)});
        }
        if (toolbar.openDialog() != null) {
            frame.addSlot("operation", new AbstractFrame[]{this.frameOf(toolbar.openDialog(), owner)});
        }
        if (toolbar.task() != null) {
            frame.addSlot("operation", new AbstractFrame[]{this.frameOf(toolbar.task(), owner)});
        }
        if (toolbar.taskSelection() != null) {
            frame.addSlot("operation", new AbstractFrame[]{this.taskSelectionFrameOf(toolbar.taskSelection(), owner)});
        }
        if (toolbar.exportSelection() != null) {
            frame.addSlot("operation", new AbstractFrame[]{this.frameOf(toolbar.exportSelection(), owner)});
        }
        if (toolbar.downloadSelection() != null) {
            frame.addSlot("operation", new AbstractFrame[]{this.frameOf(toolbar.downloadSelection(), owner)});
        }
        if (toolbar.groupingSelection() != null) {
            frame.addSlot("operation", new AbstractFrame[]{this.frameOf(toolbar.groupingSelection(), owner)});
        }
        return frame;
    }

    private Frame taskSelectionFrameOf(Catalog.Toolbar.TaskSelection task, Node owner) {
        return this.frameOf(task, owner).addSlot("refresh", new String[]{task.refresh().name()});
    }

    private Frame frameOf(Operation operation, Node catalog) {
        Frame frame = new Frame(new String[]{"operation", ((Object)((Object)operation)).getClass().getSimpleName().toLowerCase()}).addSlot("name", new String[]{operation.name$()}).addSlot("box", new String[]{this.box}).addSlot("type", new String[]{this.modelClass}).addSlot("title", new String[]{operation.title()}).addSlot("catalog", new String[]{catalog.name()});
        if (operation.alexandriaIcon() != null) {
            frame.addSlot("icon", new String[]{operation.alexandriaIcon()});
        }
        return frame;
    }

    @Override
    protected Template template() {
        return this.customize(AbstractCatalogTemplate.create());
    }

    protected Template srcTemplate() {
        return this.customize(CatalogTemplate.create());
    }

    @Override
    void writeSrc(Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)(this.display.name$() + ((Object)((Object)this.display)).getClass().getSimpleName()));
        if (!Commons.javaFile(new File(this.src, "displays"), newDisplay).exists()) {
            Commons.writeFrame(new File(this.src, "displays"), newDisplay, this.srcTemplate().format((Object)frame));
        }
    }
}

