/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display;

import java.util.Locale;
import org.siani.itrules.LineSeparator;
import org.siani.itrules.Template;
import org.siani.itrules.model.Condition;
import org.siani.itrules.model.Rule;
import org.siani.itrules.model.Token;

public class ElementDisplaysTemplate
extends Template {
    protected ElementDisplaysTemplate(Locale locale, LineSeparator separator) {
        super(locale, separator);
    }

    public static Template create() {
        return new ElementDisplaysTemplate(Locale.ENGLISH, LineSeparator.LF).define();
    }

    public Template define() {
        this.add(new Rule[]{this.rule().add(new Condition[]{this.condition("type", "elementDisplays")}).add((Token.Body)this.literal("package ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".displays;\n\nimport io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;\nimport io.intino.konos.alexandria.activity.displays.*;\nimport io.intino.konos.alexandria.activity.model.*;\nimport ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box;\n\nimport java.lang.reflect.Constructor;\nimport java.lang.reflect.InvocationTargetException;\nimport java.util.HashMap;\nimport java.util.Map;\n\npublic class ElementDisplays {\n\tprivate static Map<String, ComponentCreator> elementMap = new HashMap<>();\n\n\tstatic {\n\t\t{\n\t\t\t")).add((Token.Body)this.mark("display", new String[0]).multiple("\n")).add((Token.Body)this.literal("\n\t\t}\n\t}\n\n\tpublic static AlexandriaElementDisplay displayFor(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box, String name) {\n\t\tif (!elementMap.containsKey(name)) return null;\n\t\treturn elementMap.get(name).build(box);\n\t}\n\n\tpublic static AlexandriaElementDisplay displayFor(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box, Element element) {\n\t\tif (!elementMap.containsKey(element.name())) return defaultElementDisplay(box, element);\n\t\treturn elementMap.get(element.name()).build(box);\n\t}\n\n\tpublic static Class<? extends AlexandriaElementDisplay> displayTypeFor(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box, Element element) {\n\t\tif (!elementMap.containsKey(element.name())) return defaultElementType(box, element);\n\t\treturn elementMap.get(element.name()).build(box).getClass();\n\t}\n\n\tprivate static Class<? extends AlexandriaElementDisplay> defaultElementType(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box, Element element) {\n\t\tif (element instanceof Panel) return AlexandriaPanelDisplay.class;\n\n\t\tif (element instanceof TemporalCatalog)\n\t\t\treturn ((TemporalCatalog) element).type() == TemporalCatalog.Type.Range ? AlexandriaTemporalRangeCatalogDisplay.class : AlexandriaTemporalTimeCatalogDisplay.class;\n\n\t\tif (element instanceof Catalog)\n\t\t\treturn AlexandriaCatalogDisplay.class;\n\n\t\tif (element instanceof Layout)\n\t\t\treturn ((Layout) element).mode() == Layout.Mode.Menu ? AlexandriaMenuLayoutDisplay.class : AlexandriaTabLayoutDisplay.class;\n\n\t\tif (element instanceof Desktop)\n\t\t\treturn AlexandriaDesktopDisplay.class;\n\n\t\treturn null;\n\t}\n\n\tprivate static AlexandriaElementDisplay defaultElementDisplay(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box, Element element) {\n\t\tif (element instanceof Panel) return new AlexandriaPanelDisplay(box);\n\n\t\tif (element instanceof TemporalCatalog)\n\t\t\treturn ((TemporalCatalog) element).type() == TemporalCatalog.Type.Range ? new AlexandriaTemporalRangeCatalogDisplay(box) : new AlexandriaTemporalTimeCatalogDisplay(box);\n\n\t\tif (element instanceof Catalog)\n\t\t\treturn new AlexandriaCatalogDisplay(box);\n\n\t\tif (element instanceof Layout)\n\t\t\treturn ((Layout) element).mode() == Layout.Mode.Menu ? new AlexandriaMenuLayoutDisplay(box) : new AlexandriaTabLayoutDisplay(box);\n\n\t\tif (element instanceof Desktop)\n\t\t\treturn new AlexandriaDesktopDisplay(box);\n\n\t\treturn null;\n\t}\n\n\tprivate interface ComponentCreator {\n\t\tAlexandriaElementDisplay build(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box);\n\t}\n}")), this.rule().add(new Condition[]{this.condition("trigger", "display")}).add((Token.Body)this.literal("elementMap.put(\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\", (box) -> new ")).add((Token.Body)this.mark("name", new String[]{"FirstUpperCase"})).add((Token.Body)this.mark("type", new String[]{"FirstUpperCase"})).add((Token.Body)this.literal("(box));"))});
        return this;
    }
}

